/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;

public class ClassArrayData
extends MemberData {
    String name;
    int[] classIndexes;

    protected ClassArrayData(ClassData classData, String attrName) {
        super(classData);
        this.name = attrName;
    }

    public ClassArrayData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        int number_of_classes = in.readUnsignedShort();
        if (attribute_length != 2 + number_of_classes * 2) {
            throw new ClassFormatError(this.name + "_attribute: Invalid attribute length");
        }
        this.classIndexes = new int[number_of_classes];
        for (int i = 0; i < number_of_classes; ++i) {
            this.classIndexes[i] = in.readUnsignedShort();
        }
        return this;
    }

    @Override
    public void print() {
        StringBuilder indexes = new StringBuilder();
        StringBuilder names = new StringBuilder();
        for (int classIndex : this.classIndexes) {
            if (this.printCPIndex) {
                indexes.append(indexes.length() == 0 ? "" : ", ").append("#").append(classIndex);
            }
            names.append(names.length() == 0 ? "" : ", ").append(this.pool.StringValue(classIndex));
        }
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.printIndentLn("%s %s;", this.name, indexes);
            } else {
                this.printIndent(this.PadRight(String.format("%s %s;", this.name, indexes), this.getCommentOffset() - 1)).println(" // " + names);
            }
        } else {
            this.printIndentLn("%s %s;", this.name, names.toString());
        }
    }
}

