/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.CFVersion;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Container;
import org.openjdk.asmtools.jdis.FieldData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.InnerClassData;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.ModuleData;
import org.openjdk.asmtools.jdis.NestHostData;
import org.openjdk.asmtools.jdis.NestMembersData;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.PermittedSubclassesData;
import org.openjdk.asmtools.jdis.PreloadData;
import org.openjdk.asmtools.jdis.Printable;
import org.openjdk.asmtools.jdis.RecordData;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.SourceDebugExtensionData;
import org.openjdk.asmtools.jdis.SourceFileData;
import org.openjdk.asmtools.jdis.TextLines;

public class ClassData
extends MemberData<ClassData> {
    protected CFVersion cfVersion = new CFVersion();
    protected int this_cpx;
    protected String className = "";
    protected String packageName = "";
    protected String classShortName = "";
    protected int super_cpx;
    protected int[] interfaces;
    protected Container<FieldData> fields;
    protected Container<MethodData> methods;
    protected SourceFileData sourceFileData;
    protected Container<InnerClassData> innerClasses;
    protected RecordData recordData;
    protected Container<BootstrapMethodData> bootstrapMethods;
    protected ModuleData moduleData;
    protected NestHostData nestHost;
    protected NestMembersData nestMembers;
    protected PermittedSubclassesData permittedSubclassesData;
    protected SourceDebugExtensionData sourceDebugExtensionData;
    protected PreloadData preloadData;
    private TextLines sourceLines = null;
    private Path classFile = null;

    public ClassData(JdisEnvironment environment) {
        super(environment);
        this.memberType = "ClassData";
        this.environment = environment;
        environment.traceln("printOptions=" + Options.asShortString(), new Object[0]);
        this.pool = new ConstantPool(this);
        super.init(this);
    }

    public void read(File inputFile) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(inputFile));){
            this.read(dis, inputFile.toPath());
        }
    }

    public void read(String inputFileName) throws IOException {
        try (DataInputStream dis = new DataInputStream(new FileInputStream(inputFileName));){
            this.read(dis, Paths.get(inputFileName, new String[0]));
        }
    }

    protected void readFields(DataInputStream in) throws IOException {
        int nFields = in.readUnsignedShort();
        this.environment.traceln("fields=#" + nFields, new Object[0]);
        this.fields = new Container(nFields);
        for (int k = 0; k < nFields; ++k) {
            FieldData field = new FieldData(this);
            this.environment.traceln("  FieldData: #" + k, new Object[0]);
            field.read(in);
            this.fields.add(field);
        }
    }

    protected void readMethods(DataInputStream in) throws IOException {
        int nMethods = in.readUnsignedShort();
        this.environment.traceln("methods=#" + nMethods, new Object[0]);
        this.methods = new Container(nMethods);
        for (int k = 0; k < nMethods; ++k) {
            MethodData method = new MethodData(this);
            this.environment.traceln("MethodData: #" + k, new Object[0]);
            method.read(in);
            this.methods.add(method);
        }
    }

    protected void readInterfaces(DataInputStream in) throws IOException {
        int nInterfaces = in.readUnsignedShort();
        this.environment.traceln("interfaces=#" + nInterfaces, new Object[0]);
        this.interfaces = new int[nInterfaces];
        for (int i = 0; i < nInterfaces; ++i) {
            short interfaceCpx = in.readShort();
            this.environment.traceln("  InterfaceCpx[" + i + "]=" + interfaceCpx, new Object[0]);
            this.interfaces[i] = interfaceCpx;
        }
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        switch (attributeTag) {
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "ClassFile");
                }
                this.signature = new SignatureData(this).read(in, attributeLength);
                break;
            }
            case ATT_SourceFile: {
                if (attributeLength != 2) {
                    throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", "SourceFile_attribute", attributeLength);
                }
                if (this.sourceFileData != null) {
                    this.environment.warning("warn.one.attribute.required", "SourceFile", "ClassFile");
                }
                this.sourceFileData = new SourceFileData(this).read(in, attributeLength);
                break;
            }
            case ATT_SourceDebugExtension: {
                this.sourceDebugExtensionData = new SourceDebugExtensionData(this).read(in, attributeLength);
                break;
            }
            case ATT_InnerClasses: {
                int count = in.readUnsignedShort();
                if (2 + count * 8 != attributeLength) {
                    throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", "InnerClasses_attribute", attributeLength);
                }
                this.innerClasses = new Container(count);
                for (int j = 0; j < count; ++j) {
                    InnerClassData innerClass = new InnerClassData(this);
                    innerClass.read(in);
                    this.innerClasses.add(innerClass);
                }
                break;
            }
            case ATT_BootstrapMethods: {
                int count = in.readUnsignedShort();
                this.bootstrapMethods = new Container(count).setPrintable(this.printCPIndex);
                for (int j = 0; j < count; ++j) {
                    BootstrapMethodData bsmData = new BootstrapMethodData(this);
                    bsmData.read(in);
                    this.bootstrapMethods.add(bsmData);
                }
                break;
            }
            case ATT_Module: {
                this.moduleData = new ModuleData(this);
                this.moduleData.read(in);
                break;
            }
            case ATT_NestHost: {
                this.nestHost = new NestHostData(this).read(in, attributeLength);
                break;
            }
            case ATT_NestMembers: {
                this.nestMembers = new NestMembersData(this).read(in, attributeLength);
                break;
            }
            case ATT_Record: {
                this.recordData = new RecordData(this).read(in);
                break;
            }
            case ATT_PermittedSubclasses: {
                this.permittedSubclassesData = new PermittedSubclassesData(this).read(in, attributeLength);
                break;
            }
            case ATT_Preload: {
                this.preloadData = new PreloadData(this).read(in, attributeLength);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in, Path src) throws IOException {
        this.classFile = src;
        try {
            int magic = in.readInt();
            if (magic != -889275714) {
                throw new ClassCastException("wrong magic: " + HexUtils.toHex(magic) + ", expected " + HexUtils.toHex(-889275714));
            }
            this.cfVersion.setMinorVersion(in.readUnsignedShort());
            this.cfVersion.setMajorVersion(in.readUnsignedShort());
            this.pool.read(in);
            this.access = in.readUnsignedShort();
            this.this_cpx = in.readUnsignedShort();
            this.super_cpx = in.readUnsignedShort();
            this.environment.traceln("0x%04X [ %s] this_cpx=%d super_cpx=%d", this.access, EModifier.asNames(this.access, EModifier.isModule(this.access) ? ClassFileContext.CLASS : ClassFileContext.MODULE), this.this_cpx, this.super_cpx);
            this.readInterfaces(in);
            this.readFields(in);
            this.readMethods(in);
            this.readAttributes(in);
            this.initClassNames(this.this_cpx);
            this.environment.traceln("\n<< Reading is done >>", new Object[0]);
        }
        catch (EOFException eofException) {
            throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.eof", new Object[0]);
        }
    }

    private void initClassNames(int this_cpx) {
        this.className = this.pool.getClassName(this_cpx);
        int idx = this.className.lastIndexOf(47);
        if (idx != -1) {
            this.packageName = this.className.substring(0, idx);
            this.classShortName = this.className.substring(idx + 1);
        } else {
            this.classShortName = this.className;
        }
        if (this.sourceFileData != null) {
            this.sourceFileData.setSourceName();
        }
    }

    public boolean hasPackage() {
        return this.packageName.length() != 0;
    }

    public String getSrcLine(int lineNum) {
        String line;
        if (this.sourceLines == null) {
            return null;
        }
        try {
            line = this.sourceLines.getLine(lineNum);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            line = String.format("Line number %d is out of bounds", lineNum);
        }
        return line;
    }

    @SafeVarargs
    private <T extends AnnotationData> void printAnnotations(List<T> ... annotationLists) throws IOException {
        if (annotationLists != null) {
            for (List<T> list : annotationLists) {
                if (list == null) continue;
                for (AnnotationData annotation : list) {
                    annotation.initIndent(0);
                    annotation.print();
                    this.println();
                }
            }
        }
    }

    @Override
    public void print() throws IOException {
        int numCorruptedAttributes = 0;
        if (this.className.endsWith("module-info") || EModifier.isModule(this.access)) {
            this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            if (this.moduleData == null) {
                this.moduleData = new ModuleData(this);
            }
            this.print(this.moduleData.getModuleHeader(String.format("version %s", this.cfVersion.asString())));
            this.println();
            this.println("{");
            if (this.printConstantPool) {
                this.pool.print();
            }
            this.moduleData.print();
            this.print(String.format("} // end of module %s", this.moduleData.getModuleName()));
            if (this.moduleData.getModuleVersion() != null) {
                this.print("@" + this.moduleData.getModuleVersion());
            }
            this.println();
        } else if (this.className.endsWith("package-info")) {
            if (this.printConstantPool) {
                this.pool.print();
            }
            this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            this.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
            if (this.hasPackage()) {
                this.println(String.format("package %s version %s;", this.packageName, this.cfVersion.asString()));
            }
        } else {
            String sourceName;
            Pair<String, String> signInfo;
            if (this.hasPackage()) {
                this.println(String.format("package %s;%n", this.packageName));
            }
            this.printAnnotations(this.visibleAnnotations, this.invisibleAnnotations);
            this.printAnnotations(this.visibleTypeAnnotations, this.invisibleTypeAnnotations);
            String name = this.pool.inRange(this.this_cpx) ? this.pool.getShortClassName(this.this_cpx, this.packageName) : "?? invalid index";
            Pair<String, String> pair = signInfo = this.signature != null ? this.signature.getPrintInfo(i -> this.pool.inRange((int)i)) : new Pair<String, String>("", "");
            if (EModifier.isInterface(this.access)) {
                this.print(EModifier.asKeywords(this.access & ~EModifier.ACC_ABSTRACT.getFlag(), ClassFileContext.CLASS));
                this.print(this.printCPIndex ? (this.skipComments ? String.format("interface #%d%s", this.this_cpx, signInfo.first) : String.format("interface #%d%s /* %s%s */", this.this_cpx, signInfo.first, name, signInfo.second)) : String.format("interface %s", name, signInfo.second));
            } else {
                this.print(EModifier.asKeywords(this.access, ClassFileContext.CLASS) + this.getPseudoFlagsAsString());
                this.print(this.printCPIndex ? (this.skipComments ? String.format("class #%d%s", this.this_cpx, signInfo.first) : String.format("class #%d%s /* %s%s */", this.this_cpx, signInfo.first, name, signInfo.second)) : String.format("class %s%s", name, signInfo.second));
                if (this.this_cpx < this.pool.size() && this.this_cpx > 0) {
                    if (!this.pool.getClassName(this.super_cpx).equals("java/lang/Object")) {
                        this.print(this.printCPIndex ? (this.skipComments ? String.format(" extends #%d", this.super_cpx) : String.format(" extends #%d /* %s */", this.super_cpx, this.pool.getShortClassName(this.super_cpx, this.packageName))) : String.format(" extends %s", this.pool.getShortClassName(this.super_cpx, this.packageName)));
                    }
                } else {
                    this.print(this.printCPIndex ? (this.skipComments ? String.format(" extends #%d", this.super_cpx) : String.format(" extends #%d /* ?? invalid index */", this.super_cpx)) : " extends ??");
                }
            }
            int numInterfaces = this.interfaces.length;
            if (numInterfaces > 0) {
                String statement;
                String sNames = Arrays.stream(this.interfaces).mapToObj(cpx -> this.pool.getShortClassName(cpx, this.packageName)).collect(Collectors.joining(", "));
                if (this.printCPIndex) {
                    String sIndexes = Arrays.stream(this.interfaces).mapToObj(cpx -> String.format("#%d", cpx)).collect(Collectors.joining(", "));
                    statement = this.skipComments ? String.format("%simplements %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sIndexes) : String.format("%simplements %s /* %s */", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sIndexes, sNames);
                } else {
                    statement = String.format("%simplements %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", sNames);
                }
                this.print(statement);
            }
            this.println("%sversion %s", numInterfaces > 1 ? "\n" + this.getIndentString() : " ", this.cfVersion.asString());
            this.println("{");
            if (this.printSourceLines && this.sourceFileData != null && (sourceName = this.sourceFileData.getSourceName()) != null) {
                this.sourceLines = new TextLines(this.classFile.getParent(), sourceName);
            }
            if (this.printConstantPool) {
                this.pool.print();
                this.setCommentOffset(this.pool.getCommentOffset());
            }
            List printableAttributes = this.getListOfPrintableAttributes(new Printable[]{this.sourceFileData, this.recordData, this.permittedSubclassesData, this.nestHost, this.nestMembers, this.innerClasses, this.preloadData, this.bootstrapMethods, this.sourceDebugExtensionData});
            if (this.printMemberDataList(this.fields, this.getCommentOffset()) && this.isPrintable(new Container[]{this.methods}) && !printableAttributes.isEmpty()) {
                this.println();
            }
            if (this.printMemberDataList(this.methods, this.getCommentOffset() - this.getIndentSize()) && !printableAttributes.isEmpty()) {
                this.println();
            }
            numCorruptedAttributes = this.printAttributes(this.getCommentOffset() - this.getIndentSize(), printableAttributes);
            if (this.skipComments) {
                this.println("}");
            } else {
                this.println(String.format("} // end Class %s%s", name, this.sourceFileData != null ? " compiled from \"" + this.sourceFileData.getSourceName() + "\"" : ""));
            }
        }
        List<IOException> issues = this.pool.getIssues();
        if (!issues.isEmpty()) {
            for (IOException ioe : issues) {
                this.environment.error(ioe);
            }
            throw new RuntimeException();
        }
    }

    private <P extends Printable> List<P> getListOfPrintableAttributes(P ... attributes) {
        return Arrays.stream(attributes).filter(a -> this.isPrintable(new Printable[]{a})).toList();
    }

    private <P extends Printable> boolean isPrintable(P ... attributes) {
        for (P attribute : attributes) {
            if (attribute == null || !attribute.isPrintable()) continue;
            if (attribute instanceof Container) {
                Container container = (Container)attribute;
                for (Printable item : container) {
                    if (!item.isPrintable()) continue;
                    return true;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private <P extends Printable> int printAttributes(int commentOffset, List<P> attributeList) throws IOException {
        int len = attributeList.size();
        boolean printed = false;
        for (int i = 0; i < len; ++i) {
            Printable attribute = (Printable)attributeList.get(i);
            if (this.isPrintable(new Printable[]{attribute})) {
                if (Container.class.isAssignableFrom(attribute.getClass())) {
                    for (Printable item : (Container)attribute) {
                        if (Indenter.class.isAssignableFrom(item.getClass())) {
                            ((Indenter)item).setCommentOffset(commentOffset);
                        }
                        item.print();
                    }
                } else {
                    if (Indenter.class.isAssignableFrom(attribute.getClass())) {
                        ((Indenter)attribute).setCommentOffset(commentOffset);
                    }
                    attribute.print();
                }
                printed = true;
            }
            if (!printed || i + 1 >= len) continue;
            this.println();
            printed = false;
        }
        List<AttrData> corruptedList = this.getCorruptedAttributes();
        if (!corruptedList.isEmpty()) {
            this.printIndentLn();
            this.printIndentLn(String.format("// == Ignored %d corrupted attribute(s): ==", corruptedList.size()));
            for (int i = 0; i < corruptedList.size(); ++i) {
                this.printIndentLn("// attribute_info {");
                this.printIndentLn(String.format("//    u2 attribute_name_index: #%d;", corruptedList.get(i).getNameCpx()));
                this.printIndentLn(String.format("//    u4 attribute_length:     %d;", corruptedList.get(i).getLength()));
                this.printIndentLn("//    u1 info[attribute_length];");
                this.printIndentLn("// }");
            }
            this.printIndentLn();
        }
        return corruptedList.size();
    }

    private List<AttrData> getCorruptedAttributes() {
        return this.attributes.stream().filter(AttrData::isCorrupted).toList();
    }

    private boolean printMemberDataList(List<? extends MemberData> list, int commentOffset) throws IOException {
        int count;
        if (list != null && (count = list.size()) > 0) {
            for (int i = 0; i < count; ++i) {
                MemberData md = list.get(i);
                md.setCommentOffset(commentOffset);
                if (i != 0 && md.getAnnotationsCount() > 0) {
                    this.println();
                }
                md.print();
            }
            return true;
        }
        return false;
    }
}

