/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.ClassFileConst;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.InstructionAttr;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.TrapData;
import org.openjdk.asmtools.jdis.TypeAnnotationData;

public class CodeData
extends MemberData<MethodData> {
    private final HashMap<Integer, InstructionAttr> instructionAttrs = new HashMap();
    protected byte[] code;
    protected int max_stack;
    protected int max_locals;
    protected ArrayList<AttrData> attrs = new ArrayList(0);
    private ArrayList<TrapData> trap_table = new ArrayList(0);
    private ArrayList<LineNumData> lin_num_tb = new ArrayList(0);
    private ArrayList<LocVarData> loc_var_tb = new ArrayList(0);
    private ArrayList<StackMapData> stack_map = null;
    private ArrayList<TypeAnnotationData<MethodData>> visibleTypeAnnotations;
    private ArrayList<TypeAnnotationData<MethodData>> invisibleTypeAnnotations;

    public CodeData(MethodData data) {
        super(data);
    }

    private static int align(int n) {
        return n + 3 & 0xFFFFFFFC;
    }

    private int getByte(int pc) {
        return this.code[pc];
    }

    private int getUByte(int pc) {
        return this.code[pc] & 0xFF;
    }

    private int getShort(int pc) {
        return this.code[pc] << 8 | this.code[pc + 1] & 0xFF;
    }

    private int getUShort(int pc) {
        return (this.code[pc] << 8 | this.code[pc + 1] & 0xFF) & 0xFFFF;
    }

    private int getInt(int pc) {
        return this.getShort(pc) << 16 | this.getShort(pc + 2) & 0xFFFF;
    }

    protected InstructionAttr getInstructionAttribute(int pc) {
        Integer PC = pc;
        InstructionAttr res = this.instructionAttrs.get(PC);
        if (res == null) {
            res = new InstructionAttr((MethodData)this.data);
            res.setTheSame(this).incIndent();
            this.instructionAttrs.put(PC, res);
        }
        return res;
    }

    private void readLineNumTable(DataInputStream in) throws IOException {
        int len = in.readInt();
        int nLines = in.readUnsignedShort();
        this.lin_num_tb = new ArrayList(nLines);
        this.environment.traceln("CodeAttr:  LineNumTable[%d] length=%d", nLines, len);
        for (int l = 0; l < nLines; ++l) {
            this.lin_num_tb.add(new LineNumData(in));
        }
    }

    private void readLocVarTable(DataInputStream in) throws IOException {
        int len = in.readInt();
        int nLines = in.readUnsignedShort();
        this.loc_var_tb = new ArrayList(nLines);
        this.environment.traceln("CodeAttr:  LocalVariableTable[%d] length=%d", nLines, len);
        for (int l = 0; l < nLines; ++l) {
            this.loc_var_tb.add(new LocVarData(in));
        }
    }

    private void readTrapTable(DataInputStream in) throws IOException {
        int trap_table_len = in.readUnsignedShort();
        this.environment.traceln("CodeAttr:  TrapTable[%d]", trap_table_len);
        this.trap_table = new ArrayList(trap_table_len);
        for (int l = 0; l < trap_table_len; ++l) {
            this.trap_table.add(new TrapData(in, l));
        }
    }

    private void readStackMapEntity(StackMapData.EAttributeType type, DataInputStream in) throws IOException {
        int len = in.readInt();
        int stack_map_len = in.readUnsignedShort();
        this.stack_map = new ArrayList(stack_map_len);
        this.environment.traceln("CodeAttr:  %s: attrLength=%d num=%d", type.getName(), len, stack_map_len);
        int prevFrame_pc = 0;
        for (int k = 0; k < stack_map_len; ++k) {
            StackMapData stackMapData = new StackMapData(type, k == 0, prevFrame_pc, this, in);
            prevFrame_pc = stackMapData.getFramePC();
            this.stack_map.add(stackMapData);
        }
    }

    private void readTypeAnnotations(DataInputStream in, boolean isInvisible) throws IOException {
        int attrLength = in.readInt();
        int count = in.readShort();
        ArrayList<TypeAnnotationData<MethodData>> tannots = new ArrayList<TypeAnnotationData<MethodData>>(count);
        this.environment.traceln("CodeAttr:   Runtime%sisibleTypeAnnotation: attrLength=%d num= %d", isInvisible ? "Inv" : "V", attrLength, count);
        for (int index = 0; index < count; ++index) {
            TypeAnnotationData<MethodData> tannot = new TypeAnnotationData<MethodData>((MethodData)this.data, isInvisible);
            tannot.read(in);
            tannots.add(tannot);
        }
        if (isInvisible) {
            this.invisibleTypeAnnotations = tannots;
        } else {
            this.visibleTypeAnnotations = tannots;
        }
    }

    public void read(DataInputStream in, int codeAttrLength) throws IOException {
        this.max_stack = in.readUnsignedShort();
        this.max_locals = in.readUnsignedShort();
        int codelen = in.readInt();
        this.environment.traceln("CodeAttr:  CodeLength=%d FullLength=%d max_stack=%d max_locals=%d", codelen, codeAttrLength, this.max_stack, this.max_locals);
        this.code = new byte[codelen];
        in.read(this.code, 0, codelen);
        this.readTrapTable(in);
        int nattr = in.readUnsignedShort();
        this.environment.traceln("CodeAttr: add.attr: %d", nattr);
        block7: for (int k = 0; k < nattr; ++k) {
            int name_cpx = in.readUnsignedShort();
            ConstantPool.Constant name_const = this.pool.getConst(name_cpx);
            if (name_const == null || name_const.tag != ConstantPool.TAG.CONSTANT_UTF8) continue;
            String attrName = this.pool.getString(name_cpx, index -> "#" + index);
            this.environment.traceln("CodeAttr:  attr: " + attrName, new Object[0]);
            EAttribute attrTag = EAttribute.get(attrName);
            switch (attrTag) {
                case ATT_LineNumberTable: {
                    this.readLineNumTable(in);
                    continue block7;
                }
                case ATT_LocalVariableTable: {
                    this.readLocVarTable(in);
                    continue block7;
                }
                case ATT_StackMap: {
                    this.readStackMapEntity(StackMapData.EAttributeType.STACKMAP, in);
                    continue block7;
                }
                case ATT_StackMapTable: {
                    this.readStackMapEntity(StackMapData.EAttributeType.STACKMAPTABLE, in);
                    continue block7;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    this.readTypeAnnotations(in, attrTag == EAttribute.ATT_RuntimeInvisibleTypeAnnotations);
                    continue block7;
                }
                default: {
                    AttrData attr = new AttrData(this.environment);
                    int attrLen = in.readInt();
                    attr.read(name_cpx, attrLen, in);
                    this.attrs.add(attr);
                }
            }
        }
    }

    private int checkForLabelRef(int pc) {
        int opc = this.getUByte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        switch (opcode) {
            case opc_tableswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int low = this.getInt(tb + 4);
                int high = this.getInt(tb + 8);
                int count = high - low;
                for (int i = 0; i <= count; ++i) {
                    this.getInstructionAttribute((int)(pc + this.getInt((int)(tb + 12 + 4 * i)))).referred = true;
                }
                this.getInstructionAttribute((int)(default_skip + pc)).referred = true;
                return tb - pc + 16 + count * 4;
            }
            case opc_lookupswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int npairs = this.getInt(tb + 4);
                for (int i = 1; i <= npairs; ++i) {
                    this.getInstructionAttribute((int)(pc + this.getInt((int)(tb + 4 + i * 8)))).referred = true;
                }
                this.getInstructionAttribute((int)(default_skip + pc)).referred = true;
                return tb - pc + (npairs + 1) * 8;
            }
            case opc_jsr: 
            case opc_goto: 
            case opc_ifeq: 
            case opc_ifge: 
            case opc_ifgt: 
            case opc_ifle: 
            case opc_iflt: 
            case opc_ifne: 
            case opc_if_icmpeq: 
            case opc_if_icmpne: 
            case opc_if_icmpge: 
            case opc_if_icmpgt: 
            case opc_if_icmple: 
            case opc_if_icmplt: 
            case opc_if_acmpeq: 
            case opc_if_acmpne: 
            case opc_ifnull: 
            case opc_ifnonnull: {
                this.getInstructionAttribute((int)(pc + this.getShort((int)(pc + 1)))).referred = true;
                return 3;
            }
            case opc_jsr_w: 
            case opc_goto_w: {
                this.getInstructionAttribute((int)(pc + this.getInt((int)(pc + 1)))).referred = true;
                return 5;
            }
            case opc_wide: 
            case opc_nonpriv: 
            case opc_priv: {
                int opc2 = (opcode.value() << 8) + this.getUByte(pc + 1);
                opcode = OpcodeTables.opcode(opc2);
            }
        }
        try {
            int opclen = opcode.length();
            return opclen == 0 ? 1 : opclen;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 1;
        }
    }

    private void loadLabelTable() {
        for (int pc = 0; pc < this.code.length; pc += this.checkForLabelRef(pc)) {
        }
    }

    private void loadLineNumTable() {
        for (LineNumData entry : this.lin_num_tb) {
            this.getInstructionAttribute((int)entry.start_pc).lineNum = entry.line_number;
        }
    }

    private void loadStackMap() {
        Iterator<StackMapData> iterator = this.stack_map.iterator();
        while (iterator.hasNext()) {
            StackMapData entry;
            this.getInstructionAttribute((int)entry.frame_pc).stackMapEntry = entry = iterator.next();
        }
    }

    private void loadLocVarTable() {
        for (LocVarData entry : this.loc_var_tb) {
            this.getInstructionAttribute(entry.start_pc).addVar(entry);
            this.getInstructionAttribute(entry.start_pc + entry.length).addEndVar(entry);
        }
    }

    private void loadTrapTable() {
        for (TrapData entry : this.trap_table) {
            this.getInstructionAttribute(entry.start_pc).addTrap(entry);
            this.getInstructionAttribute(entry.end_pc).addEndTrap(entry);
            this.getInstructionAttribute(entry.handler_pc).add_handler(entry);
        }
    }

    private int printInstrLn(int pc, int shift) {
        int opc = this.getUByte(pc);
        OpcodeTables.Opcode opcode = OpcodeTables.opcode(opc);
        switch (opcode) {
            case opc_nonpriv: 
            case opc_priv: {
                int opc2 = this.getUByte(pc + 1);
                int finalopc = (opc << 8) + opc2;
                OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopc);
                Object mnem = opcode2 == null ? opcode.parseKey() + " " + opc2 : opcode2.parseKey();
                this.println((String)mnem);
                return 2;
            }
            case opc_wide: {
                int opc2 = this.getUByte(pc + 1);
                int finalopcwide = (opc << 8) + opc2;
                OpcodeTables.Opcode opcode2 = OpcodeTables.opcode(finalopcwide);
                if (opcode2 == null) {
                    this.print(this.PadRight("bytecode", 18)).println(opcode + ";");
                    return 1;
                }
                String mnem = opcode2.parseKey();
                if (opcode2 == OpcodeTables.Opcode.opc_iinc_w) {
                    this.print(this.PadRight(mnem, 18));
                    this.println("%d, %d;", this.getUShort(pc + 2), this.getUShort(pc + 4));
                    return 6;
                }
                this.print(this.PadRight(mnem, 18)).println("%d;", this.getUShort(pc + 2));
                return 4;
            }
        }
        String mnem = opcode.parseKey();
        if (mnem == null) {
            this.print(this.PadRight("bytecode", 18)).println(opcode + ";");
            return 1;
        }
        if (!opcode.isReservedOpcode()) {
            this.print(this.PadRight("bytecode", 18)).println(opcode + ";");
            return 1;
        }
        String operand = opcode.parseKey();
        switch (opcode) {
            case opc_aload: 
            case opc_astore: 
            case opc_fload: 
            case opc_fstore: 
            case opc_iload: 
            case opc_istore: 
            case opc_lload: 
            case opc_lstore: 
            case opc_dload: 
            case opc_dstore: 
            case opc_ret: {
                this.print(this.PadRight(operand, 18)).println(this.getUByte(pc + 1) + ";");
                return 2;
            }
            case opc_iinc: {
                this.print(this.PadRight(operand, 18)).println("%d, %d;", this.getUByte(pc + 1), this.getByte(pc + 2));
                return 3;
            }
            case opc_tableswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int low = this.getInt(tb + 4);
                int high = this.getInt(tb + 8);
                int count = high - low;
                this.printPadRight(String.format("%s { ", this.PadRight(operand, 17)), this.getCommentOffset() - 1);
                this.println((String)(this.printCPIndex && !this.skipComments ? " // " + low + " to " + high : ""));
                for (int i = 0; i <= count; ++i) {
                    this.print(this.enlargedIndent(this.PadRight(String.format("%2d: ", i + low), 9), shift)).println(((MethodData)this.data).lP + (pc + this.getInt(tb + 12 + 4 * i)) + ";");
                }
                this.print(this.enlargedIndent(this.PadRight("default: " + ((MethodData)this.data).lP + (default_skip + pc), 17 - this.getIndentStep() - 2), shift)).println(" };");
                return tb - pc + 16 + count * 4;
            }
            case opc_lookupswitch: {
                int tb = CodeData.align(pc + 1);
                int default_skip = this.getInt(tb);
                int nPairs = this.getInt(tb + 4);
                this.printPadRight(String.format("%s { ", this.PadRight(operand, 17)), this.getCommentOffset() - 1);
                this.println((String)(this.printCPIndex && !this.skipComments ? " // " + nPairs : ""));
                Pair<Integer, Integer>[] lookupswitchPairs = this.getLookupswitchPairs(tb, nPairs);
                int caseLength = Math.max(9, Arrays.stream(lookupswitchPairs).mapToInt(p -> String.valueOf(p.first).length()).max().orElse(0) + 2);
                for (int i = 0; i < nPairs; ++i) {
                    this.print(this.enlargedIndent(this.PadRight(String.format("%2d:", lookupswitchPairs[i].first), caseLength), shift)).println(((MethodData)this.data).lP + (pc + (Integer)lookupswitchPairs[i].second) + ";");
                }
                this.print(this.enlargedIndent(this.PadRight(this.PadRight("default: ", caseLength) + ((MethodData)this.data).lP + (default_skip + pc), 17 - this.getIndentStep() - 2), shift)).println(" };");
                return tb - pc + (nPairs + 1) * 8;
            }
            case opc_newarray: {
                int tp = this.getUByte(pc + 1);
                ClassFileConst.BasicType basicType = ClassFileConst.getBasicType(tp);
                if (basicType == null) {
                    this.print(this.PadRight(operand, 18)).println("BOGUS TYPE: " + HexUtils.toHex(tp, 8) + ";");
                } else {
                    this.print(this.PadRight(operand, 18)).println(basicType.printValue() + ";");
                }
                return 2;
            }
            case opc_ldc: 
            case opc_ldc_w: 
            case opc_ldc2_w: 
            case opc_invokedynamic: {
                int index;
                int opLength;
                ArrayList<Integer> breakPositions = new ArrayList<Integer>();
                if (opcode == OpcodeTables.Opcode.opc_ldc) {
                    opLength = 2;
                    breakPositions.add(3);
                    index = this.getUByte(pc + 1);
                } else if (opcode == OpcodeTables.Opcode.opc_invokedynamic) {
                    opLength = 5;
                    breakPositions.addAll(Set.of(Integer.valueOf(2), Integer.valueOf(3)));
                    index = this.getUShort(pc + 1);
                } else {
                    opLength = 3;
                    breakPositions.add(3);
                    index = this.getUShort(pc + 1);
                }
                this.pool.setPrintTAG(true);
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println(String.format("%s #%d;", this.PadRight(operand, 17), index));
                    } else {
                        this.printPadRight(String.format("%s #%d;", this.PadRight(operand, 17), index), this.getCommentOffset() - 1).print(" // ");
                        this.println(this.formatOperandLine(this.pool.ConstantStrValue(index), this.getCommentOffset() + shift - 1, " // ", breakPositions));
                    }
                } else {
                    this.print(this.PadRight(operand, 18));
                    this.println(this.formatOperandLine(this.pool.ConstantStrValue(index), 17 + shift + 1, "", breakPositions) + ";");
                }
                this.pool.setPrintTAG(false);
                return opLength;
            }
            case opc_anewarray: 
            case opc_instanceof: 
            case opc_checkcast: 
            case opc_new: 
            case opc_putstatic: 
            case opc_getstatic: 
            case opc_putfield: 
            case opc_getfield: 
            case opc_invokevirtual: 
            case opc_invokespecial: 
            case opc_invokestatic: 
            case opc_withfield: 
            case opc_aconst_init: {
                int index = this.getUShort(pc + 1);
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println(String.format("%s #%d;", this.PadRight(operand, 17), index));
                    } else {
                        this.printPadRight(String.format("%s #%d;", this.PadRight(operand, 17), index), this.getCommentOffset() - 1).println(" // " + this.pool.ConstantStrValue(index));
                    }
                } else {
                    this.print(this.PadRight(operand, 18));
                    this.println(this.pool.ConstantStrValue(index) + ";");
                }
                return 3;
            }
            case opc_multianewarray: 
            case opc_invokeinterface: {
                int index = this.getUShort(pc + 1);
                int dimensions = this.getUByte(pc + 3);
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println(String.format("%s #%d, %d;", this.PadRight(operand, 17), index, dimensions));
                    } else {
                        this.printPadRight(String.format("%s #%d, %d;", this.PadRight(operand, 17), index, dimensions), this.getCommentOffset() - 1).println(" // " + this.pool.ConstantStrValue(index));
                    }
                } else {
                    this.print(this.PadRight(operand, 18));
                    this.println("%s, %d;", this.pool.ConstantStrValue(index), dimensions);
                }
                return opcode == OpcodeTables.Opcode.opc_multianewarray ? 4 : 5;
            }
            case opc_sipush: {
                this.print(this.PadRight(operand, 18)).println(this.getShort(pc + 1) + ";");
                return 3;
            }
            case opc_bipush: {
                this.print(this.PadRight(operand, 18)).println(this.getByte(pc + 1) + ";");
                return 2;
            }
            case opc_jsr: 
            case opc_goto: 
            case opc_ifeq: 
            case opc_ifge: 
            case opc_ifgt: 
            case opc_ifle: 
            case opc_iflt: 
            case opc_ifne: 
            case opc_if_icmpeq: 
            case opc_if_icmpne: 
            case opc_if_icmpge: 
            case opc_if_icmpgt: 
            case opc_if_icmple: 
            case opc_if_icmplt: 
            case opc_if_acmpeq: 
            case opc_if_acmpne: 
            case opc_ifnull: 
            case opc_ifnonnull: {
                this.print(this.PadRight(operand, 18)).println(((MethodData)this.data).lP + (pc + this.getShort(pc + 1)) + ";");
                return 3;
            }
            case opc_jsr_w: 
            case opc_goto_w: {
                this.print(this.PadRight(operand, 18)).println(((MethodData)this.data).lP + (pc + this.getInt(pc + 1)) + ";");
                return 5;
            }
        }
        this.println(operand + ";");
        return 1;
    }

    private Pair<Integer, Integer>[] getLookupswitchPairs(int pad, int count) {
        Pair[] pairs = new Pair[count];
        for (int i = 1; i <= count; ++i) {
            pairs[i - 1] = new Pair<Integer, Integer>(this.getInt(pad + i * 8), this.getInt(pad + 4 + i * 8));
        }
        return pairs;
    }

    private String formatOperandLine(String str, int offset, String prefix, List<Integer> breakPositions) {
        StringTokenizer st = new StringTokenizer(str, ":\"{}\\^\u2f80", true);
        StringBuilder sb = new StringBuilder(80);
        boolean processTokens = true;
        String prevToken = "";
        int nItems = 0;
        int nLevel = 0;
        while (st.hasMoreTokens()) {
            String token;
            switch (token = st.nextToken()) {
                case ":": {
                    sb.append(token);
                    if (!processTokens || !breakPositions.contains(++nItems) || nLevel != 0) break;
                    sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix);
                    break;
                }
                case "}": {
                    if (processTokens) {
                        sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * --nLevel)).append(token);
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case "{": {
                    if (processTokens) {
                        sb.append(" {").append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * ++nLevel));
                        break;
                    }
                    sb.append(token);
                    break;
                }
                case "\"": {
                    if (!prevToken.equals("\\")) {
                        processTokens = !processTokens;
                    }
                    sb.append(token);
                    break;
                }
                case "^": {
                    if (processTokens) {
                        sb.append(',').append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel));
                        break;
                    }
                    sb.append("^");
                    break;
                }
                case "\u2f80": {
                    if (processTokens) {
                        sb.append(System.lineSeparator()).append(this.nCopies(offset)).append(prefix).append(this.nCopies(this.getIndentStep() * nLevel));
                        break;
                    }
                    sb.append("^");
                    break;
                }
                default: {
                    sb.append(token);
                }
            }
            prevToken = token;
        }
        return sb.toString();
    }

    @Override
    public void print() throws IOException {
        int attributeOffset;
        int instructionOffset;
        if (!this.lin_num_tb.isEmpty()) {
            this.loadLineNumTable();
        }
        if (this.stack_map != null) {
            this.loadStackMap();
        }
        if (!((MethodData)this.data).printProgramCounter) {
            this.loadLabelTable();
        }
        this.loadTrapTable();
        if (!this.loc_var_tb.isEmpty()) {
            this.loadLocVarTable();
        }
        this.println().incIndent().printIndentPadRight(JasmTokens.Token.STACK.parseKey(), 7);
        this.println("%d locals  %d", this.max_stack, this.max_locals).decIndent();
        ((MethodData)this.data).incIndent();
        ((MethodData)this.data).printPAnnotations();
        ((MethodData)this.data).decIndent();
        this.printIndentLn("{");
        InstructionAttr insAttr = this.instructionAttrs.get(0);
        if (((MethodData)this.data).printProgramCounter) {
            attributeOffset = instructionOffset = 7;
        } else {
            instructionOffset = 7;
            attributeOffset = instructionOffset - this.getIndentStep();
        }
        this.setCommentOffset(this.getCommentOffset() - instructionOffset - this.getIndentSize());
        int pc = 0;
        while (pc < this.code.length) {
            if (insAttr != null) {
                this.incIndent();
                insAttr.setCommentOffset(this.getCommentOffset());
                insAttr.printBegins(attributeOffset);
                this.decIndent();
            }
            if (((MethodData)this.data).printProgramCounter) {
                this.incIndent();
                this.printIndent(this.PadRight(String.format("%2d:", pc), instructionOffset));
            } else {
                this.printIndent(this.PadRight((String)(insAttr != null && insAttr.referred ? ((MethodData)this.data).lP + pc + ":" : " "), instructionOffset));
                this.incIndent();
            }
            if (insAttr != null && insAttr.printStackMap(attributeOffset)) {
                this.print(this.enlargedIndent(attributeOffset));
            }
            if ((insAttr = this.instructionAttrs.get(pc += this.printInstrLn(pc, attributeOffset + this.getIndentSize()))) != null) {
                insAttr.printEnds(attributeOffset);
                this.decIndent();
            }
            this.decIndent();
        }
        if (insAttr != null && insAttr.stackMapEntry != null) {
            if (((MethodData)this.data).printProgramCounter) {
                this.incIndent();
                this.printIndent(this.PadRight(String.format("%2d:", this.code.length), instructionOffset));
            } else {
                this.printIndent(this.PadRight((String)(insAttr.referred ? ((MethodData)this.data).lP + this.code.length + ":" : "?"), instructionOffset));
                this.incIndent();
            }
            this.decIndent();
        }
        if (this.visibleTypeAnnotations != null) {
            this.println();
            for (TypeAnnotationData<MethodData> vta : this.visibleTypeAnnotations) {
                vta.print();
                this.println();
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            this.println(() -> this.visibleTypeAnnotations == null);
            for (TypeAnnotationData<MethodData> ita : this.invisibleTypeAnnotations) {
                ita.print();
                this.println();
            }
        }
        this.printIndentLn("}");
    }

    public JdisEnvironment getEnvironment() {
        return this.environment;
    }

    static class LineNumData {
        short start_pc;
        short line_number;

        public LineNumData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.line_number = in.readShort();
        }
    }

    public static class LocVarData {
        short start_pc;
        short length;
        short name_cpx;
        short sig_cpx;
        short slot;

        public LocVarData(DataInputStream in) throws IOException {
            this.start_pc = in.readShort();
            this.length = in.readShort();
            this.name_cpx = in.readShort();
            this.sig_cpx = in.readShort();
            this.slot = in.readShort();
        }
    }
}

