/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Objects;
import java.util.Stack;
import java.util.function.Function;
import org.openjdk.asmtools.asmutils.HexUtils;
import org.openjdk.asmtools.asmutils.Range;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.jdis.BootstrapMethodData;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.Utils;

public class ConstantPool
extends Indenter {
    private static final Hashtable<Byte, TAG> tagHash = new Hashtable();
    private static final Hashtable<Byte, SUBTAG> subTagHash = new Hashtable();
    private final ClassData classData;
    private JdisEnvironment environment;
    private ArrayList<Constant> pool;
    private Range<Integer> range;
    private boolean printTAG = false;

    public ConstantPool(ClassData cd) {
        this(cd, 10);
    }

    public ConstantPool(ClassData classData, int size) {
        super(classData.toolOutput);
        this.classData = classData;
        this.environment = classData.environment;
        this.pool = new ArrayList(size);
    }

    public void setPrintTAG(boolean value) {
        this.printTAG = value;
    }

    public String getPrintedTAG(TAG tag) {
        return this.printTAG ? tag.tagName + " " : "";
    }

    public int size() {
        return this.pool.size();
    }

    public boolean inRange(int value) {
        if (this.range == null) {
            this.range = new Range<Integer>(1, this.pool.size() - 1);
        }
        return this.range.in(value);
    }

    void read(DataInputStream in) throws IOException {
        int tagSize;
        int constant_pool_count = in.readUnsignedShort();
        this.pool = new ArrayList(constant_pool_count);
        this.pool.add(0, null);
        this.environment.traceln("constant_pool_count = " + constant_pool_count, new Object[0]);
        block10: for (int i = 1; i < constant_pool_count; i += tagSize) {
            byte tagByte = in.readByte();
            TAG tag = tagHash.get(tagByte);
            if (tag == null) {
                throw new ClassFormatError(String.format("Error while reading constant pool for %s: unexpected tag at #%d: %d", this.environment.getInputFile(), i, tagByte));
            }
            tagSize = tag.size();
            this.environment.traceln("\tCP entry #" + i + " tag[" + tagByte + "]\t=\t" + tag, new Object[0]);
            switch (tag) {
                case CONSTANT_UTF8: {
                    this.pool.add(i, new CP_Str(tag, in.readUTF()));
                    continue block10;
                }
                case CONSTANT_INTEGER: {
                    this.pool.add(i, new CP_Int(tag, in.readInt()));
                    continue block10;
                }
                case CONSTANT_LONG: {
                    this.pool.add(i, new CP_Long(tag, in.readLong()));
                    this.pool.add(null);
                    continue block10;
                }
                case CONSTANT_FLOAT: {
                    this.pool.add(i, new CP_Float(tag, in.readFloat()));
                    continue block10;
                }
                case CONSTANT_DOUBLE: {
                    this.pool.add(i, new CP_Double(tag, in.readDouble()));
                    this.pool.add(null);
                    continue block10;
                }
                case CONSTANT_CLASS: 
                case CONSTANT_STRING: 
                case CONSTANT_METHODTYPE: 
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: {
                    this.pool.add(i, new CPX(tag, in.readUnsignedShort()));
                    continue block10;
                }
                case CONSTANT_FIELD: 
                case CONSTANT_METHOD: 
                case CONSTANT_INTERFACEMETHOD: 
                case CONSTANT_NAMEANDTYPE: 
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    this.pool.add(i, new CPX2(tag, in.readUnsignedShort(), in.readUnsignedShort()));
                    continue block10;
                }
                case CONSTANT_METHODHANDLE: {
                    this.pool.add(i, new CPX2(tag, in.readUnsignedByte(), in.readUnsignedShort()));
                    continue block10;
                }
                default: {
                    throw new ClassFormatError("invalid constant type: " + tagByte);
                }
            }
        }
    }

    private boolean inbounds(int cpx) {
        return cpx != 0 && cpx < this.pool.size();
    }

    public Constant getConst(int cpx) {
        if (this.inbounds(cpx)) {
            return this.pool.get(cpx);
        }
        return null;
    }

    public String getString(int cpx, Function<Integer, String> funcGetDefaultString) {
        Constant cns;
        String str = funcGetDefaultString.apply(cpx);
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_UTF8) {
            CP_Str cns1 = (CP_Str)cns;
            str = (String)cns1.value;
        }
        return str;
    }

    public String getModuleName(int cpx, Function<Integer, String> funcGetDefaultModuleName) {
        Constant cns;
        String str = funcGetDefaultModuleName.apply(cpx);
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_MODULE) {
            str = cns.stringVal();
        }
        return str;
    }

    public String getModuleName(int cpx) {
        return this.getModuleName(cpx, index -> "#" + index);
    }

    public String getPackageName(int cpx, Function<Integer, String> funcGetDefaultPackageName) {
        Constant cns;
        String str = funcGetDefaultPackageName.apply(cpx);
        if (this.inbounds(cpx) && (cns = this.pool.get(cpx)) != null && cns.tag == TAG.CONSTANT_PACKAGE) {
            str = cns.stringVal();
        }
        return str;
    }

    public String getPackageName(int cpx) {
        return this.getPackageName(cpx, index -> "#" + index);
    }

    public String getName(int cpx) {
        String str = this.getString(cpx, index -> null);
        if (str == null) {
            return "<invalid constant pool index:" + cpx + ">";
        }
        return Utils.javaName(str);
    }

    public String getClassName(int cpx) {
        return this.getClassName(cpx, index -> "#" + index);
    }

    public String getClassName(int cpx, Function<Integer, String> funcGetDefaultClassName) {
        String res = funcGetDefaultClassName.apply(cpx);
        if (cpx == 0 || !this.inbounds(cpx)) {
            return res;
        }
        Constant cns = this.pool.get(cpx);
        if (cns == null || cns.tag != TAG.CONSTANT_CLASS) {
            return res;
        }
        return this.getClassName((CPX)cns);
    }

    public String getClassName(CPX2 classConst) {
        return this._getClassName((Integer)classConst.value);
    }

    public String getClassName(CPX classConst) {
        return this._getClassName((Integer)classConst.value);
    }

    private String _getClassName(int nameIndex) {
        String res = "#" + nameIndex;
        if (!this.inbounds(nameIndex)) {
            return res;
        }
        Constant nameconst = this.pool.get(nameIndex);
        if (nameconst == null || nameconst.tag != TAG.CONSTANT_UTF8) {
            return res;
        }
        CP_Str name = (CP_Str)nameconst;
        Object classname = (String)name.value;
        if (Utils.isClassArrayDescriptor((String)classname)) {
            classname = "\"" + (String)classname + "\"";
        }
        return classname;
    }

    public String getShortClassName(String className, String packageName) {
        int idx = className.lastIndexOf(47);
        if (idx == packageName.length() && className.startsWith(packageName)) {
            return className.substring(idx + 1);
        }
        return className;
    }

    public String getShortClassName(int cpx, String packageName) {
        String name = Utils.javaName(this.getClassName(cpx));
        return this.getShortClassName(name, packageName);
    }

    public String decodeClassDescriptor(int cpx) {
        String rawEnumName = this.getName(cpx);
        int len = rawEnumName.length();
        int begin = rawEnumName.startsWith("\"L") ? 2 : 0;
        int end = begin > 0 ? len - 2 : len;
        return rawEnumName.substring(begin, end);
    }

    private String subtagToString(int subtag) {
        SUBTAG st = subTagHash.get((byte)subtag);
        if (st == null) {
            return "BOGUS_SUBTAG:" + subtag;
        }
        return st.tagName;
    }

    public String StringValue(int cpx) {
        if (cpx == 0) {
            return "#0";
        }
        if (!this.inbounds(cpx)) {
            return "<Incorrect CP index:" + cpx + ">";
        }
        Constant cnst = this.pool.get(cpx);
        if (cnst == null) {
            return "<NULL>";
        }
        return cnst.stringVal();
    }

    public String ConstantStrValue(int cpx) {
        if (cpx == 0 || !this.inbounds(cpx)) {
            return "#" + cpx;
        }
        Constant cns = this.pool.get(cpx);
        if (cns == null) {
            return "#" + cpx;
        }
        if (cns instanceof CPX2) {
            CPX2 cns2 = (CPX2)cns;
            if ((Integer)cns2.value == this.classData.this_cpx && cns2.refersClassMember()) {
                cpx = cns2.value2;
            }
        }
        return cns.tag.tagName + " " + this.StringValue(cpx);
    }

    @Override
    public void print() throws IOException {
        int size;
        int nSpaces = this.pool.size() > 100 ? 4 : 3;
        int tagPadding = this.getTagPadding();
        for (int idx = 1; idx < this.pool.size(); idx += size) {
            Constant cns = this.pool.get(idx);
            this.printIndent("const %s = ", this.PadRight("#" + idx, nSpaces));
            if (cns == null) {
                size = 0;
                this.println("null;");
                continue;
            }
            size = cns.size();
            cns.setCommentPadding(this.getCommentPadding());
            cns.print(this.toolOutput, tagPadding);
        }
        this.printIndentLn();
    }

    private int getTagPadding() {
        return this.pool.stream().mapToInt(elem -> elem == null ? 4 : elem.tag.tagName().length()).max().orElse(10) + 1;
    }

    private int getCommentPadding() {
        return Math.max(16, this.getTagPadding());
    }

    @Override
    public int getCommentOffset() {
        return this.getIndentSize() + Math.max(String.valueOf(this.pool.size()).length(), 2) + 10 + this.getTagPadding() + this.getCommentPadding();
    }

    public List<IOException> getIssues() {
        return this.pool.stream().filter(Objects::nonNull).flatMap(constant -> constant.getIssues().stream().filter(Objects::nonNull)).toList();
    }

    static {
        tagHash.put(TAG.CONSTANT_UTF8.value(), TAG.CONSTANT_UTF8);
        tagHash.put(TAG.CONSTANT_INTEGER.value(), TAG.CONSTANT_INTEGER);
        tagHash.put(TAG.CONSTANT_FLOAT.value(), TAG.CONSTANT_FLOAT);
        tagHash.put(TAG.CONSTANT_LONG.value(), TAG.CONSTANT_LONG);
        tagHash.put(TAG.CONSTANT_DOUBLE.value(), TAG.CONSTANT_DOUBLE);
        tagHash.put(TAG.CONSTANT_CLASS.value(), TAG.CONSTANT_CLASS);
        tagHash.put(TAG.CONSTANT_STRING.value(), TAG.CONSTANT_STRING);
        tagHash.put(TAG.CONSTANT_FIELD.value(), TAG.CONSTANT_FIELD);
        tagHash.put(TAG.CONSTANT_METHOD.value(), TAG.CONSTANT_METHOD);
        tagHash.put(TAG.CONSTANT_INTERFACEMETHOD.value(), TAG.CONSTANT_INTERFACEMETHOD);
        tagHash.put(TAG.CONSTANT_NAMEANDTYPE.value(), TAG.CONSTANT_NAMEANDTYPE);
        tagHash.put(TAG.CONSTANT_METHODHANDLE.value(), TAG.CONSTANT_METHODHANDLE);
        tagHash.put(TAG.CONSTANT_METHODTYPE.value(), TAG.CONSTANT_METHODTYPE);
        tagHash.put(TAG.CONSTANT_DYNAMIC.value(), TAG.CONSTANT_DYNAMIC);
        tagHash.put(TAG.CONSTANT_INVOKEDYNAMIC.value(), TAG.CONSTANT_INVOKEDYNAMIC);
        tagHash.put(TAG.CONSTANT_MODULE.value(), TAG.CONSTANT_MODULE);
        tagHash.put(TAG.CONSTANT_PACKAGE.value(), TAG.CONSTANT_PACKAGE);
        subTagHash.put(SUBTAG.REF_GETFIELD.value(), SUBTAG.REF_GETFIELD);
        subTagHash.put(SUBTAG.REF_GETSTATIC.value(), SUBTAG.REF_GETSTATIC);
        subTagHash.put(SUBTAG.REF_PUTFIELD.value(), SUBTAG.REF_PUTFIELD);
        subTagHash.put(SUBTAG.REF_PUTSTATIC.value(), SUBTAG.REF_PUTSTATIC);
        subTagHash.put(SUBTAG.REF_INVOKEVIRTUAL.value(), SUBTAG.REF_INVOKEVIRTUAL);
        subTagHash.put(SUBTAG.REF_INVOKESTATIC.value(), SUBTAG.REF_INVOKESTATIC);
        subTagHash.put(SUBTAG.REF_INVOKESPECIAL.value(), SUBTAG.REF_INVOKESPECIAL);
        subTagHash.put(SUBTAG.REF_NEWINVOKESPECIAL.value(), SUBTAG.REF_NEWINVOKESPECIAL);
        subTagHash.put(SUBTAG.REF_INVOKEINTERFACE.value(), SUBTAG.REF_INVOKEINTERFACE);
    }

    public static enum TAG {
        CONSTANT_NULL(0, "null", "CONSTANT_NULL", 1),
        CONSTANT_UTF8(1, "Utf8", "CONSTANT_UTF8", 1),
        CONSTANT_INTEGER(3, "int", "CONSTANT_INTEGER", 1),
        CONSTANT_FLOAT(4, "float", "CONSTANT_FLOAT", 1),
        CONSTANT_LONG(5, "long", "CONSTANT_LONG", 2),
        CONSTANT_DOUBLE(6, "double", "CONSTANT_DOUBLE", 2),
        CONSTANT_CLASS(7, "class", "CONSTANT_CLASS", 1),
        CONSTANT_STRING(8, "String", "CONSTANT_STRING", 1),
        CONSTANT_FIELD(9, "Field", "CONSTANT_FIELD", 1),
        CONSTANT_METHOD(10, "Method", "CONSTANT_METHOD", 1),
        CONSTANT_INTERFACEMETHOD(11, "InterfaceMethod", "CONSTANT_INTERFACEMETHOD", 1),
        CONSTANT_NAMEANDTYPE(12, "NameAndType", "CONSTANT_NAMEANDTYPE", 1),
        CONSTANT_METHODHANDLE(15, "MethodHandle", "CONSTANT_METHODHANDLE", 1),
        CONSTANT_METHODTYPE(16, "MethodType", "CONSTANT_METHODTYPE", 1),
        CONSTANT_DYNAMIC(17, "Dynamic", "CONSTANT_DYNAMIC", 1),
        CONSTANT_INVOKEDYNAMIC(18, "InvokeDynamic", "CONSTANT_INVOKEDYNAMIC", 1),
        CONSTANT_MODULE(19, "Module", "CONSTANT_MODULE", 1),
        CONSTANT_PACKAGE(20, "Package", "CONSTANT_PACKAGE", 1);

        private final Byte value;
        private final String tagName;
        private final String printValue;
        private final int size;

        private TAG(byte value, String tagName, String printValue, int size) {
            this.value = value;
            this.tagName = tagName;
            this.printValue = printValue;
            this.size = size;
        }

        public byte value() {
            return this.value;
        }

        public String tagName() {
            return this.tagName;
        }

        public int size() {
            return this.size;
        }

        public String toString() {
            return "<" + this.tagName + "> ";
        }
    }

    class CP_Str
    extends Constant<String> {
        CP_Str(TAG tag, String value) {
            super(tag, value);
        }

        @Override
        public String stringVal() {
            return StringUtils.Utf8ToString((String)this.value, "\"");
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            out.printlns(this.stringVal() + ";");
        }
    }

    class CP_Int
    extends Constant<Integer> {
        CP_Int(TAG tag, int value) {
            super(tag, value);
        }

        @Override
        public String stringVal() {
            return ConstantPool.this.classData.printHEX ? HexUtils.toHex((Integer)this.value) : ((Integer)this.value).toString();
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            out.printlns(this.stringVal() + ";");
        }
    }

    class CP_Long
    extends Constant<Long> {
        CP_Long(TAG tag, long value) {
            super(tag, value);
        }

        @Override
        public String stringVal() {
            return ConstantPool.this.classData.printHEX ? HexUtils.toHex((Long)this.value) + "l" : ((Long)this.value).toString() + "l";
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            out.printlns(this.stringVal() + ";");
        }

        @Override
        public int size() {
            return 2;
        }
    }

    class CP_Float
    extends Constant<Float> {
        CP_Float(TAG tag, float value) {
            super(tag, Float.valueOf(value));
        }

        @Override
        public String stringVal() {
            if (ConstantPool.this.classData.printHEX) {
                return "bits " + HexUtils.toHex(Float.floatToIntBits(((Float)this.value).floatValue()));
            }
            String sf = ((Float)this.value).toString();
            if (((Float)this.value).isNaN() || ((Float)this.value).isInfinite()) {
                return sf;
            }
            return sf + "f";
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            out.printlns(this.stringVal() + ";");
        }
    }

    class CP_Double
    extends Constant<Double> {
        CP_Double(TAG tag, double value) {
            super(tag, value);
        }

        @Override
        public String stringVal() {
            if (ConstantPool.this.classData.printHEX) {
                return "bits " + HexUtils.toHex(Double.doubleToLongBits((Double)this.value)) + "l";
            }
            String sd = ((Double)this.value).toString();
            if (((Double)this.value).isNaN() || ((Double)this.value).isInfinite()) {
                return sd;
            }
            return sd + "d";
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            out.printlns(this.stringVal() + ";");
        }

        @Override
        public int size() {
            return 2;
        }
    }

    class CPX
    extends Constant<Integer> {
        CPX(TAG tag, int cpx) {
            super(tag, cpx);
        }

        @Override
        public String stringVal() {
            String str = "UnknownTag";
            switch (this.tag) {
                case CONSTANT_CLASS: {
                    str = ConstantPool.this.getShortClassName(ConstantPool.this.getClassName(this), ConstantPool.this.classData.packageName);
                    break;
                }
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: {
                    str = ConstantPool.this.getString((Integer)this.value, index -> "#" + index);
                    break;
                }
                case CONSTANT_STRING: 
                case CONSTANT_METHODTYPE: {
                    str = ConstantPool.this.StringValue((Integer)this.value);
                    break;
                }
            }
            return str;
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            switch (this.tag) {
                case CONSTANT_CLASS: 
                case CONSTANT_STRING: 
                case CONSTANT_METHODTYPE: 
                case CONSTANT_PACKAGE: 
                case CONSTANT_MODULE: {
                    if (ConstantPool.this.skipComments) {
                        ConstantPool.this.println("#" + this.value + ";");
                        break;
                    }
                    ConstantPool.this.printPadRight("#" + this.value + ";", this.commentPadding).println("// " + this.stringVal());
                    break;
                }
            }
        }
    }

    class CPX2
    extends Constant<Integer> {
        protected final int value2;
        final Stack<Constant> stack;

        CPX2(TAG tag, int cpx1, int cpx2) {
            super(tag, cpx1);
            this.stack = new Stack();
            this.value2 = cpx2;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CPX2)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            CPX2 cpx2 = (CPX2)o;
            return this.value2 == cpx2.value2;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.value2;
            return result;
        }

        @Override
        public String stringVal() {
            Object str = "UnknownTag";
            switch (this.tag) {
                case CONSTANT_FIELD: {
                    str = ConstantPool.this.getShortClassName(ConstantPool.this.getClassName((Integer)this.value), ConstantPool.this.classData.packageName) + "." + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_METHOD: 
                case CONSTANT_INTERFACEMETHOD: {
                    str = ConstantPool.this.getPrintedTAG(this.tag) + ConstantPool.this.getShortClassName(ConstantPool.this.getClassName((Integer)this.value), ConstantPool.this.classData.packageName) + "." + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_NAMEANDTYPE: {
                    str = ConstantPool.this.getName((Integer)this.value) + ":" + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_METHODHANDLE: {
                    str = ConstantPool.this.subtagToString((Integer)this.value) + ":" + ConstantPool.this.StringValue(this.value2);
                    break;
                }
                case CONSTANT_DYNAMIC: 
                case CONSTANT_INVOKEDYNAMIC: {
                    BootstrapMethodData bsmData;
                    int bsmAttributeIndex = (Integer)this.value;
                    int nameTypeIndex = this.value2;
                    try {
                        bsmData = (BootstrapMethodData)ConstantPool.this.classData.bootstrapMethods.get(bsmAttributeIndex);
                    }
                    catch (NullPointerException npe) {
                        return "<Missing BootstrapMethods attribute>";
                    }
                    catch (IndexOutOfBoundsException ioobe) {
                        return "<Invalid bootstrap method index:" + bsmAttributeIndex + ">";
                    }
                    int bsm_ref = bsmData.bsmRef;
                    str = ConstantPool.this.StringValue(bsm_ref) + ":" + ConstantPool.this.StringValue(nameTypeIndex) + this.bsmArgsAsString(bsmData);
                }
            }
            return str;
        }

        private String bsmArgsAsString(BootstrapMethodData bsmData) {
            StringBuilder sb = new StringBuilder();
            int bsmArgsLen = bsmData.bsmArguments.size();
            if (bsmArgsLen > 0) {
                sb.append("{");
                for (int i = 0; i < bsmArgsLen; ++i) {
                    int bsm_arg_idx = bsmData.bsmArguments.get(i);
                    Constant cnt = ConstantPool.this.pool.get(bsm_arg_idx);
                    if (this.stack.search(this) == -1) {
                        this.stack.push(this);
                        sb.append(ConstantPool.this.ConstantStrValue(bsm_arg_idx)).append(i + 1 < bsmArgsLen ? "^" : "");
                        this.stack.pop();
                        continue;
                    }
                    String ref = cnt instanceof CPX2 ? String.format("%-8s %d:#%d; ", cnt.tag.tagName(), cnt.value, ((CPX2)cnt).value2) : String.format("%-8s #%d; ", cnt.tag.tagName(), cnt.value);
                    String msg = "circular reference to " + cnt.tag.tagName() + " #" + bsm_arg_idx;
                    if (ConstantPool.this.printCPIndex) {
                        sb.append(ref).append("<").append(msg).append(">").append(i + 1 < bsmArgsLen ? "^" : "");
                    } else {
                        sb.append(ref).append(" // <").append(msg).append(">").append(i + 1 < bsmArgsLen ? "\u2f80" : "");
                    }
                    cnt.setIssue(new IOException(msg));
                }
                sb.append("}");
            }
            return sb.toString();
        }

        @Override
        public void print(ToolOutput out, int spacePadding) {
            super.print(out, spacePadding);
            if (ConstantPool.this.skipComments) {
                switch (this.tag) {
                    case CONSTANT_FIELD: 
                    case CONSTANT_METHOD: 
                    case CONSTANT_INTERFACEMETHOD: {
                        ConstantPool.this.println("#%d.#%d;", this.value, this.value2);
                        break;
                    }
                    case CONSTANT_NAMEANDTYPE: 
                    case CONSTANT_DYNAMIC: 
                    case CONSTANT_INVOKEDYNAMIC: 
                    case CONSTANT_METHODHANDLE: {
                        ConstantPool.this.println("#%d:#%d;", this.value, this.value2);
                        break;
                    }
                    default: {
                        ConstantPool.this.printPadRight(String.format("%d:#%d;", this.value, this.value2), this.commentPadding).println("// unknown tag: " + this.tag.tagName);
                        break;
                    }
                }
            } else {
                switch (this.tag) {
                    case CONSTANT_FIELD: 
                    case CONSTANT_METHOD: 
                    case CONSTANT_INTERFACEMETHOD: {
                        ConstantPool.this.printPadRight(String.format("#%d.#%d;", this.value, this.value2), this.commentPadding).println("// " + this.stringVal());
                        break;
                    }
                    case CONSTANT_METHODHANDLE: {
                        ConstantPool.this.printPadRight(String.format("%d:#%d;", this.value, this.value2), this.commentPadding).println("// " + this.stringVal());
                        break;
                    }
                    case CONSTANT_NAMEANDTYPE: {
                        ConstantPool.this.printPadRight(String.format("#%d:#%d;", this.value, this.value2), this.commentPadding).println("// " + this.stringVal());
                        break;
                    }
                    case CONSTANT_DYNAMIC: 
                    case CONSTANT_INVOKEDYNAMIC: {
                        ConstantPool.this.printPadRight(String.format("%d:#%d;", this.value, this.value2), this.commentPadding).println("// #%d:%s", this.value, ConstantPool.this.StringValue(this.value2));
                        break;
                    }
                    default: {
                        ConstantPool.this.printPadRight(String.format("%d:#%d;", this.value, this.value2), this.commentPadding).println("// unknown tag: " + this.tag.tagName);
                    }
                }
            }
        }

        public boolean refersClassMember() {
            return this.tag == TAG.CONSTANT_FIELD || this.tag == TAG.CONSTANT_METHOD || this.tag == TAG.CONSTANT_INTERFACEMETHOD;
        }
    }

    public abstract class Constant<T> {
        protected final TAG tag;
        protected final T value;
        private final List<IOException> issues = new ArrayList<IOException>();
        protected int commentPadding = 16;

        public Constant(TAG tag, T value) {
            this.tag = tag;
            this.value = value;
        }

        public void print(ToolOutput out, int spacePadding) {
            out.prints(ConstantPool.this.PadRight(this.tag.tagName(), spacePadding));
        }

        public int size() {
            return 1;
        }

        public List<IOException> getIssues() {
            return this.issues;
        }

        public void setIssue(IOException value) {
            this.issues.add(value);
        }

        public void setCommentPadding(int commentPadding) {
            this.commentPadding = commentPadding;
        }

        public String stringVal() {
            return "";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Constant)) {
                return false;
            }
            Constant constant = (Constant)o;
            if (this.tag != constant.tag) {
                return false;
            }
            return this.value.equals(constant.value);
        }

        public int hashCode() {
            int result = this.tag.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "<CONSTANT " + this.tag.toString() + " " + this.stringVal() + ">";
        }
    }

    public static enum SUBTAG {
        REF_GETFIELD(1, "REF_getField", "REF_GETFIELD"),
        REF_GETSTATIC(2, "REF_getStatic", "REF_GETSTATIC"),
        REF_PUTFIELD(3, "REF_putField", "REF_PUTFIELD"),
        REF_PUTSTATIC(4, "REF_putStatic", "REF_PUTSTATIC"),
        REF_INVOKEVIRTUAL(5, "REF_invokeVirtual", "REF_INVOKEVIRTUAL"),
        REF_INVOKESTATIC(6, "REF_invokeStatic", "REF_INVOKESTATIC"),
        REF_INVOKESPECIAL(7, "REF_invokeSpecial", "REF_INVOKESPECIAL"),
        REF_NEWINVOKESPECIAL(8, "REF_newInvokeSpecial", "REF_NEWINVOKESPECIAL"),
        REF_INVOKEINTERFACE(9, "REF_invokeInterface", "REF_INVOKEINTERFACE");

        private final Byte value;
        private final String tagName;
        private final String printValue;

        private SUBTAG(byte val, String tagName, String printValue) {
            this.value = val;
            this.tagName = tagName;
            this.printValue = printValue;
        }

        public byte value() {
            return this.value;
        }

        public String description() {
            return this.printValue;
        }

        public String toString() {
            return "<" + this.tagName + "> ";
        }
    }
}

