/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.SignatureData;

public class FieldData
extends MemberData<ClassData> {
    protected int name_cpx;
    protected int type_cpx;
    protected int value_cpx = 0;

    public FieldData(ClassData classData) {
        super(classData);
        this.memberType = "FieldData";
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        switch (attributeTag) {
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "field_info");
                }
                this.signature = new SignatureData((ClassData)this.data).read(in, attributeLength);
                break;
            }
            case ATT_ConstantValue: {
                if (attributeLength != 2) {
                    throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", EAttribute.ATT_ConstantValue.printValue(), attributeLength);
                }
                this.value_cpx = in.readUnsignedShort();
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.type_cpx = in.readUnsignedShort();
        this.readAttributes(in);
        this.environment.traceln("FieldData: name[%d]=%s type[%d]=%s%s", this.name_cpx, ((ClassData)this.data).pool.getString(this.name_cpx, index -> "#" + index + "?"), this.type_cpx, ((ClassData)this.data).pool.getString(this.type_cpx, index -> "#" + index + "?"), this.signature != null ? this.signature : "");
    }

    @Override
    public void print() throws IOException {
        super.printAnnotations();
        StringBuilder prefix = new StringBuilder(this.getIndentString()).append(EModifier.asKeywords(this.access, ClassFileContext.FIELD));
        prefix.append(this.getPseudoFlagsAsString());
        prefix.append(JasmTokens.Token.FIELDREF.parseKey()).append(' ');
        this.printVar(prefix, this.value_cpx != 0 ? " = ".concat(((ClassData)this.data).pool.ConstantStrValue(this.value_cpx)) : null, this.name_cpx, this.type_cpx, this.value_cpx);
    }
}

