/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.function.Supplier;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.jdis.Printable;

public class Indenter
implements Printable {
    public static final int INDENT_STEP = 2;
    public static final int INDENT_OFFSET = 2;
    public static final String INDENT_STRING = " ";
    public static final String ARGUMENT_DELIMITER = "^";
    public static final String LINE_SPLITTER = "\u2f80";
    public static final int PROGRAM_COUNTER_PLACEHOLDER_LENGTH = 7;
    public static final int INSTR_PREFIX_LENGTH = 7;
    public static final int STACKMAP_TYPE_PLACEHOLDER_LENGTH = 17;
    public static final int OPERAND_PLACEHOLDER_LENGTH = 17;
    public static final int COMMENT_PADDING = 16;
    public static final int COMMENT_OFFSET = 0;
    protected final boolean printCPIndex = Options.contains(Options.PR.CPX);
    protected final boolean skipComments = Options.contains(Options.PR.NC);
    protected final boolean printProgramCounter = Options.contains(Options.PR.PC);
    protected final boolean printLabelAsIdentifiers = Options.contains(Options.PR.LABS) && !this.printProgramCounter;
    protected final boolean printConstantPool = Options.contains(Options.PR.CP);
    protected final boolean printSourceLines = Options.contains(Options.PR.SRC);
    protected final boolean printLocalVars = Options.contains(Options.PR.VAR);
    protected final boolean printLineTable = Options.contains(Options.PR.LNT);
    protected final boolean printHEX = Options.contains(Options.PR.HEX);
    protected ToolOutput toolOutput;
    private int commentOffset = 0;
    private int length = 0;
    private int offset = 2;
    private int step = 2;
    private String fillString = " ";

    @Override
    public void print() throws IOException {
        throw new RuntimeException("not yet implemented");
    }

    public Indenter(ToolOutput toolOutput) {
        this();
        this.toolOutput = toolOutput;
    }

    protected Indenter() {
    }

    public Indenter printIndentLn(String s) {
        this.toolOutput.printlns(this.Indent(s));
        return this;
    }

    public Indenter printIndentLn() {
        this.toolOutput.printlns("");
        return this;
    }

    public int getIndentStep() {
        return this.step;
    }

    public Indenter printIndentLn(String format, Object ... args) {
        this.toolOutput.printlns(this.Indent(new Formatter().format(format, args).toString()));
        return this;
    }

    public Indenter printIndent(String format, Object ... args) {
        this.toolOutput.prints(this.Indent(new Formatter().format(format, args).toString()));
        return this;
    }

    public Indenter printIndent(String s) {
        this.toolOutput.prints(this.Indent(s));
        return this;
    }

    public Indenter printIndent() {
        this.toolOutput.prints(this.getIndentString());
        return this;
    }

    public Indenter printPadRight(String s, int totalWidth) {
        this.toolOutput.prints(this.PadRight(s, totalWidth));
        return this;
    }

    public Indenter printPadLeft(String s, int totalWidth) {
        this.toolOutput.prints(this.PadLeft(s, totalWidth));
        return this;
    }

    public Indenter printIndentPadRight(String str, int totalWidth) {
        this.toolOutput.prints(this.IndentPadRight(str, totalWidth));
        return this;
    }

    public Indenter print(String s) {
        this.toolOutput.prints(s);
        return this;
    }

    public Indenter print(String format, Object ... args) {
        this.toolOutput.prints(new Formatter().format(format, args).toString());
        return this;
    }

    public Indenter println(String s) {
        this.toolOutput.printlns(s);
        return this;
    }

    public Indenter println() {
        this.toolOutput.printlns("");
        return this;
    }

    public Indenter println(Supplier<Boolean> isPrint) {
        if (isPrint.get().booleanValue()) {
            this.toolOutput.printlns("");
        }
        return this;
    }

    public Indenter println(String format, Object ... args) {
        this.toolOutput.printlns(new Formatter().format(format, args).toString());
        return this;
    }

    public Indenter incIndent() {
        this.length += this.step;
        return this;
    }

    public Indenter decIndent() {
        this.length -= this.step;
        if (this.length < 0) {
            this.length = 0;
        }
        return this;
    }

    public Indenter setTheSame(Indenter that) {
        this.length = that.length;
        this.offset = that.offset;
        this.step = that.step;
        this.fillString = that.fillString;
        return this;
    }

    public Indenter resetIndent() {
        return this.initIndent(2);
    }

    public Indenter initIndent(int initialOffset) {
        this.length = 0;
        this.step = 2;
        this.offset = initialOffset;
        this.fillString = INDENT_STRING;
        return this;
    }

    public int getIndentSize() {
        return this.offset + this.length;
    }

    public String nCopies(int n) {
        return String.join((CharSequence)"", Collections.nCopies(n, this.fillString));
    }

    public String getIndentString() {
        return this.nCopies(this.getIndentSize());
    }

    public String IndentPadLeft(String str, int totalWidth) {
        return this.getIndentString() + this.PadLeft(str, totalWidth);
    }

    public String IndentPadRight(String str, int totalWidth) {
        return this.getIndentString() + this.PadRight(str, totalWidth);
    }

    public String PadLeft(String str, int totalWidth) {
        int count;
        if (totalWidth > 0 && (count = totalWidth - ((String)str).length()) > 0) {
            str = this.nCopies(count) + (String)str;
        }
        return str;
    }

    public String PadRight(String str, int totalWidth) {
        int count;
        if (totalWidth > 0 && (count = totalWidth - ((String)str).length()) > 0) {
            str = (String)str + this.nCopies(count);
        }
        return str;
    }

    public String padRight(String value, int width, char pad) {
        if (value.length() >= width) {
            return value;
        }
        char[] buf = new char[width];
        Arrays.fill(buf, value.length(), width, pad);
        value.getChars(0, value.length(), buf, 0);
        return new String(buf);
    }

    public String padLeft(String value, int width, char pad) {
        if (value.length() >= width) {
            return value;
        }
        char[] buf = new char[width];
        int padLen = width - value.length();
        Arrays.fill(buf, 0, padLen, pad);
        value.getChars(0, value.length(), buf, padLen);
        return new String(buf);
    }

    public String Indent(String str) {
        return this.getIndentString() + str;
    }

    public String enlargedIndent(String str, int shift) {
        this.offset += shift;
        str = this.Indent(str);
        this.offset -= shift;
        return str;
    }

    public String enlargedIndent(int shift) {
        return this.enlargedIndent("", shift);
    }

    public int getCommentOffset() {
        return this.commentOffset;
    }

    public Indenter setCommentOffset(int commentOffset) {
        this.commentOffset = commentOffset;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public Indenter setOffset(int offset) {
        this.offset = offset;
        return this;
    }
}

