/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;

class InnerClassData
extends Indenter {
    ClassData cls;
    int inner_class_info_index;
    int outer_class_info_index;
    int inner_name_index;
    int access;

    public InnerClassData(ClassData cls) {
        super(cls.toolOutput);
        this.cls = cls;
    }

    public void read(DataInputStream in) throws IOException {
        this.inner_class_info_index = in.readUnsignedShort();
        this.outer_class_info_index = in.readUnsignedShort();
        this.inner_name_index = in.readUnsignedShort();
        this.access = in.readUnsignedShort();
    }

    @Override
    public void print() throws IOException {
        String prefix = EModifier.asKeywords(this.access, ClassFileContext.INNER_CLASS).concat(JasmTokens.Token.INNERCLASS.parseKey()).concat(" ");
        if (this.printCPIndex) {
            if (this.inner_name_index != 0) {
                prefix = prefix.concat("#" + this.inner_name_index + " = ");
            }
            if (this.inner_class_info_index != 0) {
                prefix = prefix.concat("#" + this.inner_class_info_index);
            }
            if (this.outer_class_info_index != 0) {
                prefix = prefix.concat(" of #" + this.outer_class_info_index);
            }
            prefix = prefix.concat(";");
            if (this.skipComments) {
                this.printIndent(prefix);
            } else {
                this.printIndentPadRight(prefix, this.getCommentOffset() - 1).print(" // ");
            }
        } else {
            this.printIndent(prefix);
        }
        if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
            if (this.inner_name_index != 0) {
                this.print(this.cls.pool.getName(this.inner_name_index) + " = ");
            }
            if (this.inner_class_info_index != 0) {
                this.print(this.cls.pool.ConstantStrValue(this.inner_class_info_index));
            }
            if (this.outer_class_info_index != 0) {
                this.print(String.format(" of %s", this.cls.pool.ConstantStrValue(this.outer_class_info_index)));
            }
            this.println(this.cls.printCPIndex && !this.skipComments ? "" : ";");
        } else {
            this.println();
        }
    }
}

