/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jasm.OpcodeTables;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.MethodData;
import org.openjdk.asmtools.jdis.StackMapData;
import org.openjdk.asmtools.jdis.TrapData;

class InstructionAttr
extends MemberData<MethodData> {
    short lineNum = 0;
    boolean referred = false;
    ArrayList<CodeData.LocVarData> vars;
    ArrayList<CodeData.LocVarData> endVars;
    ArrayList<TrapData> handlers;
    ArrayList<TrapData> traps;
    ArrayList<TrapData> endTraps;
    StackMapData stackMapEntry;
    ClassData classData;

    public InstructionAttr(MethodData methodData) {
        super(methodData);
        this.classData = (ClassData)methodData.data;
    }

    void addVar(CodeData.LocVarData var) {
        if (this.vars == null) {
            this.vars = new ArrayList(4);
        }
        this.vars.add(var);
    }

    void addEndVar(CodeData.LocVarData endVar) {
        if (this.endVars == null) {
            this.endVars = new ArrayList(4);
        }
        this.endVars.add(endVar);
    }

    void addTrap(TrapData trap) {
        if (this.traps == null) {
            this.traps = new ArrayList(4);
        }
        this.traps.add(trap);
    }

    void addEndTrap(TrapData endTrap) {
        if (this.endTraps == null) {
            this.endTraps = new ArrayList(4);
        }
        this.endTraps.add(endTrap);
    }

    void add_handler(TrapData endHandler) {
        if (this.handlers == null) {
            this.handlers = new ArrayList(4);
        }
        this.handlers.add(endHandler);
    }

    public void printEnds(int shift) throws IOException {
        if (this.endVars != null && ((MethodData)this.data).printLocalVars) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_endvar.parseKey(), 18), shift));
            this.println(this.endVars.stream().map(ev -> Short.toString(ev.slot)).collect(Collectors.joining(",")) + ";");
        }
        if (this.endTraps != null) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_endtry.parseKey(), 18), shift));
            this.println(this.endTraps.stream().map(TrapData::id).collect(Collectors.joining(",")) + ";");
        }
    }

    public void printBegins(int shift) {
        boolean bothOpt;
        boolean eitherOpt = ((MethodData)this.data).printLineTable || ((MethodData)this.data).printSourceLines;
        boolean bl = bothOpt = ((MethodData)this.data).printLineTable && ((MethodData)this.data).printSourceLines;
        if (eitherOpt && this.lineNum != 0) {
            this.decIndent();
            if (bothOpt) {
                srcLine = this.classData.getSrcLine(this.lineNum);
                this.printIndentLn("// " + this.lineNum + (String)(srcLine != null ? "# " + srcLine : ""));
            } else if (((MethodData)this.data).printLineTable) {
                this.printIndentLn("// %d#", this.lineNum);
            } else if (((MethodData)this.data).printSourceLines) {
                srcLine = this.classData.getSrcLine(this.lineNum);
                this.printIndentLn((String)(srcLine != null ? "// " + srcLine : ""));
            }
            this.incIndent();
        }
        if (this.handlers != null) {
            for (TrapData trapData : this.handlers) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_catch.parseKey(), 18), shift));
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println("%s #%d;", trapData.id(), trapData.catch_cpx);
                        continue;
                    }
                    this.print(this.PadRight(String.format("%s #%d;", trapData.id(), trapData.catch_cpx), this.getCommentOffset() - 17 - this.getIndentStep()));
                    this.println(" // " + (trapData.catch_cpx == 0 ? "any" : ((MethodData)this.data).pool.getClassName(trapData.catch_cpx)));
                    continue;
                }
                this.println("%s %s;", trapData.id(), ((MethodData)this.data).pool.getClassName(trapData.catch_cpx));
            }
        }
        if (this.traps != null) {
            this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_try.parseKey(), 18), shift));
            this.println(this.traps.stream().map(TrapData::id).collect(Collectors.joining(", ")) + ";");
        }
        if (this.vars != null && ((MethodData)this.data).printLocalVars) {
            for (CodeData.LocVarData locVarData : this.vars) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_var.parseKey(), 18), shift));
                if (this.printCPIndex) {
                    if (this.skipComments) {
                        this.println("%d #%d:#%d;", locVarData.slot, locVarData.name_cpx, locVarData.sig_cpx);
                        continue;
                    }
                    this.print(this.PadRight(String.format("%d #%d:#%d;", locVarData.slot, locVarData.name_cpx, locVarData.sig_cpx), this.getCommentOffset() - 17 - this.getIndentStep()));
                    this.println(" // %s:%s", ((MethodData)this.data).pool.getName(locVarData.name_cpx), ((MethodData)this.data).pool.getName(locVarData.sig_cpx));
                    continue;
                }
                this.println("%d %s:%s;", locVarData.slot, ((MethodData)this.data).pool.getName(locVarData.name_cpx), ((MethodData)this.data).pool.getName(locVarData.sig_cpx));
            }
        }
    }

    public Pair<String, String> getMapListAsString(int[] map) {
        StringBuilder left = new StringBuilder();
        StringBuilder right = new StringBuilder();
        for (int k = 0; k < map.length; ++k) {
            int fullMapType = map[k];
            int mtVal = fullMapType & 0xFF;
            StackMap.VerificationType mapVerificationType = StackMap.getVerificationType(mtVal, Optional.of(s -> this.environment.printErrorLn((String)s, new Object[0])));
            String prefix = k == 0 ? "" : " ";
            int argument = fullMapType >> 8;
            switch (mapVerificationType) {
                case ITEM_Object: {
                    if (((MethodData)this.data).printCPIndex) {
                        left.append(prefix).append("#").append(argument);
                    }
                    right.append(prefix).append(((MethodData)this.data).pool.ConstantStrValue(argument));
                    break;
                }
                case ITEM_NewObject: {
                    if (((MethodData)this.data).printCPIndex) {
                        left.append(prefix).append(mtVal);
                        left.append(" ").append(((MethodData)this.data).lP).append(argument);
                    }
                    right.append(prefix).append(mapVerificationType.printName());
                    right.append(" ").append(((MethodData)this.data).lP).append(argument);
                    break;
                }
                default: {
                    if (((MethodData)this.data).printCPIndex) {
                        left.append(prefix).append(mtVal);
                    }
                    right.append(prefix).append(mapVerificationType.printName());
                }
            }
            if (((MethodData)this.data).printCPIndex) {
                left.append(k == map.length - 1 ? (char)';' : ',');
            }
            right.append(k == map.length - 1 ? (char)';' : ',');
        }
        return new Pair<String, String>(left.toString(), right.toString());
    }

    public boolean printStackMap(int shift) {
        Pair<String, String> line;
        int[] map;
        if (this.stackMapEntry == null) {
            return false;
        }
        boolean printed = false;
        int mapShift = this.getCommentOffset() - 17 - this.getIndentStep();
        if (this.stackMapEntry.stackFrameType != null) {
            this.printPadRight(OpcodeTables.Opcode.opc_stack_frame_type.parseKey(), 18);
            if (this.printCPIndex && !this.skipComments) {
                this.print(this.PadRight(this.stackMapEntry.stackFrameType.tagName() + ";", mapShift)).println(" // frame_type " + this.stackMapEntry.stackFrameTypeValue);
            } else {
                this.println(this.stackMapEntry.stackFrameType.tagName() + ";");
            }
            printed = true;
        }
        if ((map = this.stackMapEntry.lockMap) != null && map.length > 0) {
            line = this.getMapListAsString(map);
            if (this.stackMapEntry.type == StackMapData.EAttributeType.STACKMAPTABLE) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_locals_map.parseKey(), 18), shift));
            } else {
                this.print(this.PadRight(OpcodeTables.Opcode.opc_locals_map.parseKey(), 18));
            }
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.println((String)line.first);
                } else {
                    this.print(this.PadRight((String)line.first, mapShift));
                    mapShift = Math.max(mapShift, ((String)line.first).length());
                    this.print(" // ");
                }
            }
            if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
                this.println((String)line.second);
            }
            printed = true;
        }
        if ((map = this.stackMapEntry.stackMap) != null && map.length > 0) {
            line = this.getMapListAsString(map);
            if (this.stackMapEntry.type == StackMapData.EAttributeType.STACKMAPTABLE) {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_stack_map.parseKey(), 18), shift));
            } else {
                this.print(this.enlargedIndent(this.PadRight(OpcodeTables.Opcode.opc_stack_map.parseKey(), 18), shift));
            }
            if (this.printCPIndex) {
                if (this.skipComments) {
                    this.println((String)line.first);
                } else {
                    this.print(this.PadRight((String)line.first, mapShift));
                    this.print(" // ");
                }
            }
            if (!this.printCPIndex || this.printCPIndex && !this.skipComments) {
                this.println((String)line.second);
            }
            printed = true;
        }
        if (!printed) {
            if (this.stackMapEntry.type == StackMapData.EAttributeType.STACKMAPTABLE) {
                this.println(this.enlargedIndent(OpcodeTables.Opcode.opc_locals_map.parseKey() + ";", 18));
            } else {
                this.println(OpcodeTables.Opcode.opc_locals_map.parseKey() + ";");
            }
        }
        return true;
    }
}

