/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.openjdk.asmtools.common.inputs.FileInput;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.StdoutOutput;
import org.openjdk.asmtools.common.outputs.ToolOutput;
import org.openjdk.asmtools.common.outputs.log.DualOutputStreamOutput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.JdisTool;
import org.openjdk.asmtools.jdis.Options;
import org.openjdk.asmtools.util.ProductInfo;

public class Main
extends JdisTool {
    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput ... toolInputs) {
        super(toolOutput, log);
        Collections.addAll(this.fileList, toolInputs);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput) {
        super(toolOutput, log);
        this.fileList.add(toolInput);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput log, ToolInput toolInput, String ... argv) {
        super(toolOutput, log);
        if (toolInput != null) {
            this.fileList.add(toolInput);
        }
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, String ... argv) {
        super(toolOutput);
        this.parseArgs(argv);
    }

    public Main(ToolOutput toolOutput, DualStreamToolOutput logger, String ... argv) {
        super(toolOutput, logger);
        this.parseArgs(argv);
    }

    public static void main(String ... argv) {
        Main disassembler = new Main((ToolOutput)new StdoutOutput(), argv);
        System.exit(disassembler.disasm());
    }

    public synchronized boolean disasm(String ... argv) {
        this.parseArgs(argv);
        return this.disasm() == 0;
    }

    public synchronized int disasm() {
        for (ToolInput inputFileName : this.fileList) {
            try {
                ((JdisEnvironment)this.environment).setInputFile(inputFileName);
                ClassData classData = new ClassData((JdisEnvironment)this.environment);
                try (DataInputStream dis = inputFileName.getDataInputStream(Optional.of(this.environment));){
                    classData.read(dis, Paths.get(inputFileName.getFileName(), new String[0]));
                }
                ((JdisEnvironment)this.environment).getToolOutput().startClass(classData.className, Optional.of(".jasm"), this.environment);
                classData.print();
                ((JdisEnvironment)this.environment).getToolOutput().finishClass(classData.className);
                ((JdisEnvironment)this.environment).getOutputs().flush();
                continue;
            }
            catch (FileNotFoundException fnf) {
                ((JdisEnvironment)this.environment).printException(fnf);
                ((JdisEnvironment)this.environment).error("err.not_found", inputFileName);
            }
            catch (IOException | ClassFormatError ioe) {
                ((JdisEnvironment)this.environment).printException(ioe);
                if (!((JdisEnvironment)this.environment).getVerboseFlag()) {
                    ((JdisEnvironment)this.environment).printErrorLn(ioe.getMessage(), new Object[0]);
                }
                ((JdisEnvironment)this.environment).error("err.fatal_error", inputFileName);
            }
            catch (Error error) {
                ((JdisEnvironment)this.environment).printException(error);
                ((JdisEnvironment)this.environment).error("err.fatal_error", inputFileName);
            }
            catch (Exception ex) {
                ((JdisEnvironment)this.environment).printException(ex);
                ((JdisEnvironment)this.environment).error("err.fatal_exception", inputFileName);
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void usage() {
        ((JdisEnvironment)this.environment).usage(List.of("info.usage", "info.opt.d", "info.opt.g", "info.opt.nc", "info.opt.lt", "info.opt.lv", "info.opt.instr.offset", "info.opt.hx", "info.opt.sl", "info.opt.t", "info.opt.v", "info.opt.version"));
    }

    @Override
    protected void parseArgs(String ... argv) {
        block33: for (int i = 0; i < argv.length; ++i) {
            String arg;
            switch (arg = argv[i]) {
                case "-g": {
                    Options.setDetailedOutputOptions();
                    continue block33;
                }
                case "-v": {
                    Options.set(Options.PR.VERBOSE);
                    ((JdisEnvironment)this.environment).setVerboseFlag(true);
                    continue block33;
                }
                case "-t": {
                    Options.set(Options.PR.VERBOSE);
                    Options.set(Options.PR.TRACE);
                    ((JdisEnvironment)this.environment).setVerboseFlag(true);
                    ((JdisEnvironment)this.environment).setTraceFlag(true);
                    continue block33;
                }
                case "-pc": {
                    Options.set(Options.PR.PC);
                    continue block33;
                }
                case "-sl": {
                    Options.set(Options.PR.SRC);
                    continue block33;
                }
                case "-lt": {
                    Options.set(Options.PR.LNT);
                    continue block33;
                }
                case "-nc": {
                    Options.set(Options.PR.NC);
                    continue block33;
                }
                case "-lv": {
                    Options.set(Options.PR.VAR);
                    continue block33;
                }
                case "-hx": {
                    Options.set(Options.PR.HEX);
                    continue block33;
                }
                case "-d": {
                    this.setDestDir(++i, argv);
                    continue block33;
                }
                case "-dls": {
                    ((JdisEnvironment)this.environment).setOutputs(new DualOutputStreamOutput());
                    continue block33;
                }
                case "-version": {
                    ((JdisEnvironment)this.environment).println(ProductInfo.FULL_VERSION, new Object[0]);
                    System.exit(0);
                }
                case "-": {
                    this.addStdIn();
                    continue block33;
                }
                case "-h": 
                case "-help": {
                    this.usage();
                    System.exit(0);
                }
                default: {
                    if (arg.startsWith("-")) {
                        ((JdisEnvironment)this.environment).error("err.invalid_option", arg);
                        this.usage();
                        System.exit(1);
                        continue block33;
                    }
                    this.fileList.add(new FileInput(arg));
                }
            }
        }
        if (this.fileList.isEmpty()) {
            this.usage();
            System.exit(1);
        }
    }
}

