/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AttrData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.JdisEnvironment;
import org.openjdk.asmtools.jdis.SignatureData;
import org.openjdk.asmtools.jdis.TypeAnnotationData;

public abstract class MemberData<T extends MemberData>
extends Indenter {
    protected static final String DEFAULT_VALUE_PREFIX = "default { ";
    protected T data;
    protected JdisEnvironment environment;
    protected ConstantPool pool;
    protected String memberType = "";
    protected int access;
    protected boolean isSynthetic = false;
    protected boolean isDeprecated = false;
    private AnnotationElementState annotationElementState = AnnotationElementState.DEFAULT_STATE;
    protected SignatureData signature;
    protected ArrayList<AnnotationData> visibleAnnotations;
    protected ArrayList<AnnotationData> invisibleAnnotations;
    protected ArrayList<TypeAnnotationData> visibleTypeAnnotations;
    protected ArrayList<TypeAnnotationData> invisibleTypeAnnotations;
    protected ArrayList<AttrData> attributes;

    public MemberData(T data) {
        super(((MemberData)data).toolOutput);
        this.environment = ((MemberData)data).environment;
        this.init(data);
    }

    public MemberData(JdisEnvironment environment) {
        super(environment.getToolOutput());
        this.environment = environment;
    }

    public void init(T data) {
        this.data = data;
        this.pool = ((MemberData)data).pool;
    }

    public ConstantPool getConstantPool() {
        return this.pool;
    }

    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        return false;
    }

    protected String getPseudoFlagsAsString() {
        Object s = "";
        if (this.isSynthetic) {
            s = (String)s + JasmTokens.Token.SYNTHETIC.parseKey() + " ";
        }
        if (this.isDeprecated) {
            s = (String)s + JasmTokens.Token.DEPRECATED.parseKey() + " ";
        }
        return s;
    }

    public AnnotationElementState getAnnotationElementState() {
        return this.annotationElementState;
    }

    public MemberData setElementState(AnnotationElementState state) {
        this.annotationElementState = state;
        return this;
    }

    protected final int getAnnotationsCount() {
        return (this.visibleAnnotations == null ? 0 : this.visibleAnnotations.size()) + (this.invisibleAnnotations == null ? 0 : this.invisibleAnnotations.size()) + (this.visibleTypeAnnotations == null ? 0 : this.visibleTypeAnnotations.size()) + (this.invisibleTypeAnnotations == null ? 0 : this.invisibleTypeAnnotations.size());
    }

    protected final void printAnnotations() throws IOException {
        if (this.getAnnotationsCount() > 0) {
            if (this.visibleAnnotations != null) {
                for (AnnotationData va : this.visibleAnnotations) {
                    va.setTheSame(this).print();
                    this.println();
                }
            }
            if (this.invisibleAnnotations != null) {
                for (AnnotationData ia : this.invisibleAnnotations) {
                    ia.setTheSame(this).print();
                    this.println();
                }
            }
            if (this.visibleTypeAnnotations != null) {
                for (TypeAnnotationData vta : this.visibleTypeAnnotations) {
                    vta.setTheSame(this).print();
                    this.println();
                }
            }
            if (this.invisibleTypeAnnotations != null) {
                for (TypeAnnotationData ita : this.invisibleTypeAnnotations) {
                    ita.setTheSame(this).print();
                    this.println();
                }
            }
        }
    }

    protected void printVar(StringBuilder prefix, String postfix, int name_cpx, int type_cpx, int value_cpx) {
        Pair<String, String> signInfo;
        Pair<String, String> pair = signInfo = this.signature != null ? this.signature.getPrintInfo(i -> this.pool.inRange((int)i)) : new Pair<String, String>("", "");
        if (this.printCPIndex) {
            prefix.append('#').append(name_cpx).append(":#").append(type_cpx).append((String)signInfo.first);
            if (value_cpx != 0) {
                prefix.append(" = #").append(value_cpx);
            }
            prefix.append(';');
            if (this.skipComments) {
                this.print(prefix.toString());
            } else {
                this.printPadRight(prefix.toString(), this.getCommentOffset() - 1).print(" // ");
                this.print(((MemberData)this.data).pool.getName(name_cpx) + ":" + ((MemberData)this.data).pool.getName(type_cpx) + (String)signInfo.second + (postfix != null ? postfix : ""));
            }
        } else {
            prefix.append(((MemberData)this.data).pool.getName(name_cpx)).append(':').append(((MemberData)this.data).pool.getName(type_cpx)).append((String)signInfo.second);
            if (postfix != null) {
                prefix.append(postfix);
            }
            this.print(prefix + ";");
        }
        this.println();
    }

    protected void readAttributes(DataInputStream in) throws IOException {
        int attributesCount = in.readUnsignedShort();
        this.attributes = new ArrayList(attributesCount);
        this.environment.traceln(String.format("%s - Attributes[%d]", this.memberType, attributesCount), new Object[0]);
        block6: for (int k = 0; k < attributesCount; ++k) {
            int name_cpx = in.readUnsignedShort();
            AttrData attrData = new AttrData(this.environment);
            this.attributes.add(attrData);
            String attr_name = ((MemberData)this.data).pool.getString(name_cpx, index -> "#" + index);
            this.environment.traceln(String.format("Attribute#%d name[%d]=\"%s\"", k, name_cpx, attr_name), new Object[0]);
            EAttribute tag = EAttribute.get(attr_name);
            int attrLength = in.readInt();
            switch (tag) {
                case ATT_Synthetic: {
                    if (attrLength != 0) {
                        throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", tag.printValue(), attrLength);
                    }
                    this.isSynthetic = true;
                    continue block6;
                }
                case ATT_Deprecated: {
                    if (attrLength != 0) {
                        throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", tag.printValue(), attrLength);
                    }
                    this.isDeprecated = true;
                    continue block6;
                }
                case ATT_RuntimeVisibleAnnotations: 
                case ATT_RuntimeInvisibleAnnotations: {
                    int count = in.readShort();
                    ArrayList<AnnotationData<T>> annotations = new ArrayList<AnnotationData<T>>(count);
                    boolean invisible = tag == EAttribute.ATT_RuntimeInvisibleAnnotations;
                    for (int i = 0; i < count; ++i) {
                        AnnotationData<T> annotationData = new AnnotationData<T>(this.data, invisible);
                        annotationData.read(in);
                        annotations.add(annotationData);
                    }
                    if (invisible) {
                        this.invisibleAnnotations = annotations;
                        continue block6;
                    }
                    this.visibleAnnotations = annotations;
                    continue block6;
                }
                case ATT_RuntimeVisibleTypeAnnotations: 
                case ATT_RuntimeInvisibleTypeAnnotations: {
                    int count = in.readShort();
                    ArrayList<TypeAnnotationData<T>> typeAnnotations = new ArrayList<TypeAnnotationData<T>>(count);
                    boolean invisible = tag == EAttribute.ATT_RuntimeInvisibleTypeAnnotations;
                    for (int i = 0; i < count; ++i) {
                        TypeAnnotationData<T> typeAnnotationData = new TypeAnnotationData<T>(this.data, invisible);
                        typeAnnotationData.read(in);
                        typeAnnotations.add(typeAnnotationData);
                    }
                    if (invisible) {
                        this.invisibleTypeAnnotations = typeAnnotations;
                        continue block6;
                    }
                    this.visibleTypeAnnotations = typeAnnotations;
                    continue block6;
                }
                default: {
                    boolean handled = this.handleAttributes(in, tag, attrLength);
                    if (!handled) {
                        attrData.read(name_cpx, attrLength, in);
                        continue block6;
                    }
                    attrData.setNameCpx(name_cpx).setLength(attrLength);
                }
            }
        }
    }

    public static enum AnnotationElementState {
        HAS_DEFAULT_VALUE,
        DEFAULT_STATE,
        PARAMETER_ANNOTATION,
        RIGHT_OPERAND,
        INLINED_ELEMENT;

    }
}

