/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.AnnotationElement;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.MemberData;
import org.openjdk.asmtools.jdis.ParameterAnnotationData;
import org.openjdk.asmtools.jdis.SignatureData;

public class MethodData
extends MemberData<ClassData> {
    protected int name_cpx;
    protected int sig_cpx;
    protected String lP;
    protected ArrayList<ParamNameData> paramNameDates;
    protected ParameterAnnotationData visibleParameterAnnotations;
    protected ParameterAnnotationData invisibleParameterAnnotations;
    protected AnnotationElement.AnnotationValue defaultAnnotation;
    private CodeData code;
    private int[] exc_table = null;

    public MethodData(ClassData classData) {
        super(classData);
        this.memberType = "MethodData";
        this.setCommentOffset(classData.pool.getCommentOffset());
        this.lP = this.printLabelAsIdentifiers ? "L" : "";
        this.paramNameDates = null;
    }

    @Override
    protected boolean handleAttributes(DataInputStream in, EAttribute attributeTag, int attributeLength) throws IOException {
        boolean handled = true;
        switch (attributeTag) {
            case ATT_Code: {
                this.code = new CodeData(this);
                this.code.read(in, attributeLength);
                break;
            }
            case ATT_Signature: {
                if (this.signature != null) {
                    this.environment.warning("warn.one.attribute.required", "Signature", "method_info");
                }
                this.signature = new SignatureData((ClassData)this.data).read(in, attributeLength);
                break;
            }
            case ATT_Exceptions: {
                this.readExceptions(in);
                break;
            }
            case ATT_MethodParameters: {
                this.readMethodParameters(in);
                break;
            }
            case ATT_RuntimeVisibleParameterAnnotations: 
            case ATT_RuntimeInvisibleParameterAnnotations: {
                boolean invisible = attributeTag == EAttribute.ATT_RuntimeInvisibleParameterAnnotations;
                ParameterAnnotationData<MethodData> parameterAnnotationData = new ParameterAnnotationData<MethodData>(this, invisible);
                parameterAnnotationData.read(in);
                if (invisible) {
                    this.invisibleParameterAnnotations = parameterAnnotationData;
                    break;
                }
                this.visibleParameterAnnotations = parameterAnnotationData;
                break;
            }
            case ATT_AnnotationDefault: {
                this.defaultAnnotation = AnnotationElement.readValue(in, (ClassData)this.data, false);
                break;
            }
            default: {
                handled = false;
            }
        }
        return handled;
    }

    public void read(DataInputStream in) throws IOException {
        this.access = in.readUnsignedShort();
        this.name_cpx = in.readUnsignedShort();
        this.sig_cpx = in.readUnsignedShort();
        this.environment.traceln("MethodData: {modifiers[%d]}:%s name[%d]=%s signature[%d]=%s", this.access, EModifier.asNames(this.access, ClassFileContext.METHOD).isEmpty() ? "<none>" : Boolean.valueOf(EModifier.asNames(this.access, ClassFileContext.METHOD).isEmpty()), this.name_cpx, ((ClassData)this.data).pool.getString(this.name_cpx, index -> "???"), this.sig_cpx, ((ClassData)this.data).pool.getString(this.sig_cpx, index -> "???"));
        this.readAttributes(in);
    }

    private void readExceptions(DataInputStream in) throws IOException {
        int exc_table_len = in.readUnsignedShort();
        this.environment.traceln("ExceptionsAttr[%d]", exc_table_len);
        this.exc_table = new int[exc_table_len];
        for (int l = 0; l < exc_table_len; ++l) {
            short exc = in.readShort();
            this.environment.traceln("throws: #" + exc, new Object[0]);
            this.exc_table[l] = exc;
        }
    }

    private void readMethodParameters(DataInputStream in) throws IOException {
        int num_params = in.readUnsignedByte();
        this.environment.traceln("MethodParametersAttr[%d]", num_params);
        this.paramNameDates = new ArrayList(num_params);
        for (int i = 0; i < num_params; ++i) {
            short paramNameCpx = (short)in.readUnsignedShort();
            int paramAccess = in.readUnsignedShort();
            this.environment.traceln("Param[%d] = { name[%d]: \"%s\" modifiers[%d]: %s}", i, paramNameCpx, this.pool.getString(paramNameCpx, index -> "???"), paramAccess, EModifier.asNames(paramAccess, ClassFileContext.METHOD));
            this.paramNameDates.add(i, new ParamNameData(paramNameCpx, paramAccess));
        }
    }

    public void printPAnnotations() throws IOException {
        int visSize = 0;
        int invisSize = 0;
        int pNumSize = 0;
        if (this.visibleParameterAnnotations != null) {
            visSize = this.visibleParameterAnnotations.numParams();
        }
        if (this.invisibleParameterAnnotations != null) {
            invisSize = this.invisibleParameterAnnotations.numParams();
        }
        if (this.paramNameDates != null) {
            pNumSize = this.paramNameDates.size();
        }
        int maxParams = Math.max(pNumSize, invisSize);
        maxParams = Math.max(visSize, maxParams);
        String[] paramNames = this.getPrintableParameterNames(maxParams);
        int annotOffset = Arrays.stream(paramNames).mapToInt(name -> name == null ? 0 : name.length()).max().orElse(0) + 1;
        for (int paramNum = 0; paramNum < maxParams; ++paramNum) {
            boolean hasAnnotations;
            ArrayList<AnnotationData> visAnnotationDataList = this.visibleParameterAnnotations != null && paramNum < visSize ? this.visibleParameterAnnotations.get(paramNum) : null;
            ArrayList<AnnotationData> invisAnnotationDataList = this.invisibleParameterAnnotations != null && paramNum < invisSize ? this.invisibleParameterAnnotations.get(paramNum) : null;
            ParamNameData paramNameData = this.paramNameDates != null ? this.paramNameDates.get(paramNum) : null;
            boolean bl = hasAnnotations = visAnnotationDataList != null || invisAnnotationDataList != null;
            if (paramNameData != null && paramNameData.name_cpx == 0) {
                paramNameData = null;
            }
            if (paramNameData == null && !hasAnnotations) continue;
            this.printIndent(this.PadRight(paramNum + ": ", 5));
            int offset = annotOffset + 4;
            if (paramNameData != null) {
                this.printPadRight(paramNames[paramNum], annotOffset);
                ++offset;
            }
            boolean firstTime = this.printAnnotationDataList(visAnnotationDataList, true, offset);
            this.printAnnotationDataList(invisAnnotationDataList, firstTime, annotOffset);
            this.println();
        }
    }

    private boolean printAnnotationDataList(List<AnnotationData> annotationDataList, boolean firstTime, int offset) throws IOException {
        if (annotationDataList != null) {
            for (AnnotationData annot : annotationDataList) {
                if (!firstTime) {
                    this.println().print(this.enlargedIndent(offset));
                } else {
                    firstTime = false;
                }
                annot.setElementState(MemberData.AnnotationElementState.PARAMETER_ANNOTATION).setOffset(offset + this.getIndentSize()).print();
            }
        }
        return firstTime;
    }

    private String[] getPrintableParameterNames(int maxParams) {
        String[] names = new String[maxParams];
        if (this.paramNameDates != null) {
            for (int paramNum = 0; paramNum < maxParams; ++paramNum) {
                ParamNameData paramNameData = this.paramNameDates.get(paramNum);
                names[paramNum] = paramNameData == null || paramNameData.name_cpx == 0 ? "" : JasmTokens.Token.PARAM_NAME.parseKey() + "{ " + ((ClassData)this.data).pool.getString(paramNameData.name_cpx, index -> "#" + index) + " " + EModifier.asKeywords(paramNameData.access, ClassFileContext.METHOD_PARAMETERS) + "}";
            }
        }
        return names;
    }

    @Override
    public void print() throws IOException {
        int newLineIdent;
        boolean extraMethodInfo;
        this.printAnnotations();
        String methSignature = EModifier.asKeywords(this.access, ClassFileContext.METHOD);
        methSignature = methSignature.concat(this.getPseudoFlagsAsString());
        methSignature = methSignature.concat(JasmTokens.Token.METHODREF.parseKey() + " ");
        Pair<String, String> signInfo = this.signature != null ? this.signature.getPrintInfo(i -> this.pool.inRange((int)i)) : new Pair<String, String>("", "");
        boolean bl = extraMethodInfo = this.code != null || this.exc_table != null || this.defaultAnnotation != null;
        if (this.printCPIndex) {
            methSignature = methSignature.concat("#" + this.name_cpx + ":#" + this.sig_cpx + (String)signInfo.first + (extraMethodInfo ? "" : ";"));
            if (this.skipComments) {
                if (this.defaultAnnotation != null) {
                    this.printIndent(this.PadRight(methSignature, this.getCommentOffset() - 1));
                } else {
                    this.printIndent(methSignature);
                }
                newLineIdent = methSignature.length();
            } else {
                this.printIndent(this.PadRight(methSignature, this.getCommentOffset() - 1));
                String comment = (this.defaultAnnotation != null ? " /* " : " // ").concat(((ClassData)this.data).pool.getName(this.name_cpx) + ":" + ((ClassData)this.data).pool.getName(this.sig_cpx) + (String)signInfo.second).concat(this.defaultAnnotation != null ? " */ " : " ");
                newLineIdent = this.getCommentOffset() + comment.length() - 1;
                this.print(comment);
            }
        } else {
            methSignature = methSignature.concat(((ClassData)this.data).pool.getName(this.name_cpx) + ":").concat(((ClassData)this.data).pool.getName(this.sig_cpx) + (String)signInfo.second + (extraMethodInfo ? " " : ";"));
            this.printIndent(methSignature);
            newLineIdent = methSignature.length();
        }
        if (this.defaultAnnotation != null) {
            this.defaultAnnotation.setCommentOffset(newLineIdent);
            this.defaultAnnotation.setElementState(MemberData.AnnotationElementState.HAS_DEFAULT_VALUE);
            this.defaultAnnotation.print();
            this.print(this.code == null && this.exc_table == null ? ";" : " ");
        }
        if (this.exc_table != null) {
            this.printExceptionTable(this.code == null);
        }
        if (this.code != null) {
            this.code.setCommentOffset(this.getCommentOffset());
            this.code.print();
        } else {
            if (this.exc_table != null) {
                this.print(";");
            }
            this.println();
        }
    }

    private void printExceptionTable(boolean abstractMethod) {
        String indexes = "";
        String names = "";
        String throwsClause = this.PadRight(JasmTokens.Token.THROWS.parseKey(), 7);
        for (int i : this.exc_table) {
            if (this.printCPIndex) {
                indexes = indexes.concat(indexes.isEmpty() ? "" : ", ").concat("#" + i);
            }
            names = names.concat(names.isEmpty() ? "" : ", ").concat(((ClassData)this.data).pool.getClassName(i));
        }
        this.println().incIndent();
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.printIndent(throwsClause + indexes + (abstractMethod ? ";" : ""));
            } else {
                this.printIndent(this.PadRight(throwsClause + indexes + (abstractMethod ? ";" : ""), this.getCommentOffset() - this.getIndentStep() - 1)).print(" // " + names);
            }
        } else {
            this.printIndent(throwsClause + names);
        }
        this.decIndent();
    }

    static class ParamNameData {
        public int access;
        public int name_cpx;

        public ParamNameData(int name, int access) {
            this.access = access;
            this.name_cpx = name;
        }
    }
}

