/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.openjdk.asmtools.common.structure.ClassFileContext;
import org.openjdk.asmtools.common.structure.EModifier;
import org.openjdk.asmtools.jasm.NameInfo;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;
import org.openjdk.asmtools.jdis.Options;

public final class ModuleContent
extends Indenter {
    private static int MODULE_DIRECTIVE_PADDING = 9;
    public final Header header;
    public final Set<Uses> uses;
    public final Set<Dependence> requires;
    public final Map<Exported, Set<TargetType>> exports;
    public final Map<Opened, Set<TargetType>> opens;
    public final Map<Provided, Set<TargetType>> provides;

    private ModuleContent(Builder builder) {
        this.header = builder.header;
        this.requires = Collections.unmodifiableSet(builder.requires);
        this.exports = Collections.unmodifiableMap(builder.exports);
        this.opens = Collections.unmodifiableMap(builder.opens);
        this.uses = Collections.unmodifiableSet(builder.uses);
        this.provides = Collections.unmodifiableMap(builder.provides);
    }

    public String getModuleFlags() {
        return EModifier.asKeywords(this.header.getFlags(), ClassFileContext.MODULE);
    }

    public String getModuleName() {
        return this.header.getModuleName();
    }

    public int getModuleCPX() {
        return this.header.getModuleCPX();
    }

    public String getModuleVersion() {
        return this.header.getModuleVersion();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.requires.stream().forEach(d -> sb.append(this.IndentPadRight("requires", MODULE_DIRECTIVE_PADDING)).append(d).append(String.format(";%s%n", d.getModuleVersion() == null ? "" : " // @" + d.getModuleVersion())));
        this.exports.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).map(e -> this.IndentPadRight("exports", MODULE_DIRECTIVE_PADDING).concat(String.format("%s;%n", ((Exported)e.getKey()).toString()))).forEach(sb::append);
        this.exports.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> this.IndentPadRight("exports", MODULE_DIRECTIVE_PADDING).concat(String.format("%s to%n%s;%n", ((Exported)e.getKey()).toString(), ((Set)e.getValue()).stream().map(mn -> this.enlargedIndent(mn.toString(), MODULE_DIRECTIVE_PADDING)).collect(Collectors.joining(",\n"))))).forEach(sb::append);
        this.opens.entrySet().stream().filter(e -> ((Set)e.getValue()).isEmpty()).map(e -> this.IndentPadRight("opens", MODULE_DIRECTIVE_PADDING).concat(String.format("%s;%n", ((Opened)e.getKey()).toString()))).forEach(sb::append);
        this.opens.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> this.IndentPadRight("opens", MODULE_DIRECTIVE_PADDING).concat(String.format("%s to%n%s;%n", ((Opened)e.getKey()).toString(), ((Set)e.getValue()).stream().map(mn -> this.enlargedIndent(mn.toString(), MODULE_DIRECTIVE_PADDING)).collect(Collectors.joining(",\n"))))).forEach(sb::append);
        this.uses.stream().map(s -> this.IndentPadRight("uses", MODULE_DIRECTIVE_PADDING).concat(String.format("%s;%n", s))).forEach(sb::append);
        this.provides.entrySet().stream().filter(e -> !((Set)e.getValue()).isEmpty()).map(e -> this.IndentPadRight("provides", MODULE_DIRECTIVE_PADDING).concat(String.format("%s with%n%s;%n", ((Provided)e.getKey()).toString(), ((Set)e.getValue()).stream().map(mn -> this.enlargedIndent(mn.toString(), MODULE_DIRECTIVE_PADDING)).collect(Collectors.joining(",\n"))))).forEach(sb::append);
        if (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static final class Builder {
        final Set<Dependence> requires = new HashSet<Dependence>();
        final Map<Exported, Set<TargetType>> exports = new HashMap<Exported, Set<TargetType>>();
        final Map<Opened, Set<TargetType>> opens = new HashMap<Opened, Set<TargetType>>();
        final Set<Uses> uses = new HashSet<Uses>();
        final Map<Provided, Set<TargetType>> provides = new HashMap<Provided, Set<TargetType>>();
        private Header header;
        private int moduleFlags = EModifier.ACC_NONE.getFlag();
        private int cpIndex;
        private String moduleName;
        private String moduleVersion;

        public Builder() {
        }

        public Builder(int cpIndex, String moduleName, int moduleFlags, String moduleVersion) {
            this.cpIndex = cpIndex;
            this.moduleFlags = moduleFlags;
            this.moduleName = moduleName;
            this.moduleVersion = moduleVersion;
        }

        public void setModuleFlags(int moduleFlags) {
            this.moduleFlags = moduleFlags;
        }

        public void setCpIndex(int cpIndex) {
            this.cpIndex = cpIndex;
        }

        public void setModuleName(String moduleName) {
            this.moduleName = moduleName;
        }

        public void setModuleVersion(String moduleVersion) {
            this.moduleVersion = moduleVersion;
        }

        public Builder require(int cpIndex, String d, int requiresFlag, String version) {
            return this.require(new Dependence(cpIndex, d, requiresFlag, version));
        }

        public Builder require(Dependence dependence) {
            this.requires.add(dependence);
            return this;
        }

        public Builder exports(Exported p, Set<TargetType> ms) {
            return this.add(this.exports, p, ms);
        }

        public Builder exports(int cpIndex, String packageName, int exportFlags) {
            return this.add(this.exports, new Exported(cpIndex, packageName, exportFlags), new HashSet<TargetType>());
        }

        public Builder exports(int cpIndex, String packageName, int exportFlags, Set<TargetType> ms) {
            return this.add(this.exports, new Exported(cpIndex, packageName, exportFlags), ms);
        }

        public Builder opens(Opened p, Set<TargetType> ms) {
            return this.add(this.opens, p, ms);
        }

        public Builder opens(int cpIndex, String packageName, int exportFlags) {
            return this.add(this.opens, new Opened(cpIndex, packageName, exportFlags), new HashSet<TargetType>());
        }

        public Builder opens(int cpIndex, String packageName, int exportFlags, Set<TargetType> ms) {
            return this.add(this.opens, new Opened(cpIndex, packageName, exportFlags), ms);
        }

        public Builder provides(Provided t, Set<TargetType> implementations) {
            return this.add(this.provides, t, implementations);
        }

        public Builder provides(int cpIndex, String serviceName, Set<TargetType> implementations) {
            return this.provides(new Provided(cpIndex, serviceName), implementations);
        }

        public Builder uses(int cpIndex, String serviceName) {
            return this.uses(new Uses(cpIndex, serviceName));
        }

        public Builder uses(Uses service) {
            this.uses.add(service);
            return this;
        }

        public ModuleContent build() {
            this.header = new Header(this.cpIndex, this.moduleName, this.moduleFlags, this.moduleVersion);
            return new ModuleContent(this);
        }

        private <T extends TargetType> Builder add(Map<T, Set<TargetType>> collection, T source, Set<TargetType> target) {
            Objects.requireNonNull(source);
            Objects.requireNonNull(target);
            if (!collection.containsKey(source)) {
                collection.put(source, new HashSet());
            }
            collection.get(source).addAll(target);
            return this;
        }
    }

    public static final class Header
    extends VersionedFlaggedTargetType {
        Header(int cpIndex, String typeName, int flag, String moduleVersion) {
            super(ConstantPool.TAG.CONSTANT_MODULE, cpIndex, typeName, flag, ClassFileContext.MODULE, moduleVersion);
        }

        public String getModuleName() {
            return this.getTypeName();
        }

        public int getModuleFlags() {
            return this.getFlags();
        }

        public String getModuleVersion() {
            return this.getVersion();
        }

        public int getModuleCPX() {
            return this.getCPIndex();
        }
    }

    public static final class Provided
    extends TargetType {
        public Provided(int cpIndex, String typeName) {
            super(ConstantPool.TAG.CONSTANT_CLASS, cpIndex, typeName);
        }

        public Provided(TargetType targetType) {
            this(targetType.getCPIndex(), targetType.getTypeName());
        }
    }

    public static class TargetType
    extends NameInfo
    implements Comparable<TargetType> {
        private final ConstantPool.TAG tag;

        public TargetType(ConstantPool.TAG tag, int cpIndex, String typeName) {
            super(cpIndex, typeName);
            this.tag = tag;
        }

        public String getTypeName() {
            return super.name();
        }

        public int getCPIndex() {
            return super.cpIndex();
        }

        public boolean isFlagged() {
            return false;
        }

        @Override
        public int hashCode() {
            return super.cpIndex() + super.name().hashCode() * 11;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof TargetType) {
                TargetType t = (TargetType)obj;
                return this.name().equals(t.getTypeName());
            }
            return false;
        }

        @Override
        public int compareTo(TargetType t) {
            return this.name().compareTo(t.getTypeName());
        }

        @Override
        public String toString() {
            return Options.contains(Options.PR.CPX) ? String.format("#%-4d /* %s */", this.getCPIndex(), this.name()) : this.name();
        }
    }

    public static final class Opened
    extends FlaggedTargetType {
        public Opened(int cpIndex, String typeName, int opensFlags) {
            super(ConstantPool.TAG.CONSTANT_PACKAGE, cpIndex, typeName, opensFlags, ClassFileContext.OPENS);
        }

        public Opened(FlaggedTargetType targetType) {
            this(targetType.getCPIndex(), targetType.getTypeName(), targetType.getFlags());
        }
    }

    public static final class Exported
    extends FlaggedTargetType {
        public Exported(int cpIndex, String typeName, int exportsFlags) {
            super(ConstantPool.TAG.CONSTANT_PACKAGE, cpIndex, typeName, exportsFlags, ClassFileContext.EXPORTS);
        }

        public Exported(FlaggedTargetType targetType) {
            this(targetType.getCPIndex(), targetType.getTypeName(), targetType.getFlags());
        }
    }

    public static final class Dependence
    extends VersionedFlaggedTargetType {
        public Dependence(int cpIndex, String moduleName, int flag, String moduleVersion) {
            super(ConstantPool.TAG.CONSTANT_MODULE, cpIndex, moduleName, flag, ClassFileContext.REQUIRES, moduleVersion);
        }

        public String getModuleVersion() {
            return this.getVersion();
        }
    }

    public static class FlaggedTargetType
    extends TargetType {
        private int flag;
        private ClassFileContext context;

        public FlaggedTargetType(ConstantPool.TAG tag, int cpIndex, String typeName, int flag, ClassFileContext context) {
            super(tag, cpIndex, typeName);
            this.flag = flag;
            this.context = context;
        }

        @Override
        public boolean isFlagged() {
            return true;
        }

        public int getFlags() {
            return this.flag;
        }

        public void setFlag(int value) {
            this.flag = value;
        }

        @Override
        public int hashCode() {
            return super.hashCode() + this.flag;
        }

        @Override
        public boolean equals(Object obj) {
            return super.equals(obj) && ((FlaggedTargetType)obj).flag == this.flag;
        }

        @Override
        public String toString() {
            return EModifier.asKeywords(this.flag, this.context) + super.toString();
        }
    }

    public static class VersionedFlaggedTargetType
    extends FlaggedTargetType {
        private String version;

        VersionedFlaggedTargetType(ConstantPool.TAG tag, int cpIndex, String typeName, int flag, ClassFileContext context, String version) {
            super(tag, cpIndex, typeName, flag, context);
            this.version = version != null && !version.isEmpty() ? version : null;
        }

        public String getVersion() {
            return this.version;
        }

        @Override
        public int hashCode() {
            int code = this.version == null ? 0 : this.version.hashCode();
            return code + super.hashCode();
        }
    }

    public static final class Uses
    extends TargetType {
        public Uses(int cpIndex, String typeName) {
            super(ConstantPool.TAG.CONSTANT_CLASS, cpIndex, typeName);
        }

        public Uses(TargetType targetType) {
            this(targetType.getCPIndex(), targetType.getTypeName());
        }
    }
}

