/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;

public class NestHostData
extends Indenter {
    ClassData cls;
    int host_class_index;

    public NestHostData(ClassData cls) {
        super(cls.toolOutput);
        this.cls = cls;
    }

    public NestHostData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != 2) {
            throw new ClassFormatError("ATT_NestHost: Invalid attribute length");
        }
        this.host_class_index = in.readUnsignedShort();
        return this;
    }

    @Override
    public void print() {
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.printIndent("%s #%d;", JasmTokens.Token.NESTHOST.parseKey(), this.host_class_index);
            } else {
                this.printIndent(this.PadRight(String.format("%s #%d;", JasmTokens.Token.NESTHOST.parseKey(), this.host_class_index), this.getCommentOffset() - 1)).println(" // " + this.cls.pool.ConstantStrValue(this.host_class_index));
            }
        } else {
            this.printIndent("%s %s;", JasmTokens.Token.NESTHOST.parseKey(), this.cls.pool.StringValue(this.host_class_index));
        }
    }
}

