/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.util.EnumSet;
import java.util.stream.Collectors;

public class Options {
    private static final EnumSet<PR> JASM = EnumSet.of(PR.LABS);
    private static final EnumSet<PR> DETAILED_OUTPUT = EnumSet.of(PR.CP, PR.PC, PR.CPX, PR.VAR);
    private static EnumSet<PR> printOptions = JASM;

    public static void set(PR val) {
        printOptions.add(val);
    }

    public static void setDetailedOutputOptions() {
        printOptions.addAll(DETAILED_OUTPUT);
        printOptions.remove((Object)PR.LABS);
    }

    public static void unsetDetailedOutputOptions() {
        printOptions.removeAll(DETAILED_OUTPUT);
        printOptions.add(PR.LABS);
    }

    public static boolean contains(PR val) {
        return printOptions.contains((Object)val);
    }

    public static boolean traceEnabled() {
        return printOptions.contains((Object)PR.TRACE);
    }

    public static String asShortString() {
        return String.format("[ %s ]", printOptions.stream().map(item -> item.name()).collect(Collectors.joining(", ")));
    }

    public static String asLongString() {
        return String.format("Prints: [ %s ]", printOptions.stream().map(item -> item.descriptor).collect(Collectors.joining(", ")));
    }

    public static enum PR {
        CP("Constant Pool"),
        LNT("Line Number table"),
        PC("Program Counter - for all instructions"),
        LABS("Labels (as identifiers)"),
        CPX("CP index along with arguments"),
        SRC("Source Line as comment"),
        HEX("Numbers as hexadecimals"),
        VAR("Local variables declarations"),
        TRACE("Print internal traces, debug information"),
        NC("No comments, suppress printing comments"),
        VERBOSE("Verbose information");

        final String descriptor;

        private PR(String descriptor) {
            this.descriptor = descriptor;
        }
    }
}

