/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.function.Function;
import org.openjdk.asmtools.asmutils.Pair;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.EAttribute;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.MemberData;

public class SignatureData
extends MemberData<ClassData> {
    private int index;

    public SignatureData(ClassData classData) {
        super(classData);
    }

    public SignatureData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        if (attribute_length != 2) {
            throw new FormatError((DecompilerLogger)this.environment.getLogger(), "err.invalid.attribute.length", EAttribute.ATT_Signature.printValue(), attribute_length);
        }
        this.index = in.readUnsignedShort();
        return this;
    }

    public String toString() {
        return String.format("signature[%d]=%s", this.getIndex(), this.pool.StringValue(this.getIndex()));
    }

    public int getIndex() {
        return this.index;
    }

    public String asString() {
        return this.pool.StringValue(this.index);
    }

    public Pair<String, String> getPrintInfo(Function<Integer, Boolean> checkRange) {
        return new Pair<String, String>(String.format(":#%d", this.index), checkRange.apply(this.index) != false ? String.format(":%s", this.pool.StringValue(this.index)) : ":?? invalid index");
    }
}

