/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.Indenter;

public class SourceDebugExtensionData
extends Indenter {
    List<String> debug_extension;

    public SourceDebugExtensionData(ClassData classData) {
        super(classData.toolOutput);
    }

    public SourceDebugExtensionData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        this.debug_extension = StringUtils.readUtf8String(in, attribute_length, 76 - this.getIndentSize());
        return this;
    }

    @Override
    public void print() {
        this.printIndentLn(JasmTokens.Token.SOURCEDEBUGEXTENSION.parseKey() + " {");
        this.incIndent();
        this.debug_extension.forEach(s -> this.printIndentLn((String)s));
        this.decIndent();
        this.printIndentLn("}");
    }
}

