/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.JasmTokens;
import org.openjdk.asmtools.jdis.ClassData;
import org.openjdk.asmtools.jdis.ConstantPool;
import org.openjdk.asmtools.jdis.Indenter;

public class SourceFileData
extends Indenter {
    private ConstantPool pool;
    private int source_cpx = 0;
    private String sourceName = null;

    public SourceFileData(ClassData classData) {
        super(classData.toolOutput);
        this.pool = classData.pool;
    }

    public SourceFileData read(DataInputStream in, int attribute_length) throws IOException, ClassFormatError {
        this.source_cpx = in.readUnsignedShort();
        return this;
    }

    @Override
    public boolean isPrintable() {
        return this.getSourceName() != null;
    }

    @Override
    public void print() {
        if (this.printCPIndex) {
            if (this.skipComments) {
                this.printIndentLn(String.format("%s #%d;", JasmTokens.Token.SOURCEFILE.parseKey(), this.source_cpx));
            } else {
                this.printIndent(this.PadRight(String.format("%s #%d;", JasmTokens.Token.SOURCEFILE.parseKey(), this.source_cpx), this.getCommentOffset() - 1)).println((String)(this.sourceName != null ? " // " + this.sourceName : ""));
            }
        } else {
            this.printIndent(this.PadRight(JasmTokens.Token.SOURCEFILE.parseKey(), 25)).println("\"" + (this.sourceName != null ? this.sourceName : "???") + "\";");
        }
    }

    public String getSourceName() {
        if (this.sourceName == null) {
            this.sourceName = this.pool.getString(this.source_cpx, index -> null);
        }
        return this.sourceName;
    }

    public SourceFileData setSourceName() {
        this.sourceName = this.pool.getString(this.source_cpx, index -> "#" + index);
        return this;
    }
}

