/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Optional;
import org.openjdk.asmtools.asmutils.StringUtils;
import org.openjdk.asmtools.common.DecompilerLogger;
import org.openjdk.asmtools.common.FormatError;
import org.openjdk.asmtools.common.structure.StackMap;
import org.openjdk.asmtools.jdis.CodeData;
import org.openjdk.asmtools.jdis.MemberData;

class StackMapData
extends MemberData<CodeData> {
    EAttributeType type;
    StackMap.FrameType stackFrameType = null;
    int stackFrameTypeValue;
    int frame_pc;
    int offset;
    int[] lockMap;
    int[] stackMap;

    public StackMapData(EAttributeType type, boolean firstStackMap, int prevFrame_pc, CodeData code, DataInputStream in) throws IOException {
        super(code);
        this.type = type;
        if (type == EAttributeType.STACKMAP) {
            this.frame_pc = in.readUnsignedShort();
            this.lockMap = this.readMap(in);
            this.stackMap = this.readMap(in);
            this.environment.traceln(" stack_map_entry:pc=%d numloc=%s  numstack=%s", this.frame_pc, StringUtils.mapToHexString(this.lockMap), StringUtils.mapToHexString(this.stackMap));
        } else {
            this.stackFrameTypeValue = in.readUnsignedByte();
            StackMap.FrameType frame_type = StackMap.stackMapFrameType(this.stackFrameTypeValue);
            switch (frame_type) {
                case SAME_FRAME: {
                    this.offset = this.stackFrameTypeValue;
                    this.environment.traceln(" same_frame=%d", this.stackFrameTypeValue);
                    break;
                }
                case SAME_FRAME_EX: {
                    this.offset = in.readUnsignedShort();
                    this.environment.traceln(" same_frame_extended=%d, offset=%d", this.stackFrameTypeValue, this.offset);
                    break;
                }
                case SAME_LOCALS_1_STACK_ITEM_FRAME: {
                    this.offset = this.stackFrameTypeValue - 64;
                    this.stackMap = this.readMapElements(in, 1);
                    this.environment.traceln(" same_locals_1_stack_item_frame=%d, offset=%d, numstack=%s", this.stackFrameTypeValue, this.offset, StringUtils.mapToHexString(this.stackMap));
                    break;
                }
                case SAME_LOCALS_1_STACK_ITEM_EXTENDED_FRAME: {
                    this.offset = in.readUnsignedShort();
                    this.stackMap = this.readMapElements(in, 1);
                    this.environment.traceln(" same_locals_1_stack_item_frame_extended=%d, offset=%d, numstack=%s", this.stackFrameTypeValue, this.offset, StringUtils.mapToHexString(this.stackMap));
                    break;
                }
                case CHOP_1_FRAME: 
                case CHOP_2_FRAME: 
                case CHOP_3_FRAME: {
                    this.offset = in.readUnsignedShort();
                    this.environment.traceln(" chop_frame=%d offset=%d", this.stackFrameTypeValue, this.offset);
                    break;
                }
                case APPEND_FRAME: {
                    this.offset = in.readUnsignedShort();
                    this.lockMap = this.readMapElements(in, this.stackFrameTypeValue - 251);
                    this.environment.traceln(" append_frame=%d offset=%d numlock=%s", this.stackFrameTypeValue, this.offset, StringUtils.mapToHexString(this.lockMap));
                    break;
                }
                case FULL_FRAME: {
                    this.offset = in.readUnsignedShort();
                    this.lockMap = this.readMap(in);
                    this.stackMap = this.readMap(in);
                    this.environment.traceln(" full_frame=%d offset=%d numloc=%s  numstack=%s", this.stackFrameTypeValue, this.offset, StringUtils.mapToHexString(this.lockMap), StringUtils.mapToHexString(this.stackMap));
                    break;
                }
                default: {
                    this.environment.traceln("incorrect frame_type argument", new Object[0]);
                }
            }
            this.stackFrameType = frame_type;
            this.frame_pc = prevFrame_pc == 0 && firstStackMap ? this.offset : prevFrame_pc + this.offset + 1;
        }
    }

    public int getFramePC() {
        return this.frame_pc;
    }

    private int[] readMap(DataInputStream in) throws IOException {
        int num = in.readUnsignedShort();
        return this.readMapElements(in, num);
    }

    private int[] readMapElements(DataInputStream in, int num) throws IOException {
        int[] map = new int[num];
        for (int k = 0; k < num; ++k) {
            int mt_val = in.readUnsignedByte();
            StackMap.VerificationType stackMapVerificationType = StackMap.getVerificationType(mt_val, Optional.of(s -> {
                throw new FormatError((DecompilerLogger)this.environment.getLogger(), (String)s, new Object[0]);
            }));
            switch (stackMapVerificationType) {
                case ITEM_Object: {
                    mt_val |= in.readUnsignedShort() << 8;
                    break;
                }
                case ITEM_NewObject: {
                    int pc = in.readUnsignedShort();
                    ((CodeData)this.data).getInstructionAttribute((int)pc).referred = true;
                    mt_val |= pc << 8;
                }
            }
            map[k] = mt_val;
        }
        return map;
    }

    static enum EAttributeType {
        STACKMAP("ImplicitStackMap"),
        STACKMAPTABLE("StackMapTable");

        private final String name;

        private EAttributeType(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }
    }
}

