/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.jdis;

import java.io.DataInputStream;
import java.io.IOException;
import org.openjdk.asmtools.jasm.TypeAnnotationTargetInfoData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypePathData;
import org.openjdk.asmtools.jasm.TypeAnnotationTypes;
import org.openjdk.asmtools.jdis.AnnotationData;
import org.openjdk.asmtools.jdis.MemberData;

public class TypeAnnotationData<T extends MemberData>
extends AnnotationData {
    private final TargetTypeVisitor targetTypeVisitor = new TargetTypeVisitor();
    private TypeAnnotationTargetInfoData targetInfo = null;
    private final TypeAnnotationTypePathData typePath = new TypeAnnotationTypePathData();

    public TypeAnnotationData(T data, boolean invisible) {
        super(data, invisible);
        this.visibleAnnotationToken = "@T+";
        this.invisibleAnnotationToken = "@T-";
        this.dataName = "TypeAnnotationData";
    }

    @Override
    public void read(DataInputStream in) throws IOException {
        int targetTypeID = in.readUnsignedByte();
        TypeAnnotationTypes.ETargetType targetType = TypeAnnotationTypes.ETargetType.getTargetType(targetTypeID);
        if (targetType == null) {
            throw new IOException("Bad target type: " + targetTypeID + " in TypeAnnotationData");
        }
        this.targetTypeVisitor.init(in);
        this.targetTypeVisitor.visitExcept(targetType);
        this.targetInfo = this.targetTypeVisitor.getTargetInfo();
        int len = in.readUnsignedByte();
        this.environment.traceln("[TypeAnnotationData.read]: Reading Location (length = " + len + ").", new Object[0]);
        this.environment.trace("[TypeAnnotationData.read]: [ ", new Object[0]);
        for (int i = 0; i < len; ++i) {
            int pathType = in.readUnsignedByte();
            String pk = TypeAnnotationTypes.getPathKind(pathType).parseKey();
            char pathArgIndex = (char)in.readUnsignedByte();
            this.typePath.addTypePathEntry(new TypeAnnotationTypes.TypePathEntry(pathType, (int)pathArgIndex));
            this.environment.trace(" " + pk + "(" + pathType + "," + pathArgIndex + "), ", new Object[0]);
        }
        this.environment.traceln("] ", new Object[0]);
        super.read(in);
    }

    @Override
    protected void printBody() throws IOException {
        if (this.isEmpty()) {
            this.print(" { { }");
        } else {
            this.println(" {");
            this.setElementState(MemberData.AnnotationElementState.INLINED_ELEMENT);
            super.printBody();
        }
        this.print(this.targetInfo.toPrintString());
        String location = this.typePath.toPrintString();
        if (!location.isBlank()) {
            this.print(location + " ");
        }
        this.print("}");
    }

    private class TargetTypeVisitor
    extends TypeAnnotationTypes.TypeAnnotationTargetVisitor {
        private TypeAnnotationTargetInfoData targetInfo = null;
        private IOException IOProb = null;
        private DataInputStream in;

        private TargetTypeVisitor() {
        }

        public void init(DataInputStream in) {
            this.in = in;
        }

        public int scanByteVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedByte();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public int scanShortVal() {
            int val = 0;
            try {
                val = this.in.readUnsignedShort();
            }
            catch (IOException e) {
                this.IOProb = e;
            }
            return val;
        }

        public void visitExcept(TypeAnnotationTypes.ETargetType targetType) throws IOException {
            this.IOProb = null;
            this.targetInfo = null;
            TypeAnnotationData.this.environment.traceln("Target Type: " + targetType.parseKey(), new Object[0]);
            this.visit(targetType);
            if (this.IOProb != null) {
                throw this.IOProb;
            }
        }

        public TypeAnnotationTargetInfoData getTargetInfo() {
            return this.targetInfo;
        }

        private boolean error() {
            return this.IOProb != null;
        }

        @Override
        public void visit_type_param_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("Type Param Target: ", new Object[0]);
            int paramIndex = this.scanByteVal();
            TypeAnnotationData.this.environment.traceln("{ param_index: " + paramIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.type_parameter_target(targetType, paramIndex);
            }
        }

        @Override
        public void visit_supertype_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("SuperType Target: ", new Object[0]);
            int typeIndex = this.scanShortVal();
            TypeAnnotationData.this.environment.traceln("{ type_index: " + typeIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.supertype_target(targetType, typeIndex);
            }
        }

        @Override
        public void visit_typeparam_bound_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("TypeParam Bound Target: ", new Object[0]);
            int paramIndex = this.scanByteVal();
            if (this.error()) {
                return;
            }
            int boundIndex = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TypeAnnotationData.this.environment.traceln("{ param_index: " + paramIndex + " bound_index: " + boundIndex + "}", new Object[0]);
            this.targetInfo = new TypeAnnotationTargetInfoData.type_parameter_bound_target(targetType, paramIndex, boundIndex);
        }

        @Override
        public void visit_empty_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.traceln("Empty Target: ", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.empty_target(targetType);
            }
        }

        @Override
        public void visit_methodformalparam_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("MethodFormalParam Target: ", new Object[0]);
            int paramIndex = this.scanByteVal();
            TypeAnnotationData.this.environment.traceln("{ param_index: " + paramIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.formal_parameter_target(targetType, paramIndex);
            }
        }

        @Override
        public void visit_throws_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("Throws Target: ", new Object[0]);
            int exceptionIndex = this.scanShortVal();
            TypeAnnotationData.this.environment.traceln("{ exception_index: " + exceptionIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.throws_target(targetType, exceptionIndex);
            }
        }

        @Override
        public void visit_localvar_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.traceln("LocalVar Target: ", new Object[0]);
            int tableLength = this.scanShortVal();
            if (this.error()) {
                return;
            }
            TypeAnnotationTargetInfoData.localvar_target locvartab = new TypeAnnotationTargetInfoData.localvar_target(targetType, tableLength);
            this.targetInfo = locvartab;
            for (int i = 0; i < tableLength; ++i) {
                int startPC = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int length = this.scanShortVal();
                if (this.error()) {
                    return;
                }
                int CPX3 = this.scanShortVal();
                TypeAnnotationData.this.environment.trace("LocalVar[" + i + "]: ", new Object[0]);
                TypeAnnotationData.this.environment.traceln("{ startPC: " + startPC + ", length: " + length + ", CPX: " + CPX3 + "}", new Object[0]);
                locvartab.addEntry(startPC, length, CPX3);
            }
        }

        @Override
        public void visit_catch_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("Catch Target: ", new Object[0]);
            int catchIndex = this.scanShortVal();
            TypeAnnotationData.this.environment.traceln("{ catch_index: " + catchIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.catch_target(targetType, catchIndex);
            }
        }

        @Override
        public void visit_offset_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("Offset Target: ", new Object[0]);
            int offsetIndex = this.scanShortVal();
            TypeAnnotationData.this.environment.traceln("{ offset_index: " + offsetIndex + "}", new Object[0]);
            if (!this.error()) {
                this.targetInfo = new TypeAnnotationTargetInfoData.offset_target(targetType, offsetIndex);
            }
        }

        @Override
        public void visit_typearg_target(TypeAnnotationTypes.ETargetType targetType) {
            TypeAnnotationData.this.environment.trace("TypeArg Target: ", new Object[0]);
            int offset = this.scanShortVal();
            if (this.error()) {
                return;
            }
            int typeIndex = this.scanByteVal();
            if (this.error()) {
                return;
            }
            TypeAnnotationData.this.environment.traceln("{ offset: " + offset + " type_index: " + typeIndex + "}", new Object[0]);
            this.targetInfo = new TypeAnnotationTargetInfoData.type_argument_target(targetType, offset, typeIndex);
        }
    }
}

