/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.util;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18NResourceBundle
extends ResourceBundle {
    private boolean warn = true;
    private String name;
    private ResourceBundle delegate;
    private ClassLoader classLoader;

    public static I18NResourceBundle getBundleForClass(Class c) {
        String cn = c.getName();
        int dot = cn.lastIndexOf(46);
        String rn = dot == -1 ? "i18n" : cn.substring(0, dot) + ".i18n";
        return new I18NResourceBundle(rn, c.getClassLoader());
    }

    private I18NResourceBundle(String name, ClassLoader cl) {
        this.name = name;
        this.classLoader = cl;
    }

    public String getString(String key, Object ... args) {
        try {
            String resourceString = this.getString(key);
            return MessageFormat.format(resourceString, args);
        }
        catch (MissingResourceException mre) {
            return null;
        }
        catch (IllegalArgumentException iae) {
            return iae.getMessage();
        }
    }

    public String getOptionalString(String key) {
        if (this.delegate == null) {
            this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
        }
        try {
            String s = (String)this.delegate.getObject(key);
            if (s != null) {
                System.out.println("i18n: " + key);
            }
            return s;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public void setWarn(boolean warn) {
        this.warn = warn;
    }

    @Override
    protected Object handleGetObject(String key) throws MissingResourceException {
        try {
            if (this.delegate == null) {
                this.delegate = ResourceBundle.getBundle(this.name, Locale.getDefault(), this.classLoader);
            }
            return this.delegate.getObject(key);
        }
        catch (MissingResourceException e) {
            if (this.warn) {
                System.err.println("WARNING: resource: '" + key + "' not found in " + this.name);
            }
            return key;
        }
    }

    public Enumeration getKeys() {
        if (this.delegate == null) {
            this.delegate = ResourceBundle.getBundle(this.name);
        }
        return this.delegate.getKeys();
    }

    public String getName() {
        return this.name;
    }
}

