/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.AfterClassTemplateInvocationCallback;
import org.junit.jupiter.api.extension.BeforeClassTemplateInvocationCallback;
import org.junit.jupiter.api.extension.ClassTemplateInvocationContext;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.parallel.ResourceLocksProvider;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.CallbackSupport;
import org.junit.jupiter.engine.descriptor.ClassTemplateInvocationExtensionContext;
import org.junit.jupiter.engine.descriptor.ClassTemplateTestDescriptor;
import org.junit.jupiter.engine.descriptor.ExclusiveResourceCollector;
import org.junit.jupiter.engine.descriptor.JupiterTestDescriptor;
import org.junit.jupiter.engine.descriptor.ResourceLockAware;
import org.junit.jupiter.engine.descriptor.TestClassAware;
import org.junit.jupiter.engine.execution.JupiterEngineExecutionContext;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.jupiter.engine.support.JupiterThrowableCollectorFactory;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

@API(status=API.Status.INTERNAL, since="5.13")
public class ClassTemplateInvocationTestDescriptor
extends JupiterTestDescriptor
implements TestClassAware,
ResourceLockAware {
    public static final String SEGMENT_TYPE = "class-template-invocation";
    private final ClassTemplateTestDescriptor parent;
    private ClassTemplateInvocationContext invocationContext;
    private final int index;

    public ClassTemplateInvocationTestDescriptor(UniqueId uniqueId, ClassTemplateTestDescriptor parent, ClassTemplateInvocationContext invocationContext, int index, TestSource source, JupiterConfiguration configuration) {
        super(uniqueId, invocationContext.getDisplayName(index), source, configuration);
        this.parent = parent;
        this.invocationContext = invocationContext;
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    @Override
    protected ClassTemplateInvocationTestDescriptor withUniqueId(UnaryOperator<UniqueId> uniqueIdTransformer) {
        return new ClassTemplateInvocationTestDescriptor((UniqueId)uniqueIdTransformer.apply(this.getUniqueId()), this.parent, this.invocationContext, this.index, this.getSource().orElse(null), this.configuration);
    }

    @Override
    public TestDescriptor.Type getType() {
        return TestDescriptor.Type.CONTAINER;
    }

    @Override
    public String getLegacyReportingName() {
        return this.getTestClass().getName() + "[" + this.index + "]";
    }

    @Override
    public Class<?> getTestClass() {
        return this.parent.getTestClass();
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return this.parent.getEnclosingTestClasses();
    }

    @Override
    public ExclusiveResourceCollector getExclusiveResourceCollector() {
        return this.parent.getExclusiveResourceCollector();
    }

    @Override
    public Function<ResourceLocksProvider, Set<ResourceLocksProvider.Lock>> getResourceLocksProviderEvaluator() {
        return this.parent.getResourceLocksProviderEvaluator();
    }

    @Override
    public JupiterEngineExecutionContext prepare(JupiterEngineExecutionContext context) {
        MutableExtensionRegistry registry = context.getExtensionRegistry();
        List<Extension> additionalExtensions = this.invocationContext.getAdditionalExtensions();
        if (!additionalExtensions.isEmpty()) {
            MutableExtensionRegistry childRegistry = MutableExtensionRegistry.createRegistryFrom(registry, Stream.empty());
            additionalExtensions.forEach(extension -> childRegistry.registerExtension((Extension)extension, this.invocationContext));
            registry = childRegistry;
        }
        ClassTemplateInvocationExtensionContext extensionContext = new ClassTemplateInvocationExtensionContext(context.getExtensionContext(), context.getExecutionListener(), this, context.getConfiguration(), (ExtensionRegistry)registry, context.getLauncherStoreFacade());
        ThrowableCollector throwableCollector = JupiterThrowableCollectorFactory.createThrowableCollector();
        throwableCollector.execute(() -> this.invocationContext.prepareInvocation(extensionContext));
        return context.extend().withExtensionRegistry(registry).withExtensionContext(extensionContext).withThrowableCollector(throwableCollector).build();
    }

    @Override
    public Node.SkipResult shouldBeSkipped(JupiterEngineExecutionContext context) {
        context.getThrowableCollector().assertEmpty();
        return Node.SkipResult.doNotSkip();
    }

    @Override
    public JupiterEngineExecutionContext before(JupiterEngineExecutionContext context) throws Exception {
        CallbackSupport.invokeBeforeCallbacks(BeforeClassTemplateInvocationCallback.class, context, BeforeClassTemplateInvocationCallback::beforeClassTemplateInvocation);
        context.getThrowableCollector().assertEmpty();
        return context;
    }

    @Override
    public JupiterEngineExecutionContext execute(JupiterEngineExecutionContext context, Node.DynamicTestExecutor dynamicTestExecutor) throws Exception {
        TestDescriptor.Visitor visitor = context.getExecutionListener()::dynamicTestRegistered;
        this.getChildren().forEach(child -> child.accept(visitor));
        return context;
    }

    @Override
    public void after(JupiterEngineExecutionContext context) throws Exception {
        ThrowableCollector throwableCollector = context.getThrowableCollector();
        Throwable previousThrowable = throwableCollector.getThrowable();
        CallbackSupport.invokeAfterCallbacks(AfterClassTemplateInvocationCallback.class, context, AfterClassTemplateInvocationCallback::afterClassTemplateInvocation);
        if (previousThrowable != throwableCollector.getThrowable()) {
            throwableCollector.assertEmpty();
        }
    }

    @Override
    public void cleanUp(JupiterEngineExecutionContext context) throws Exception {
        this.invocationContext = null;
        super.cleanUp(context);
    }
}

