/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.util.Optional;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedInvocationContextProvider;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.ParameterizedTestContext;
import org.junit.platform.commons.support.AnnotationSupport;

class ParameterizedTestExtension
extends ParameterizedInvocationContextProvider<TestTemplateInvocationContext>
implements TestTemplateInvocationContextProvider {
    static final String DECLARATION_CONTEXT_KEY = "context";

    ParameterizedTestExtension() {
    }

    @Override
    public boolean supportsTestTemplate(ExtensionContext context) {
        Optional<ParameterizedTest> annotation = AnnotationSupport.findAnnotation(context.getTestMethod(), ParameterizedTest.class);
        if (!annotation.isPresent()) {
            return false;
        }
        ParameterizedTestContext methodContext = new ParameterizedTestContext(context.getRequiredTestClass(), context.getRequiredTestMethod(), annotation.get());
        this.getStore(context).put(DECLARATION_CONTEXT_KEY, methodContext);
        return true;
    }

    @Override
    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.provideInvocationContexts(extensionContext, this.getDeclarationContext(extensionContext));
    }

    @Override
    public boolean mayReturnZeroTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        return this.getDeclarationContext(extensionContext).isAllowingZeroInvocations();
    }

    private ParameterizedTestContext getDeclarationContext(ExtensionContext extensionContext) {
        return this.getStore(extensionContext).get(DECLARATION_CONTEXT_KEY, ParameterizedTestContext.class);
    }

    private ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getStore(ExtensionContext.Namespace.create(ParameterizedTestExtension.class, context.getRequiredTestMethod()));
    }
}

