/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.converter;

import org.apiguardian.api.API;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.params.converter.ArgumentConversionException;
import org.junit.jupiter.params.converter.ArgumentConverter;
import org.junit.jupiter.params.support.FieldContext;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

@API(status=API.Status.STABLE, since="5.10")
public abstract class TypedArgumentConverter<S, T>
implements ArgumentConverter {
    private final Class<S> sourceType;
    private final Class<T> targetType;

    protected TypedArgumentConverter(Class<S> sourceType, Class<T> targetType) {
        this.sourceType = Preconditions.notNull(sourceType, "sourceType must not be null");
        this.targetType = Preconditions.notNull(targetType, "targetType must not be null");
    }

    @Override
    public final Object convert(Object source, ParameterContext context) throws ArgumentConversionException {
        return this.convert(source, context.getParameter().getType());
    }

    @Override
    public final Object convert(Object source, FieldContext context) throws ArgumentConversionException {
        return this.convert(source, context.getField().getType());
    }

    private T convert(Object source, Class<?> actualTargetType) {
        if (source == null) {
            return this.convert(null);
        }
        if (!this.sourceType.isInstance(source)) {
            String message = String.format("%s cannot convert objects of type [%s]. Only source objects of type [%s] are supported.", this.getClass().getSimpleName(), source.getClass().getName(), this.sourceType.getName());
            throw new ArgumentConversionException(message);
        }
        if (!ReflectionUtils.isAssignableTo(this.targetType, actualTargetType)) {
            String message = String.format("%s cannot convert to type [%s]. Only target type [%s] is supported.", this.getClass().getSimpleName(), actualTargetType.getName(), this.targetType.getName());
            throw new ArgumentConversionException(message);
        }
        return this.convert(this.sourceType.cast(source));
    }

    protected abstract T convert(S var1) throws ArgumentConversionException;
}

