/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params.provider;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.stream.Stream;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.ArgumentsProvider;
import org.junit.jupiter.params.support.ParameterDeclaration;
import org.junit.jupiter.params.support.ParameterDeclarations;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

class EmptyArgumentsProvider
implements ArgumentsProvider {
    EmptyArgumentsProvider() {
    }

    @Override
    public Stream<? extends Arguments> provideArguments(ParameterDeclarations parameters, ExtensionContext context) {
        Optional<Constructor<?>> defaultConstructor;
        Optional<ParameterDeclaration> firstParameter = parameters.getFirst();
        Preconditions.condition(firstParameter.isPresent(), () -> String.format("@EmptySource cannot provide an empty argument to %s: no formal parameters declared.", parameters.getSourceElementDescription()));
        Class<?> parameterType = firstParameter.get().getParameterType();
        if (String.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(""));
        }
        if (Collection.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptySet()));
        }
        if (List.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyList()));
        }
        if (Set.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptySet()));
        }
        if (SortedSet.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptySortedSet()));
        }
        if (NavigableSet.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyNavigableSet()));
        }
        if (Map.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyMap()));
        }
        if (SortedMap.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptySortedMap()));
        }
        if (NavigableMap.class.equals(parameterType)) {
            return Stream.of(Arguments.arguments(Collections.emptyNavigableMap()));
        }
        if ((Collection.class.isAssignableFrom(parameterType) || Map.class.isAssignableFrom(parameterType)) && (defaultConstructor = EmptyArgumentsProvider.getDefaultConstructor(parameterType)).isPresent()) {
            return Stream.of(Arguments.arguments(ReflectionUtils.newInstance(defaultConstructor.get(), new Object[0])));
        }
        if (parameterType.isArray()) {
            Object array = Array.newInstance(parameterType.getComponentType(), 0);
            return Stream.of(Arguments.arguments(array));
        }
        throw new PreconditionViolationException(String.format("@EmptySource cannot provide an empty argument to %s: [%s] is not a supported type.", parameters.getSourceElementDescription(), parameterType.getName()));
    }

    private static Optional<Constructor<?>> getDefaultConstructor(Class<?> clazz) {
        try {
            return Optional.of(clazz.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.empty();
        }
    }
}

