/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.DiscoverySelectorIdentifier;
import org.junit.platform.engine.discovery.DiscoverySelectorIdentifierParser;
import org.junit.platform.engine.discovery.DiscoverySelectors;

@API(status=API.Status.STABLE, since="1.0")
public class MethodSelector
implements DiscoverySelector {
    private final ClassLoader classLoader;
    private final String className;
    private final String methodName;
    private final String parameterTypeNames;
    private volatile Class<?> javaClass;
    private volatile Method javaMethod;
    private volatile Class<?>[] parameterTypes;

    MethodSelector(ClassLoader classLoader, String className, String methodName, String parameterTypeNames) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
    }

    MethodSelector(Class<?> javaClass, String methodName, String parameterTypeNames) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.parameterTypeNames = parameterTypeNames;
    }

    MethodSelector(ClassLoader classLoader, String className, String methodName, Class<?> ... parameterTypes) {
        this.classLoader = classLoader;
        this.className = className;
        this.methodName = methodName;
        this.parameterTypes = (Class[])parameterTypes.clone();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, this.parameterTypes);
    }

    MethodSelector(Class<?> javaClass, String methodName, Class<?> ... parameterTypes) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.methodName = methodName;
        this.parameterTypes = (Class[])parameterTypes.clone();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, this.parameterTypes);
    }

    MethodSelector(Class<?> javaClass, Method method) {
        this.classLoader = javaClass.getClassLoader();
        this.javaClass = javaClass;
        this.className = javaClass.getName();
        this.javaMethod = method;
        this.methodName = method.getName();
        this.parameterTypes = method.getParameterTypes();
        this.parameterTypeNames = ClassUtils.nullSafeToString(Class::getTypeName, this.parameterTypes);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    @Deprecated
    @API(status=API.Status.DEPRECATED, since="1.10")
    public String getMethodParameterTypes() {
        return this.getParameterTypeNames();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public String getParameterTypeNames() {
        return this.parameterTypeNames;
    }

    public Class<?> getJavaClass() {
        this.lazyLoadJavaClass();
        return this.javaClass;
    }

    public Method getJavaMethod() {
        this.lazyLoadJavaMethod();
        return this.javaMethod;
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public Class<?>[] getParameterTypes() {
        this.lazyLoadParameterTypes();
        return (Class[])this.parameterTypes.clone();
    }

    private void lazyLoadJavaClass() {
        if (this.javaClass == null) {
            Try<Class<?>> tryToLoadClass = this.classLoader == null ? ReflectionSupport.tryToLoadClass(this.className) : ReflectionSupport.tryToLoadClass(this.className, this.classLoader);
            this.javaClass = tryToLoadClass.getOrThrow(cause -> new PreconditionViolationException("Could not load class with name: " + this.className, (Throwable)cause));
        }
    }

    private void lazyLoadJavaMethod() {
        if (this.javaMethod == null) {
            this.lazyLoadJavaClass();
            this.lazyLoadParameterTypes();
            this.javaMethod = this.parameterTypes.length > 0 ? ReflectionSupport.findMethod(this.javaClass, this.methodName, this.parameterTypes).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] and parameter types [%s] in class [%s].", this.methodName, this.parameterTypeNames, this.javaClass.getName()))) : ReflectionSupport.findMethod(this.javaClass, this.methodName, new Class[0]).orElseThrow(() -> new PreconditionViolationException(String.format("Could not find method with name [%s] in class [%s].", this.methodName, this.javaClass.getName())));
        }
    }

    private void lazyLoadParameterTypes() {
        if (this.parameterTypes == null) {
            this.lazyLoadJavaClass();
            this.parameterTypes = ReflectionUtils.resolveParameterTypes(this.javaClass, this.methodName, this.parameterTypeNames);
        }
    }

    @API(status=API.Status.STABLE, since="1.3")
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodSelector that = (MethodSelector)o;
        return Objects.equals(this.className, that.className) && Objects.equals(this.methodName, that.methodName) && Objects.equals(this.parameterTypeNames, that.parameterTypeNames);
    }

    @API(status=API.Status.STABLE, since="1.3")
    public int hashCode() {
        return Objects.hash(this.className, this.methodName, this.parameterTypeNames);
    }

    public String toString() {
        return new ToStringBuilder(this).append("className", this.getClassName()).append("methodName", this.getMethodName()).append("parameterTypes", this.getParameterTypeNames()).append("classLoader", this.getClassLoader()).toString();
    }

    @Override
    public Optional<DiscoverySelectorIdentifier> toIdentifier() {
        String fullyQualifiedMethodName = ReflectionUtils.getFullyQualifiedMethodName(this.className, this.methodName, this.parameterTypeNames);
        return Optional.of(DiscoverySelectorIdentifier.create("method", fullyQualifiedMethodName));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static class IdentifierParser
    implements DiscoverySelectorIdentifierParser {
        private static final String PREFIX = "method";

        @Override
        public String getPrefix() {
            return PREFIX;
        }

        public Optional<MethodSelector> parse(DiscoverySelectorIdentifier identifier, DiscoverySelectorIdentifierParser.Context context) {
            return Optional.of(DiscoverySelectors.selectMethod(identifier.getValue()));
        }
    }
}

