/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.listeners;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.listeners.OutputDir;

@API(status=API.Status.STABLE, since="1.11")
public class UniqueIdTrackingListener
implements TestExecutionListener {
    public static final String LISTENER_ENABLED_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.enabled";
    public static final String OUTPUT_DIR_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.dir";
    public static final String OUTPUT_FILE_PREFIX_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.output.file.prefix";
    public static final String DEFAULT_OUTPUT_FILE_PREFIX = "junit-platform-unique-ids";
    static final String WORKING_DIR_PROPERTY_NAME = "junit.platform.listeners.uid.tracking.working.dir";
    private final Logger logger = LoggerFactory.getLogger(UniqueIdTrackingListener.class);
    private final List<String> uniqueIds = new ArrayList<String>();
    private boolean enabled;
    private TestPlan testPlan;

    @Override
    public void testPlanExecutionStarted(TestPlan testPlan) {
        this.enabled = testPlan.getConfigurationParameters().getBoolean(LISTENER_ENABLED_PROPERTY_NAME).orElse(false);
        this.testPlan = testPlan;
    }

    @Override
    public void executionSkipped(TestIdentifier testIdentifier, String reason) {
        if (this.enabled) {
            this.trackTestUidRecursively(testIdentifier);
        }
    }

    @Override
    public void executionFinished(TestIdentifier testIdentifier, TestExecutionResult testExecutionResult) {
        if (this.enabled) {
            this.trackTestUid(testIdentifier);
        }
    }

    private void trackTestUidRecursively(TestIdentifier testIdentifier) {
        boolean tracked = this.trackTestUid(testIdentifier);
        if (!tracked) {
            this.testPlan.getChildren(testIdentifier).forEach(this::trackTestUidRecursively);
        }
    }

    private boolean trackTestUid(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            this.uniqueIds.add(testIdentifier.getUniqueId());
            return true;
        }
        return false;
    }

    @Override
    public void testPlanExecutionFinished(TestPlan testPlan) {
        if (this.enabled) {
            Path outputFile;
            try {
                outputFile = this.createOutputFile(testPlan.getConfigurationParameters());
            }
            catch (Exception ex) {
                this.logger.error(ex, () -> "Failed to create output file");
                return;
            }
            this.logger.debug(() -> "Writing unique IDs to output file " + outputFile.toAbsolutePath());
            try (PrintWriter writer = new PrintWriter(Files.newBufferedWriter(outputFile, StandardCharsets.UTF_8, new OpenOption[0]));){
                this.uniqueIds.forEach(writer::println);
                writer.flush();
            }
            catch (IOException ex) {
                this.logger.error(ex, () -> "Failed to write unique IDs to output file " + outputFile.toAbsolutePath());
            }
        }
        this.testPlan = null;
    }

    private Path createOutputFile(ConfigurationParameters configurationParameters) {
        String prefix = configurationParameters.get(OUTPUT_FILE_PREFIX_PROPERTY_NAME).orElse(DEFAULT_OUTPUT_FILE_PREFIX);
        Supplier<Path> workingDirSupplier = () -> configurationParameters.get(WORKING_DIR_PROPERTY_NAME).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> Paths.get(".", new String[0]));
        return OutputDir.create(configurationParameters.get(OUTPUT_DIR_PROPERTY_NAME), workingDirSupplier).createFile(prefix, "txt");
    }
}

