/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.java;

import org.apiguardian.api.API;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.ChildElement;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.api.Context;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.events.core.Sources;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.Namespace;
import org.junit.platform.reporting.shadow.org.opentest4j.reporting.schema.QualifiedName;

@API(status=API.Status.EXPERIMENTAL, since="0.1.0")
public class MethodSource
extends ChildElement<Sources, MethodSource> {
    private static final QualifiedName ELEMENT = QualifiedName.of(Namespace.REPORTING_JAVA, "methodSource");
    private static final QualifiedName CLASS_NAME = QualifiedName.of(Namespace.REPORTING_JAVA, "className");
    private static final QualifiedName METHOD_NAME = QualifiedName.of(Namespace.REPORTING_JAVA, "methodName");
    private static final QualifiedName METHOD_PARAMETER_TYPES = QualifiedName.of(Namespace.REPORTING_JAVA, "methodParameterTypes");

    MethodSource(Context context) {
        super(context, ELEMENT);
    }

    MethodSource withClassName(String className) {
        this.withAttribute(CLASS_NAME, className);
        return this;
    }

    MethodSource withMethodName(String methodName) {
        this.withAttribute(METHOD_NAME, methodName);
        return this;
    }

    public MethodSource withMethodParameterTypes(String methodParameterTypes) {
        this.withAttribute(METHOD_PARAMETER_TYPES, methodParameterTypes);
        return this;
    }
}

