/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j.reporting.tooling.spi.htmlreport;

import java.util.ArrayList;
import java.util.Objects;
import org.opentest4j.reporting.tooling.spi.htmlreport.PreFormattedOutput;

final class ImmutablePreFormattedOutput
implements PreFormattedOutput {
    private final String content;

    private ImmutablePreFormattedOutput(String content) {
        this.content = content;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public final ImmutablePreFormattedOutput withContent(String value) {
        String newValue = Objects.requireNonNull(value, "content");
        if (this.content.equals(newValue)) {
            return this;
        }
        return new ImmutablePreFormattedOutput(newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePreFormattedOutput && this.equalTo(0, (ImmutablePreFormattedOutput)another);
    }

    private boolean equalTo(int synthetic, ImmutablePreFormattedOutput another) {
        return this.content.equals(another.content);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content.hashCode();
        return h;
    }

    public String toString() {
        return "PreFormattedOutput{content=" + this.content + "}";
    }

    public static PreFormattedOutput copyOf(PreFormattedOutput instance) {
        if (instance instanceof ImmutablePreFormattedOutput) {
            return (ImmutablePreFormattedOutput)instance;
        }
        return new PreFormattedOutput.Builder().content((String)instance.getContent()).build();
    }

    public static class Builder {
        private static final long INIT_BIT_CONTENT = 1L;
        private long initBits = 1L;
        private String content;

        public Builder() {
            if (!(this instanceof PreFormattedOutput.Builder)) {
                throw new UnsupportedOperationException("Use: new PreFormattedOutput.Builder()");
            }
        }

        public final PreFormattedOutput.Builder content(String content) {
            this.content = Objects.requireNonNull(content, "content");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return (PreFormattedOutput.Builder)this;
        }

        public PreFormattedOutput build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePreFormattedOutput(this.content);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("content");
            }
            return "Cannot build PreFormattedOutput, some of required attributes are not set " + attributes;
        }
    }
}

