/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.net.URL;

public class HTMLWriter {
    public static final String A = "a";
    public static final String ALIGN = "align";
    public static final String B = "b";
    public static final String BODY = "body";
    public static final String BORDER = "border";
    public static final String BR = "br";
    public static final String CLASSID = "classid";
    public static final String CODE = "code";
    public static final String COLOR = "color";
    public static final String COL = "col";
    public static final String FONT = "font";
    public static final String H1 = "h1";
    public static final String H2 = "h2";
    public static final String H3 = "h3";
    public static final String H4 = "h4";
    public static final String HEAD = "head";
    public static final String HREF = "href";
    public static final String HTML = "html";
    public static final String HR = "hr";
    public static final String I = "i";
    public static final String IMAGE = "image";
    public static final String LEFT = "left";
    public static final String LI = "li";
    public static final String LINK = "link";
    public static final String NAME = "name";
    public static final String OBJECT = "object";
    public static final String PARAM = "param";
    public static final String P = "p";
    public static final String REL = "rel";
    public static final String RIGHT = "right";
    public static final String ROW = "row";
    public static final String SMALL = "small";
    public static final String SRC = "src";
    public static final String SCOPE = "scope";
    public static final String STYLE = "style";
    public static final String TABLE = "table";
    public static final String TD = "td";
    public static final String TITLE = "title";
    public static final String TH = "th";
    public static final String TOP = "top";
    public static final String TR = "tr";
    public static final String TYPE = "type";
    public static final String UL = "ul";
    public static final String VALIGN = "valign";
    public static final String VALUE = "value";
    private BufferedWriter out;
    private int state;
    private I18NResourceBundle i18n;
    private static final int IN_TAG = 1;
    private static final int IN_BODY = 2;

    public HTMLWriter(Writer writer) throws IOException {
        this(writer, "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">");
    }

    public HTMLWriter(Writer writer, String string) throws IOException {
        this.out = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer);
        this.out.write(string);
        this.out.newLine();
    }

    public HTMLWriter(Writer writer, I18NResourceBundle i18NResourceBundle) throws IOException {
        this(writer);
        this.i18n = i18NResourceBundle;
    }

    public HTMLWriter(Writer writer, String string, I18NResourceBundle i18NResourceBundle) throws IOException {
        this(writer, string);
        this.i18n = i18NResourceBundle;
    }

    public void setI18NResourceBundle(I18NResourceBundle i18NResourceBundle) {
        this.i18n = i18NResourceBundle;
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public void newLine() throws IOException {
        this.out.newLine();
    }

    public void startTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.newLine();
        this.out.write("<");
        this.out.write(string);
        this.state = 1;
    }

    public void endTag(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
            this.out.newLine();
        }
        this.out.write("</");
        this.out.write(string);
        this.out.write(">");
        this.state = 2;
    }

    public void endEmptyTag(String string) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(">");
        this.state = 2;
        this.out.newLine();
    }

    public void writeAttr(String string, String string2) throws IOException {
        if (this.state != 1) {
            throw new IllegalStateException();
        }
        this.out.write(" ");
        this.out.write(string);
        this.out.write("=");
        boolean bl = true;
        for (int i = 0; i < string2.length() && bl; ++i) {
            bl = Character.isLetter(string2.charAt(i));
        }
        if (!bl) {
            this.out.write("\"");
        }
        this.out.write(string2);
        if (!bl) {
            this.out.write("\"");
        }
    }

    public void writeAttr(String string, int n) throws IOException {
        this.writeAttr(string, Integer.toString(n));
    }

    public void writeLine(String string) throws IOException {
        this.write(string);
        this.out.newLine();
    }

    public void write(String string) throws IOException {
        int n;
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        if (string == null) {
            return;
        }
        boolean bl = false;
        for (n = 0; n < string.length() && !bl; ++n) {
            switch (string.charAt(n)) {
                case '&': 
                case '<': 
                case '>': {
                    bl = true;
                }
            }
        }
        if (bl) {
            block9: for (n = 0; n < string.length(); ++n) {
                char c = string.charAt(n);
                switch (c) {
                    case '<': {
                        this.out.write("&lt;");
                        continue block9;
                    }
                    case '>': {
                        this.out.write("&gt;");
                        continue block9;
                    }
                    case '&': {
                        this.out.write("&amp;");
                        continue block9;
                    }
                    default: {
                        this.out.write(c);
                    }
                }
            }
        } else {
            this.out.write(string);
        }
    }

    public void writeEntity(String string) throws IOException {
        if (this.state == 1) {
            this.out.write(">");
            this.state = 2;
        }
        this.out.write(string);
    }

    public void writeImage(String string) throws IOException {
        this.startTag(IMAGE);
        this.writeAttr(SRC, string);
    }

    public void writeImage(URL uRL) throws IOException {
        this.writeImage(uRL.toString());
    }

    public void writeLink(String string, String string2) throws IOException {
        this.startTag(A);
        this.writeAttr(HREF, string);
        this.write(string2);
        this.endTag(A);
    }

    public void writeLink(File file, String string) throws IOException {
        this.startTag(A);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = file.getPath().replace(File.separatorChar, '/');
        if (file.isAbsolute() && !string2.startsWith("/")) {
            stringBuilder.append('/');
        }
        stringBuilder.append(string2);
        this.writeAttr(HREF, stringBuilder.toString());
        this.write(string);
        this.endTag(A);
    }

    public void writeLink(File file) throws IOException {
        this.writeLink(file, file.getPath());
    }

    public void writeLink(URL uRL, String string) throws IOException {
        this.startTag(A);
        this.writeAttr(HREF, uRL.toString());
        this.write(string);
        this.endTag(A);
    }

    public void writeLinkDestination(String string, String string2) throws IOException {
        this.startTag(A);
        this.writeAttr(NAME, string);
        this.write(string2);
        this.endTag(A);
    }

    public void writeParam(String string, String string2) throws IOException {
        this.startTag(PARAM);
        this.writeAttr(NAME, string);
        this.writeAttr(VALUE, string2);
    }

    public void writeStyleAttr(String string) throws IOException {
        this.writeAttr(STYLE, string);
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string) throws IOException {
        this.write(i18NResourceBundle.getString(string));
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string, Object object) throws IOException {
        this.write(i18NResourceBundle.getString(string, object));
    }

    public void write(I18NResourceBundle i18NResourceBundle, String string, Object[] objectArray) throws IOException {
        this.write(i18NResourceBundle.getString(string, objectArray));
    }

    public void writeI18N(String string) throws IOException {
        this.write(this.i18n.getString(string));
    }

    public void writeI18N(String string, Object object) throws IOException {
        this.write(this.i18n.getString(string, object));
    }

    public void writeI18N(String string, Object[] objectArray) throws IOException {
        this.write(this.i18n.getString(string, objectArray));
    }
}

