/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.diff;

import com.sun.javatest.TestResult;
import com.sun.javatest.TestResultTable;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.diff.DiffReader;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Properties;

public class WorkDirectoryReader
implements DiffReader {
    private final File file;
    private final WorkDirectory wd;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(WorkDirectoryReader.class);

    public static boolean accepts(File file) {
        return WorkDirectory.isWorkDirectory(file);
    }

    public WorkDirectoryReader(File file) throws FileNotFoundException, WorkDirectory.Fault, TestSuite.Fault {
        this.file = file;
        File file2 = WorkDirectoryReader.getTestSuitePath(file);
        if (file2 != null && new File(file2, "TEST.ROOT").exists()) {
            RegressionTestSuite regressionTestSuite = new RegressionTestSuite(file2, this::error);
            this.wd = WorkDirectory.open(file, regressionTestSuite);
        } else {
            this.wd = WorkDirectory.open(file);
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public String getFileType() {
        return i18n.getString("wd.name");
    }

    @Override
    public File getWorkDirectory() {
        return this.wd.getRoot();
    }

    @Override
    public Iterator<TestResult> iterator() {
        TestResultTable testResultTable = this.wd.getTestResultTable();
        testResultTable.waitUntilReady();
        return testResultTable.getIterator();
    }

    private static File getTestSuitePath(File file) {
        File file2 = new File(new File(file, "jtData"), "testsuite");
        if (!file2.exists()) {
            return null;
        }
        InputStream inputStream = null;
        try {
            inputStream = new BufferedInputStream(new FileInputStream(file2));
            Properties properties = new Properties();
            properties.load(inputStream);
            inputStream.close();
            String string = properties.getProperty("root");
            return string == null ? null : new File(string);
        }
        catch (IOException iOException) {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return null;
        }
    }

    private void error(String string) {
        System.err.println("Error: " + string);
    }
}

