/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest;

import com.sun.javatest.finder.CommentStream;
import com.sun.javatest.finder.HTMLCommentStream;
import com.sun.javatest.finder.JavaCommentStream;
import com.sun.javatest.finder.ShScriptCommentStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;

public class CheckFiles {
    private int count;
    private int lineLength = 80;
    private static final int HTML = 0;
    private static final int JAVA = 1;
    private static final int SH = 2;
    private static final int OTHER = 3;
    private static final Set<String> excludes = Set.of(".hg", ".git");

    public static void main(String[] args) {
        new CheckFiles().run(args);
    }

    public void run(String[] args) {
        int i;
        for (i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (!arg.equals("-l") || i + 1 >= args.length) {
                if (!arg.startsWith("-")) break;
                System.err.println("bad arg: " + arg);
                return;
            }
            this.lineLength = Integer.parseInt(args[++i]);
        }
        this.count = 0;
        for (i = 0; i < args.length; ++i) {
            File dir = new File(args[i]);
            this.scan(dir);
        }
        System.err.println(this.count + " suspect comments found");
    }

    public void scan(File ... files) {
        for (File file : files) {
            this.scan(file);
        }
    }

    private void scan(File file) {
        if (file.isDirectory()) {
            if (!excludes.contains(file.getName())) {
                this.scan(file.listFiles());
            }
        } else {
            switch (CheckFiles.getExtension(file)) {
                case 1: {
                    this.check(file, new JavaCommentStream());
                    break;
                }
                case 0: {
                    this.check(file, new HTMLCommentStream());
                    break;
                }
                case 2: {
                    this.check(file, new ShScriptCommentStream());
                }
            }
        }
    }

    private void check(File f, CommentStream cs) {
        try (BufferedReader r = new BufferedReader(new FileReader(f));){
            String comment;
            cs.init(r);
            while ((comment = cs.readComment()) != null) {
                this.check(f, comment);
            }
        }
        catch (IOException e) {
            System.err.println("error for " + f + ": " + e);
        }
    }

    private void check(File f, String comment) {
        comment = comment.replace('\r', ' ');
        if ((comment = comment.replace('\n', ' ')).contains("@test")) {
            return;
        }
        if (comment.matches(".*@(run|main|compile|summary|bug).*")) {
            System.out.println(f + ": " + comment.substring(0, Math.min(this.lineLength, comment.length())));
            ++this.count;
        }
    }

    static int getExtension(File f) {
        String e;
        String name = f.getName();
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return 3;
        }
        switch (e = name.toLowerCase().substring(dot + 1)) {
            case "java": {
                return 1;
            }
            case "html": {
                return 0;
            }
            case "sh": {
                return 2;
            }
        }
        return 3;
    }
}

