/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.AppletPanel;
import com.sun.javatest.regtest.agent.AppletWaiter;
import com.sun.javatest.regtest.agent.CheckboxPanel;
import com.sun.javatest.regtest.agent.StringArray;
import java.applet.Applet;
import java.applet.AppletContext;
import java.applet.AppletStub;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextArea;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class AppletWrapper {
    private static AStatus status = AStatus.passed("");
    private static AppletWaiter waiter;
    private static AppletPanel appletPanel;
    private static String className;
    private static String sourceDir;
    private static String classDir;
    private static String classpath;
    private static String manual;
    private static String body;
    private static Map<String, String> appletParams;
    private static Map<String, String> appletAtts;

    public static void main(String[] args) {
        try {
            int howMany;
            FileReader in = new FileReader(args[0]);
            StringWriter out = new StringWriter();
            char[] buf = new char[1024];
            while ((howMany = in.read(buf)) > 0) {
                out.write(buf, 0, howMany);
            }
            out.close();
            in.close();
            String[] appArgs = StringArray.splitTerminator("\u0000", out.toString());
            int i = 0;
            className = appArgs[i++];
            sourceDir = appArgs[i++];
            classDir = appArgs[i++];
            classpath = appArgs[i++];
            manual = appArgs[i++];
            body = appArgs[i++];
            appletParams = AppletWrapper.stringToMap(appArgs[i++]);
            appletAtts = AppletWrapper.stringToMap(appArgs[i++]);
        }
        catch (IOException e) {
            status = AStatus.failed("JavaTest Error:  Can't read applet args file.");
            status.exit();
        }
        AppletThreadGroup tg = new AppletThreadGroup();
        Thread t = new Thread(tg, new AppletRunnable(), "AppletThread");
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            status = AStatus.failed("Thread interrupted: " + t);
            status.exit();
        }
    }

    private static Map<String, String> stringToMap(String s) {
        String[] pairs = StringArray.splitTerminator("\u001c", s);
        HashMap<String, String> retVal = new HashMap<String, String>(3);
        for (int i = 0; i < pairs.length; i += 2) {
            retVal.put(pairs[i], pairs[i + 1]);
        }
        return retVal;
    }

    static class AppletThreadGroup
    extends ThreadGroup {
        AppletThreadGroup() {
            super("AppletThreadGroup");
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            if (e instanceof ThreadDeath) {
                return;
            }
            e.printStackTrace();
            status = AStatus.failed("Applet thread threw exception: " + e);
            status.exit();
        }
    }

    static class AppletRunnable
    implements Runnable {
        AppletRunnable() {
        }

        @Override
        public void run() {
            waiter = new AppletWaiter();
            int width = Integer.parseInt((String)appletAtts.get("width"));
            int height = Integer.parseInt((String)appletAtts.get("height"));
            AppletFrame app = new AppletFrame(className, body, manual, width, height);
            Applet applet = app.getApplet();
            AppletStubImpl stub = new AppletStubImpl();
            applet.setStub(stub);
            app.pack();
            Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
            Dimension fSize = app.getSize();
            app.setLocation(screenSize.width / 2 - fSize.width / 2, screenSize.height / 2 - fSize.height / 2);
            app.setVisible(true);
            applet.init();
            this.validate(applet);
            stub.isActive = true;
            applet.start();
            app.setVisible(true);
            this.validate(app);
            if (manual.equals("novalue") || manual.equals("unset")) {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException e) {
                    status = AStatus.failed("Thread interrupted: " + e);
                    status.exit();
                }
                applet.paint(app.getApplet().getGraphics());
            } else {
                waiter.waitForDone();
            }
            stub.isActive = false;
            applet.stop();
            applet.destroy();
            app.dispose();
            status.exit();
        }

        private void validate(Component c) {
            try {
                Class<EventQueue> eventQueueClass = EventQueue.class;
                Method isDispatchThread = eventQueueClass.getMethod("isDispatchThread", new Class[0]);
                Method invokeAndWait = eventQueueClass.getMethod("invokeAndWait", Runnable.class);
                if (!((Boolean)isDispatchThread.invoke(null, new Object[0])).booleanValue()) {
                    Object[] objectArray = new Object[1];
                    objectArray[0] = c::validate;
                    invokeAndWait.invoke(null, objectArray);
                    return;
                }
            }
            catch (NoSuchMethodException eventQueueClass) {
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            c.validate();
        }
    }

    static class AppletFrame
    extends Frame
    implements ActionListener {
        private static final long serialVersionUID = 1L;
        private Applet applet;

        public AppletFrame(String className, String text, String manual, int width, int height) {
            super(className);
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = 17;
            c.gridx = 0;
            c.gridy = 0;
            c.gridwidth = 2;
            c.weightx = 0.0;
            this.makeLabel("running applet:", gridbag, c);
            c = new GridBagConstraints();
            c.insets = new Insets(3, 3, 3, 3);
            c.gridx = 0;
            c.gridy = 1;
            c.gridwidth = 2;
            c.fill = 1;
            c.weightx = 1.0;
            c.weighty = 1.0;
            this.makeApplet(className, gridbag, c, width, height);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent event) {
                    this.dispose();
                    status = AStatus.failed("Test canceled at user request");
                    status.exit();
                }
            });
            if (!manual.equals("novalue") && !manual.equals("unset")) {
                c = new GridBagConstraints();
                c.insets = new Insets(-3, -3, -3, -3);
                c.gridx = 0;
                c.gridy = 2;
                c.gridwidth = 1;
                c.weightx = 0.0;
                c.anchor = 17;
                String[] boxNames = new String[]{"fixed", "variable"};
                this.makeCheckboxPanel(boxNames, gridbag, c);
                c = new GridBagConstraints();
                c.anchor = 17;
                c.gridx = 0;
                c.gridy = 3;
                c.gridwidth = 2;
                this.makeLabel("html file instructions:", gridbag, c);
                c = new GridBagConstraints();
                c.insets = new Insets(3, 3, 3, 3);
                c.fill = 2;
                c.gridx = 0;
                c.gridy = 4;
                c.gridwidth = 2;
                this.makeTextArea(text, gridbag, c);
                c = new GridBagConstraints();
                c.insets = new Insets(3, 3, 3, 3);
                c.gridx = 0;
                c.gridy = 5;
                if (manual.equals("yesno")) {
                    c.gridwidth = 1;
                    this.makeButton("Pass", gridbag, c);
                    c.gridx = 1;
                    this.makeButton("Fail", gridbag, c);
                } else {
                    c.gridwidth = 2;
                    this.makeButton("Done", gridbag, c);
                }
            }
            this.validate();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand().equals("Done")) {
                status = AStatus.passed("");
            } else if (e.getActionCommand().equals("Pass")) {
                status = AStatus.passed("");
            } else if (e.getActionCommand().equals("Fail")) {
                status = AStatus.failed("");
            } else {
                status = AStatus.failed("Unexpected result");
            }
            waiter.done();
        }

        public Applet getApplet() {
            return this.applet;
        }

        private void makeApplet(String className, GridBagLayout gridbag, GridBagConstraints c, int width, int height) {
            try {
                Class<?> cls = Class.forName(className);
                this.applet = (Applet)cls.newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
                status = AStatus.error("Unable to instantiate: " + className + " does not extend Applet");
                status.exit();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                status = AStatus.error("Illegal access to test: " + className);
                status.exit();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                status = AStatus.error(e.getMessage());
                status.exit();
            }
            appletPanel = new AppletPanel(this.applet, width, height);
            gridbag.setConstraints(appletPanel, c);
            this.add((Component)appletPanel, c);
        }

        private void makeButton(String name, GridBagLayout gridbag, GridBagConstraints c) {
            Button button = new Button(name);
            gridbag.setConstraints(button, c);
            this.add(button);
            button.addActionListener(this);
        }

        private void makeLabel(String name, GridBagLayout gridbag, GridBagConstraints c) {
            Label label = new Label(name);
            label.setFont(new Font("Dialog", 1, 12));
            gridbag.setConstraints(label, c);
            this.add(label);
        }

        private void makeTextArea(String name, GridBagLayout gridbag, GridBagConstraints c) {
            TextArea textArea = new TextArea(name, 16, 80);
            gridbag.setConstraints(textArea, c);
            textArea.setEditable(false);
            this.add(textArea);
        }

        private void makeCheckboxPanel(String[] name, GridBagLayout gridbag, GridBagConstraints c) {
            CheckboxPanel p = new CheckboxPanel(appletPanel, name);
            gridbag.setConstraints(p, c);
            this.add(p);
        }
    }

    static class AppletStubImpl
    implements AppletStub {
        boolean isActive;

        AppletStubImpl() {
        }

        @Override
        public boolean isActive() {
            return this.isActive;
        }

        @Override
        public URL getDocumentBase() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public URL getCodeBase() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public String getParameter(String name) {
            return (String)appletParams.get(name);
        }

        @Override
        public AppletContext getAppletContext() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void appletResize(int width, int height) {
        }
    }
}

