/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AgentVerbose;
import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.Utils;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.junit.jupiter.api.extension.AnnotatedElementContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.io.CleanupMode;
import org.junit.jupiter.api.io.TempDirFactory;
import org.junit.platform.engine.DiscoverySelector;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.UniqueId;
import org.junit.platform.engine.discovery.ClassSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.reporting.ReportEntry;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.junit.platform.launcher.listeners.SummaryGeneratingListener;
import org.junit.platform.launcher.listeners.TestExecutionSummary;

public class JUnitRunner
implements MainActionHelper.TestRunner {
    private static final String JUNIT_NO_DRIVER = "No JUnit driver -- install JUnit JAR file(s) next to jtreg.jar";
    private static final String JUNIT_SELECT_PREFIX = "junit-select:";

    public static void main(String ... args) throws Exception {
        JUnitRunner.main(null, args);
    }

    public static void main(ClassLoader loader, String ... args) throws Exception {
        ClassLoader cl;
        String className;
        if (args.length != 2) {
            throw new Error("wrong number of arguments");
        }
        String moduleClassName = args[1];
        int sep = moduleClassName.indexOf(47);
        String moduleName = sep == -1 ? null : moduleClassName.substring(0, sep);
        String string = className = sep == -1 ? moduleClassName : moduleClassName.substring(sep + 1);
        if (moduleName != null) {
            Class<?> layerClass;
            try {
                layerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                layerClass = Class.forName("java.lang.reflect.Layer");
            }
            Method bootMethod = layerClass.getMethod("boot", new Class[0]);
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            Method findLoaderMth = layerClass.getMethod("findLoader", String.class);
            cl = (ClassLoader)findLoaderMth.invoke(bootLayer, moduleName);
        } else {
            cl = loader != null ? loader : JUnitRunner.class.getClassLoader();
        }
        Class<?> mainClass = Class.forName(className, false, cl);
        JUnitRunner.runWithJUnitPlatform(mainClass);
    }

    private static void runWithJUnitPlatform(Class<?> mainClass) throws Exception {
        Thread.currentThread().setContextClassLoader(mainClass.getClassLoader());
        try {
            ClassSelector selector;
            String testQueryStr = System.getProperty("test.query");
            if (testQueryStr != null && !testQueryStr.isEmpty()) {
                if (testQueryStr.startsWith(JUNIT_SELECT_PREFIX)) {
                    String selectorStr = testQueryStr.substring(JUNIT_SELECT_PREFIX.length());
                    selector = (DiscoverySelector)DiscoverySelectors.parse((String)selectorStr).orElseThrow(() -> new IllegalArgumentException("Selector can not be parsed: " + selectorStr));
                } else {
                    selector = DiscoverySelectors.selectMethod(mainClass, (String)testQueryStr);
                }
            } else {
                selector = DiscoverySelectors.selectClass(mainClass);
            }
            LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().selectors(new DiscoverySelector[]{selector}).configurationParameter("junit.jupiter.tempdir.cleanup.mode.default", CleanupMode.NEVER.name()).configurationParameter("junit.jupiter.tempdir.factory.default", ScratchAsTemporaryDirectory.class.getName()).build();
            SummaryGeneratingListener summaryGeneratingListener = new SummaryGeneratingListener();
            AgentVerbose verbose = AgentVerbose.ofStringRepresentation(System.getProperty("test.verbose"));
            Logger.getLogger("org.junit").setLevel(Level.WARNING);
            LauncherConfig launcherConfig = LauncherConfig.builder().addTestExecutionListeners(new TestExecutionListener[]{new PrintingListener(System.err, verbose)}).addTestExecutionListeners(new TestExecutionListener[]{summaryGeneratingListener}).build();
            try (LauncherSession session = LauncherFactory.openSession((LauncherConfig)launcherConfig);){
                session.getLauncher().execute(request, new TestExecutionListener[0]);
            }
            TestExecutionSummary summary = summaryGeneratingListener.getSummary();
            System.err.println(JUnitRunner.summarize(summary));
            if (summary.getTotalFailureCount() > 0L) {
                throw new Exception("JUnit test failure");
            }
        }
        catch (NoClassDefFoundError ex) {
            throw new Exception(JUNIT_NO_DRIVER, ex);
        }
    }

    static String summarize(TestExecutionSummary summary) {
        StringWriter sw = new StringWriter();
        try (PrintWriter pw = new PrintWriter(sw);){
            if (summary.getTotalFailureCount() > 0L) {
                pw.println("JavaTest Message: JUnit Platform Failure(s): " + summary.getTotalFailureCount());
            }
            pw.println();
            pw.print("[ JUnit Containers: ");
            pw.print("found " + summary.getContainersFoundCount());
            pw.print(", started " + summary.getContainersStartedCount());
            pw.print(", succeeded " + summary.getContainersSucceededCount());
            pw.print(", failed " + summary.getContainersFailedCount());
            pw.print(", aborted " + summary.getContainersAbortedCount());
            pw.print(", skipped " + summary.getContainersSkippedCount());
            pw.println("]");
            pw.print("[ JUnit Tests: ");
            pw.print("found " + summary.getTestsFoundCount());
            pw.print(", started " + summary.getTestsStartedCount());
            pw.print(", succeeded " + summary.getTestsSucceededCount());
            pw.print(", failed " + summary.getTestsFailedCount());
            pw.print(", aborted " + summary.getTestsAbortedCount());
            pw.print(", skipped " + summary.getTestsSkippedCount());
            pw.println("]");
        }
        return sw.toString();
    }

    static class ScratchAsTemporaryDirectory
    implements TempDirFactory {
        ScratchAsTemporaryDirectory() {
        }

        public Path createTempDirectory(AnnotatedElementContext context, ExtensionContext extensionContext) throws Exception {
            Path scratchDirectory = Paths.get("", new String[0]).toAbsolutePath();
            return Files.createTempDirectory(scratchDirectory, "junit-", new FileAttribute[0]);
        }
    }

    static class PrintingListener
    implements TestExecutionListener {
        final PrintWriter printer;
        final Lock lock;
        final AgentVerbose verbose;
        final Map<UniqueId, Long> startNanosByUniqueId = new ConcurrentHashMap<UniqueId, Long>();

        PrintingListener(PrintStream stream, AgentVerbose verbose) {
            this(new PrintWriter(stream, true), verbose);
        }

        PrintingListener(PrintWriter printer, AgentVerbose verbose) {
            this.printer = printer;
            this.lock = new ReentrantLock();
            this.verbose = verbose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionSkipped(TestIdentifier identifier, String reason) {
            ZonedDateTime now = ZonedDateTime.now();
            if (this.verbose.passMode == AgentVerbose.Mode.NONE) {
                return;
            }
            if (identifier.isTest()) {
                String skippedTime = now.format(Utils.HOUR_MIN_SEC_MS_FORMAT);
                String status = "SKIPPED";
                String source = PrintingListener.toSourceString(identifier);
                String name = identifier.getDisplayName();
                this.lock.lock();
                try {
                    this.printer.printf("[%s] %-10s %s '%s' %s%n", skippedTime, status, source, name, reason);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionStarted(TestIdentifier identifier) {
            ZonedDateTime now = ZonedDateTime.now();
            this.startNanosByUniqueId.put(identifier.getUniqueIdObject(), System.nanoTime());
            if (this.verbose.passMode == AgentVerbose.Mode.NONE) {
                return;
            }
            if (identifier.isTest()) {
                String startTime = now.format(Utils.HOUR_MIN_SEC_MS_FORMAT);
                String status = "STARTED";
                String source = PrintingListener.toSourceString(identifier);
                String name = identifier.getDisplayName();
                this.lock.lock();
                try {
                    this.printer.printf("[%s] %-10s %s '%s'%n", startTime, status, source, name);
                }
                finally {
                    this.lock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void executionFinished(TestIdentifier identifier, TestExecutionResult result) {
            ZonedDateTime now = ZonedDateTime.now();
            TestExecutionResult.Status status = result.getStatus();
            if (status == TestExecutionResult.Status.SUCCESSFUL && this.verbose.passMode == AgentVerbose.Mode.NONE) {
                return;
            }
            Long startNanos = this.startNanosByUniqueId.remove(identifier.getUniqueIdObject());
            Duration duration = startNanos == null ? Duration.ZERO : Duration.ofNanos(System.nanoTime() - startNanos);
            this.lock.lock();
            try {
                if (status == TestExecutionResult.Status.ABORTED) {
                    result.getThrowable().ifPresent(this.printer::println);
                }
                if (status == TestExecutionResult.Status.FAILED) {
                    result.getThrowable().ifPresent(throwable -> throwable.printStackTrace(this.printer));
                }
                if (identifier.isTest()) {
                    String finishedTime = now.format(Utils.HOUR_MIN_SEC_MS_FORMAT);
                    String source = PrintingListener.toSourceString(identifier);
                    String name = identifier.getDisplayName();
                    long millis = duration.toMillis();
                    this.printer.printf("[%s] %-10s %s '%s' [%dms]%n", finishedTime, status, source, name, millis);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void reportingEntryPublished(TestIdentifier identifier, ReportEntry entry) {
            if (this.verbose.passMode == AgentVerbose.Mode.NONE) {
                return;
            }
            this.lock.lock();
            try {
                this.printer.println(identifier.getDisplayName() + " -> " + entry.getTimestamp());
                entry.getKeyValuePairs().forEach((key, value) -> this.printer.println(key + " -> " + value));
            }
            finally {
                this.lock.unlock();
            }
        }

        private static String toSourceString(TestIdentifier identifier) {
            Optional optionalTestSource = identifier.getSource();
            if (!optionalTestSource.isPresent()) {
                return "<no test source>";
            }
            TestSource testSource = (TestSource)optionalTestSource.get();
            if (testSource instanceof MethodSource) {
                MethodSource source = (MethodSource)testSource;
                return source.getClassName() + "::" + source.getMethodName();
            }
            return testSource.toString();
        }
    }
}

