/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.AStatus;
import com.sun.javatest.regtest.agent.ActionHelper;
import com.sun.javatest.regtest.agent.Alarm;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.agent.ModuleHelper;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.agent.TestThreadFactoryHelper;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class MainActionHelper
extends ActionHelper {
    private final String testName;
    private Map<String, String> props;
    private Set<String> addExports;
    private Set<String> addOpens;
    private Set<String> addMods;
    private SearchPath classpath;
    private SearchPath modulepath;
    private String className;
    private List<String> classArgs;
    private int timeout;
    private float timeoutFactor;
    private String testThreadFactory;
    private String testThreadFactoryPath;
    private ActionHelper.OutputHandler outputHandler;
    private static final boolean traceCleanup = Flags.get("traceCleanup");
    private static final String MSG_PREFIX = "JavaTest Message: ";
    private static final String SKIP_EXCEPTION = "jtreg.SkippedException";
    private static final String MAIN_THREAD_INTR = "Thread interrupted: ";
    private static final String MAIN_THREAD_TIMEOUT = "Timeout";
    private static final String MAIN_THREW_EXCEPT = "`main' threw exception: ";
    private static final String MAIN_CANT_LOAD_TEST = "Can't load test: ";
    private static final String MAIN_CANT_FIND_MAIN = "Can't find `main' method";
    private static final String MAIN_CANT_INIT_MODULE_EXPORTS = "Can't init module exports: ";
    private static final String MAIN_SKIPPED = "Skipped: ";
    public static final String MAIN_SKIPPED_STATUS_PREFIX = "Skipped: jtreg.SkippedException";

    MainActionHelper(String testName) {
        this.testName = testName;
    }

    MainActionHelper properties(Map<String, String> props) {
        this.props = props;
        return this;
    }

    MainActionHelper addExports(Set<String> addExports) {
        this.addExports = addExports;
        return this;
    }

    MainActionHelper addOpens(Set<String> addOpens) {
        this.addOpens = addOpens;
        return this;
    }

    MainActionHelper addMods(Set<String> addMods) {
        this.addMods = addMods;
        return this;
    }

    MainActionHelper classpath(SearchPath classpath) {
        this.classpath = classpath;
        return this;
    }

    MainActionHelper modulepath(SearchPath modulepath) {
        this.modulepath = modulepath;
        return this;
    }

    MainActionHelper className(String className) {
        this.className = className;
        return this;
    }

    MainActionHelper classArgs(List<String> classArgs) {
        this.classArgs = classArgs;
        return this;
    }

    MainActionHelper timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    MainActionHelper timeoutFactor(float timeoutFactor) {
        this.timeoutFactor = timeoutFactor;
        return this;
    }

    MainActionHelper testThreadFactory(String testThreadFactory) {
        this.testThreadFactory = testThreadFactory;
        return this;
    }

    MainActionHelper testThreadFactoryPath(String testThreadFactoryPath) {
        this.testThreadFactoryPath = testThreadFactoryPath;
        return this;
    }

    MainActionHelper outputHandler(ActionHelper.OutputHandler outputHandler) {
        this.outputHandler = outputHandler;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AStatus runClass() {
        ActionHelper.SaveState saved = new ActionHelper.SaveState();
        Properties p = System.getProperties();
        for (Map.Entry<String, String> e : this.props.entrySet()) {
            String name = e.getKey();
            String value = e.getValue();
            if (name.equals("test.class.path.prefix")) {
                SearchPath cp = new SearchPath(value, System.getProperty("java.class.path"));
                p.put("java.class.path", cp.toString());
                continue;
            }
            p.put(e.getKey(), e.getValue());
        }
        System.setProperties(p);
        PrintStream out = this.outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDOUT, true);
        PrintStream err = this.outputHandler.getPrintStream(ActionHelper.OutputHandler.OutputKind.STDERR, true);
        AStatus status = AStatus.passed("Execution successful");
        try {
            Object[] methodArgs;
            Class[] argTypes;
            ClassLoader loader = ClassLoader.getSystemClassLoader();
            if (this.modulepath != null && !this.modulepath.isEmpty()) {
                loader = ModuleHelper.addModules(this.modulepath.asList(), this.addMods);
            }
            if (this.classpath != null && !this.classpath.isEmpty()) {
                ArrayList<URL> urls = new ArrayList<URL>();
                for (Path f : this.classpath.asList()) {
                    try {
                        urls.add(f.toUri().toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                }
                loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), loader);
            }
            ModuleHelper.addExports(this.addExports, loader);
            ModuleHelper.addOpens(this.addOpens, loader);
            Class<?> c = loader.loadClass(this.className);
            String[] classArgsArray = this.classArgs.toArray(new String[this.classArgs.size()]);
            if (TestRunner.class.isAssignableFrom(c)) {
                argTypes = new Class[]{ClassLoader.class, String[].class};
                methodArgs = new Object[]{loader, classArgsArray};
            } else {
                argTypes = new Class[]{String[].class};
                methodArgs = new Object[]{classArgsArray};
            }
            Method method = c.getMethod("main", argTypes);
            PrintStream realStdErr = System.err;
            AStatus stat = MainActionHelper.redirectOutput(out, err);
            if (!stat.isPassed()) {
                AStatus aStatus = stat;
                return aStatus;
            }
            AgentVMRunnable avmr = new AgentVMRunnable(method, methodArgs, err);
            AgentVMThreadGroup tg = new AgentVMThreadGroup(err, MSG_PREFIX, this.timeoutFactor);
            Thread t = this.testThreadFactory == null ? new Thread((ThreadGroup)tg, avmr) : TestThreadFactoryHelper.loadThreadFactory(this.testThreadFactory, this.testThreadFactoryPath).newThread(avmr);
            Alarm alarm = null;
            if (this.timeout > 0) {
                PrintWriter alarmOut = this.outputHandler.getPrintWriter(ActionHelper.OutputHandler.OutputKind.LOG, true);
                alarm = Alarm.schedulePeriodicInterrupt(this.timeout, TimeUnit.SECONDS, alarmOut, t);
            }
            Throwable error = null;
            t.setName("AgentVMThread");
            t.start();
            try {
                t.join();
                if (traceCleanup) {
                    realStdErr.println("main method returned");
                }
            }
            catch (InterruptedException e) {
                realStdErr.println("main method interrupted");
                if (t.isInterrupted() && tg.uncaughtThrowable == null) {
                    error = e;
                    status = AStatus.error(MAIN_THREAD_INTR + e.getMessage());
                }
            }
            finally {
                if (traceCleanup) {
                    realStdErr.println("cleaning threads");
                }
                tg.cleanup();
                if (traceCleanup) {
                    realStdErr.println("thread cleanup completed");
                }
                if (alarm != null) {
                    alarm.cancel();
                    if (alarm.didFire() && error == null) {
                        err.println("Test timed out. No timeout information is available in agentvm mode.");
                        error = new Error("timeout");
                        status = AStatus.error(MAIN_THREAD_TIMEOUT);
                    }
                }
            }
            if ((avmr.t != null || tg.uncaughtThrowable != null) && error == null) {
                error = avmr.t == null ? tg.uncaughtThrowable : avmr.t;
                status = SKIP_EXCEPTION.equals(error.getClass().getName()) ? AStatus.passed(MAIN_SKIPPED + error.toString()) : AStatus.failed(MAIN_THREW_EXCEPT + error.toString());
            }
            if (status.getReason().contains("java.lang.SecurityException: System.exit() forbidden")) {
                status = AStatus.failed("Unexpected exit from test");
            } else if (!tg.cleanupOK) {
                status = AStatus.error("Error while cleaning up threads after test");
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace(err);
            err.println();
            err.println("JavaTest Message: main() method must be in a public class named");
            err.println(MSG_PREFIX + this.className + " in file " + this.className + ".java");
            err.println();
            status = AStatus.error(MAIN_CANT_LOAD_TEST + e);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace(err);
            err.println();
            err.println("JavaTest Message: main() method must be in a public class named");
            err.println(MSG_PREFIX + this.className + " in file " + this.className + ".java");
            err.println();
            status = AStatus.error(MAIN_CANT_FIND_MAIN);
        }
        catch (ModuleHelper.Fault e) {
            if (e.getCause() != null) {
                e.printStackTrace(err);
            }
            status = AStatus.error(MAIN_CANT_INIT_MODULE_EXPORTS + e.getMessage());
        }
        finally {
            out.close();
            err.close();
            status = saved.restore(this.testName, status);
        }
        return status;
    }

    public static interface TestRunner {
    }

    private static class AgentVMRunnable
    implements Runnable {
        public Object result;
        private final Method method;
        private final Object[] args;
        private final PrintStream out;
        Throwable t = null;

        public AgentVMRunnable(Method m, Object[] args, PrintStream out) {
            this.method = m;
            this.args = args;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                this.result = this.method.invoke(null, this.args);
                this.out.println();
                this.out.println("JavaTest Message: Test complete.");
                this.out.println();
            }
            catch (InvocationTargetException e) {
                e.getTargetException().printStackTrace(this.out);
                this.t = e.getTargetException();
                this.out.println();
                this.out.println("JavaTest Message: Test threw exception: " + this.t.getClass().getName());
                this.out.println("JavaTest Message: shutting down test");
                this.out.println();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(this.out);
                this.t = e;
                this.out.println();
                this.out.println("JavaTest Message: Verify that the class defining the test is");
                this.out.println("JavaTest Message: declared public (test invoked via reflection)");
                this.out.println();
            }
        }
    }

    static class AgentVMThreadGroup
    extends ThreadGroup {
        private double timeoutFactor;
        private final PrintStream out;
        private final String messagePrefix;
        private boolean cleaning = false;
        Throwable uncaughtThrowable = null;
        Thread uncaughtThread = null;
        boolean cleanupOK = false;

        AgentVMThreadGroup(PrintStream out, String messagePrefix, double timeoutFactor) {
            super("AgentVMThreadGroup");
            this.out = out;
            this.messagePrefix = messagePrefix;
            this.timeoutFactor = timeoutFactor;
        }

        @Override
        public synchronized void uncaughtException(Thread t, Throwable e) {
            if (e instanceof ThreadDeath) {
                return;
            }
            if (this.uncaughtThrowable == null && !this.cleaning) {
                this.uncaughtThrowable = e;
                this.uncaughtThread = t;
            }
            this.cleanup();
        }

        private void cleanup() {
            this.cleaning = true;
            int CLEANUP_ROUNDS = 4;
            long MAX_CLEANUP_TIME_MILLIS = (long)(10000.0 * this.timeoutFactor);
            long CLEANUP_MILLIS_PER_ROUND = MAX_CLEANUP_TIME_MILLIS / 4L;
            long NANOS_PER_MILLI = 1000000L;
            long startCleanupTime = System.nanoTime();
            block2: for (int i = 1; i <= 4; ++i) {
                long deadline = startCleanupTime + (long)i * CLEANUP_MILLIS_PER_ROUND * 1000000L;
                List<Thread> liveThreads = this.liveThreads();
                if (liveThreads.isEmpty()) {
                    this.cleanupOK = true;
                    return;
                }
                for (Thread thread : liveThreads) {
                    thread.interrupt();
                }
                for (Thread thread : liveThreads) {
                    long millis = (deadline - System.nanoTime()) / 1000000L;
                    if (millis <= 0L) continue block2;
                    try {
                        thread.join(millis);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            List<Thread> remaining = this.liveThreads();
            if (remaining.isEmpty()) {
                this.cleanupOK = true;
                return;
            }
            this.out.println();
            this.out.println(this.messagePrefix + "Problem cleaning up the following threads:");
            this.printTraces(remaining);
            this.cleanupOK = false;
        }

        private List<Thread> liveThreads() {
            int estSize = this.activeCount() + 1;
            while (true) {
                Thread[] threads;
                int num;
                if ((num = this.enumerate(threads = new Thread[estSize])) < threads.length) {
                    ArrayList<Thread> list = new ArrayList<Thread>(num);
                    for (int i = 0; i < num; ++i) {
                        Thread t = threads[i];
                        if (!t.isAlive() || t == Thread.currentThread() || t.isDaemon()) continue;
                        list.add(t);
                    }
                    return list;
                }
                estSize *= 2;
            }
        }

        private void printTraces(List<Thread> threads) {
            int MAX_FRAMES = 20;
            for (Thread t : threads) {
                this.out.println(t.getName());
                StackTraceElement[] trace = t.getStackTrace();
                for (int i = 0; i < trace.length; ++i) {
                    this.out.println("  at " + trace[i]);
                    if (i != 20) continue;
                    this.out.println("  ...");
                    break;
                }
                this.out.println();
            }
        }
    }
}

