/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.JavaTestSecurityManager;
import java.security.Permission;
import java.util.PropertyPermission;

public class RegressionSecurityManager
extends JavaTestSecurityManager {
    private boolean allowExec = true;
    private boolean propertiesModified;
    private boolean allowSetIO = false;
    private boolean allowSetSecurityManager = false;
    private static boolean verbose = Boolean.getBoolean("javatest.security.verbose");

    public static void install() {
        block5: {
            int v;
            String sv = System.getProperty("java.specification.version");
            if (sv != null && sv.matches("[0-9]+") && (v = Integer.parseInt(sv)) >= 18) {
                return;
            }
            try {
                String noSecurityMgr = "javatest.security.noSecurityManager";
                if (Boolean.getBoolean("javatest.security.noSecurityManager")) {
                    System.err.println();
                    System.err.println("     ---- WARNING -----");
                    System.err.println();
                    System.err.println("JavaTest did not install its own Security Manager");
                    System.err.println("because the property javatest.security.noSecurityManager was set.");
                    System.err.println("This is not a fatal error, but it may affect the");
                    System.err.println("execution of sameJVM tests");
                    System.err.println();
                } else {
                    System.setSecurityManager(new RegressionSecurityManager());
                }
            }
            catch (SecurityException e) {
                SecurityManager sm = System.getSecurityManager();
                if (sm instanceof JavaTestSecurityManager) break block5;
                System.err.println();
                System.err.println("     ---- WARNING -----");
                System.err.println();
                System.err.println("JavaTest could not install its own Security Manager");
                System.err.println("because of the following exception:");
                System.err.println("     " + e);
                System.err.println("This is not a fatal error, but it may affect the");
                System.err.println("execution of sameJVM tests");
                System.err.println();
            }
        }
    }

    @Override
    public void checkExec(String cmd) {
        if (!this.allowExec) {
            if (verbose) {
                System.err.println(this.getClass().getName() + ": subprocess creation forbidden");
                new Throwable().printStackTrace();
            }
            throw new SecurityException("Subprocess creation forbidden by JavaTest");
        }
    }

    public boolean setAllowExec(boolean bool) {
        boolean prev = this.allowExec;
        this.allowExec = bool;
        return prev;
    }

    @Override
    public void checkPermission(Permission perm) {
        if (perm instanceof RuntimePermission) {
            if (perm.getName().equals("setIO")) {
                if (!this.allowSetIO) {
                    super.checkPermission(new RuntimePermission("setIO"));
                }
            } else if (perm.getName().equals("exitVM")) {
                this.checkExit(0);
            } else if (!perm.getName().equals("createSecurityManager") && perm.getName().equals("setSecurityManager")) {
                if (!this.allowSetSecurityManager) {
                    this.forbid(perm);
                }
                this.propertiesModified = true;
            }
        } else if (perm instanceof PropertyPermission && perm.getActions().contains("write")) {
            this.propertiesModified = true;
        }
    }

    void forbid(Permission perm) throws SecurityException {
        if (verbose) {
            System.err.println(this.getClass().getName() + ": " + perm);
            Thread.dumpStack();
        }
        throw new SecurityException("Action forbidden by jtreg: " + perm.getName());
    }

    @Override
    public synchronized void checkPropertiesAccess() {
        super.checkPropertiesAccess();
        this.propertiesModified = true;
    }

    boolean isPropertiesModified() {
        return this.propertiesModified;
    }

    @Override
    public boolean setAllowPropertiesAccess(boolean b) {
        return super.setAllowPropertiesAccess(b);
    }

    void resetPropertiesModified() {
        this.propertiesModified = false;
    }

    public boolean setAllowSetIO(boolean bool) {
        boolean prev = this.allowSetIO;
        this.allowSetIO = bool;
        return prev;
    }

    public boolean setAllowSetSecurityManager(boolean bool) {
        boolean prev = this.allowSetSecurityManager;
        this.allowSetSecurityManager = bool;
        return prev;
    }
}

