/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.agent;

import com.sun.javatest.regtest.agent.MainActionHelper;
import com.sun.javatest.regtest.agent.Utils;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.testng.IConfigurationListener;
import org.testng.IMethodInstance;
import org.testng.IMethodInterceptor;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.TestNG;
import org.testng.TestNGException;
import org.testng.reporters.XMLReporter;

public class TestNGRunner
implements MainActionHelper.TestRunner {
    public static void main(String ... args) throws Exception {
        TestNGRunner.main(null, args);
    }

    public static void main(ClassLoader loader, String ... args) throws Exception {
        ClassLoader cl;
        String className;
        if (args.length != 3) {
            throw new Error("wrong number of arguments");
        }
        String testName = args[0];
        boolean mixedMode = Boolean.parseBoolean(args[1]);
        String moduleClassName = args[2];
        int sep = moduleClassName.indexOf(47);
        String moduleName = sep == -1 ? null : moduleClassName.substring(0, sep);
        String string = className = sep == -1 ? moduleClassName : moduleClassName.substring(sep + 1);
        if (moduleName != null) {
            Class<?> layerClass;
            try {
                layerClass = Class.forName("java.lang.ModuleLayer");
            }
            catch (ClassNotFoundException e) {
                layerClass = Class.forName("java.lang.reflect.Layer");
            }
            Method bootMethod = layerClass.getMethod("boot", new Class[0]);
            Object bootLayer = bootMethod.invoke(null, new Object[0]);
            Method findLoaderMth = layerClass.getMethod("findLoader", String.class);
            cl = (ClassLoader)findLoaderMth.invoke(bootLayer, moduleName);
        } else {
            cl = loader != null ? loader : TestNGRunner.class.getClassLoader();
        }
        Class<?> mainClass = Class.forName(className, false, cl);
        String testQuery = System.getProperty("test.query");
        RegressionListener listener = new RegressionListener();
        TestNG testng = new TestNG(false);
        testng.setMixed(Boolean.valueOf(mixedMode));
        testng.setDefaultSuiteName(testName);
        testng.setTestClasses(new Class[]{mainClass});
        if (testQuery != null) {
            testng.setMethodInterceptor((IMethodInterceptor)new FilterMethods(className, testQuery));
        }
        testng.addListener((ITestNGListener)listener);
        testng.addListener((ITestNGListener)new XMLReporter());
        testng.setOutputDirectory(new File(".").getPath());
        testng.run();
        int configFailureCount = listener.configFailureCount.get();
        int testFailureCount = listener.failureCount.get();
        if (configFailureCount > 0 || testFailureCount > 0) {
            throw new Exception("config failures: " + configFailureCount + ", test failures: " + testFailureCount);
        }
    }

    public static class RegressionListener
    implements ITestListener,
    IConfigurationListener {
        private final AtomicInteger count = new AtomicInteger();
        private final AtomicInteger successCount = new AtomicInteger();
        private final AtomicInteger failureCount = new AtomicInteger();
        private final AtomicInteger skippedCount = new AtomicInteger();
        private final AtomicInteger configSuccessCount = new AtomicInteger();
        private final AtomicInteger configFailureCount = new AtomicInteger();
        private final AtomicInteger configSkippedCount = new AtomicInteger();
        private final AtomicInteger failedButWithinSuccessPercentageCount = new AtomicInteger();
        private final Map<ITestResult, Long> startTimeNanos = Collections.synchronizedMap(new IdentityHashMap());

        public void onTestStart(ITestResult itr) {
            this.count.incrementAndGet();
            this.startTimeNanos.put(itr, System.nanoTime());
        }

        public void onTestSuccess(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.successCount.incrementAndGet();
            this.report(now, InfoKind.TEST, itr);
        }

        public void onTestFailure(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.failureCount.incrementAndGet();
            this.report(now, InfoKind.TEST, itr);
        }

        public void onTestSkipped(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            Throwable t = itr.getThrowable();
            if (t != null && !(t instanceof SkipException)) {
                this.onTestFailure(itr);
                return;
            }
            this.skippedCount.incrementAndGet();
            this.report(now, InfoKind.TEST, itr);
        }

        public void onTestFailedButWithinSuccessPercentage(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.failedButWithinSuccessPercentageCount.incrementAndGet();
            this.report(now, InfoKind.TEST, itr);
        }

        public void onStart(ITestContext itc) {
        }

        public void onFinish(ITestContext itc) {
        }

        public void onConfigurationSuccess(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.configSuccessCount.incrementAndGet();
            this.report(now, InfoKind.CONFIG, itr);
        }

        public void onConfigurationFailure(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.configFailureCount.incrementAndGet();
            this.report(now, InfoKind.CONFIG, itr);
        }

        public void onConfigurationSkip(ITestResult itr) {
            ZonedDateTime now = ZonedDateTime.now();
            this.configSkippedCount.incrementAndGet();
            this.report(now, InfoKind.CONFIG, itr);
        }

        void report(ZonedDateTime reportedAt, InfoKind k, ITestResult itr) {
            String suffix;
            Throwable t = itr.getThrowable();
            if (t != null && itr.getStatus() != 1) {
                StringWriter trace = new StringWriter();
                try (PrintWriter pw = new PrintWriter(trace);){
                    t.printStackTrace(pw);
                }
                suffix = "\n" + trace;
            } else {
                suffix = "\n";
            }
            Long startNanos = this.startTimeNanos.remove(itr);
            Duration duration = startNanos == null ? Duration.ZERO : Duration.ofNanos(System.nanoTime() - startNanos);
            long durationMillis = duration.toMillis();
            System.out.print("[" + reportedAt.format(Utils.HOUR_MIN_SEC_MS_FORMAT) + "] " + k.toString().toLowerCase() + " " + itr.getMethod().getConstructorOrMethod().getDeclaringClass().getName() + "." + itr.getMethod().getMethodName() + this.formatParams(itr) + ": " + this.statusToString(itr.getStatus()) + " [" + durationMillis + "ms]" + suffix);
        }

        private String formatParams(ITestResult itr) {
            StringBuilder sb = new StringBuilder(80);
            sb.append('(');
            String sep = "";
            for (Object arg : itr.getParameters()) {
                sb.append(sep);
                this.formatParam(sb, arg);
                sep = ", ";
            }
            sb.append(")");
            return sb.toString();
        }

        private void formatParam(StringBuilder sb, Object param) {
            if (param instanceof String) {
                sb.append('\"');
                sb.append((String)param);
                sb.append('\"');
            } else {
                String value = String.valueOf(param);
                if (value.length() > 30) {
                    sb.append(param.getClass().getName());
                    sb.append('@');
                    sb.append(Integer.toHexString(System.identityHashCode(param)));
                } else {
                    sb.append(value);
                }
            }
        }

        private String statusToString(int s) {
            switch (s) {
                case 1: {
                    return "success";
                }
                case 2: {
                    return "failure";
                }
                case 3: {
                    return "skip";
                }
                case 4: {
                    return "success_percentage_failure";
                }
            }
            return "??";
        }

        static enum InfoKind {
            CONFIG,
            TEST;

        }
    }

    private static class FilterMethods
    implements IMethodInterceptor {
        private final String testClass;
        private final String testQuery;

        public FilterMethods(String testClass, String testQuery) {
            this.testClass = testClass;
            this.testQuery = testQuery;
        }

        public List<IMethodInstance> intercept(List<IMethodInstance> ms, ITestContext c) {
            List<IMethodInstance> result = ms.stream().filter(mi -> this.testQuery.equals(mi.getMethod().getMethodName())).collect(Collectors.toList());
            if (result.isEmpty()) {
                throw new TestNGException("Could not find method with name [" + this.testQuery + "] in class [" + this.testClass + "]");
            }
            return result;
        }
    }
}

