/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestSuite;
import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.config.JDK;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.config.RegressionTestSuite;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.regtest.util.FileUtils;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public final class Locations {
    private final RegressionTestSuite testSuite;
    private final Set<String> systemModules;
    private final SearchPath jtpath;
    private final JDK testJDK;
    private final Path absTestFile;
    private final Path absBaseSrcDir;
    private final Path absTestSrcDir;
    private final Path absBaseClsDir;
    private final Path absTestClsDir;
    private final Path absTestPatchDir;
    private final Path absTestModulesDir;
    private final Path absTestWorkDir;
    private final Path relLibDir;
    private final List<LibLocn> libList;
    private static final String[] extns = new String[]{".java", ".jasm", ".jcod"};
    private static final AtomicInteger uniqueId = new AtomicInteger(0);
    private static final ThreadLocal<Integer> uniqueNum = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return uniqueId.getAndIncrement();
        }
    };
    public static final String CANT_FIND_CLASS = "Can't find source for class: ";
    public static final String LIB_LIST = " in directory-list: ";
    public static final String PATH_TESTCLASS = "Unable to locate test class directory!?";
    public static final String CANT_FIND_LIB = "Can't find library: ";
    public static final String BAD_LIB = "Bad file for library: ";
    public static final String BAD_FILE_IN_LIB = "Bad file in library: ";
    public static final String MIXED_LIB = "Can't mix packages, user modules, and patches for system module in library: ";

    public Locations(RegressionParameters params, TestDescription td, Consumer<String> logger) throws Fault {
        this.testSuite = params.getTestSuite();
        this.systemModules = params.getTestJDK().getSystemModules(params, logger);
        this.jtpath = params.getJavaTestClassPath();
        this.testJDK = params.getTestJDK();
        Version v = this.testSuite.getRequiredVersion();
        boolean useUniqueClassDir = v.version != null && v.compareTo(new Version("4.2 b08")) >= 0;
        this.absTestFile = td.getFile().toPath().toAbsolutePath();
        Path relTestFile = td.getRootRelativeFile().toPath();
        Path relTestDir = relTestFile.getParent();
        if (relTestDir == null) {
            relTestDir = Path.of(".", new String[0]);
        }
        String testName = relTestFile.getFileName().toString();
        String testId = td.getId();
        String uniqueTestSubDir = testName.replaceAll("(?i)\\.[a-z]+$", (String)(testId == null ? "" : "_" + testId) + ".d");
        String packageRoot = td.getParameter("packageRoot");
        this.relLibDir = packageRoot != null ? Path.of(packageRoot, new String[0]) : relTestDir;
        Path relTestSrcDir = this.relLibDir;
        this.absBaseSrcDir = params.getTestSuite().getRootDir().toPath();
        this.absTestSrcDir = this.absBaseSrcDir.resolve(relTestSrcDir).normalize();
        Path workDirRoot = params.getWorkDirectory().getRoot().toPath();
        Path relTestWorkDir = relTestDir.resolve(uniqueTestSubDir);
        this.absTestWorkDir = workDirRoot.resolve(relTestWorkDir);
        this.absBaseClsDir = this.getThreadSafeDir(workDirRoot.resolve("classes"), params.getConcurrency());
        Path relTestClsDir = packageRoot != null ? Path.of(packageRoot, new String[0]) : (useUniqueClassDir ? relTestDir.resolve(uniqueTestSubDir) : relTestDir);
        this.absTestClsDir = this.absBaseClsDir.resolve(relTestClsDir).normalize();
        this.absTestPatchDir = this.absTestClsDir.resolve("patches");
        this.absTestModulesDir = this.absTestClsDir.resolve("modules");
        this.libList = new ArrayList<LibLocn>();
        String libs = td.getParameter("library");
        for (String lib : StringUtils.splitWS(libs)) {
            this.libList.add(this.getLibLocn(td, lib));
        }
    }

    public List<LibLocn> getLibs() {
        return this.libList;
    }

    private LibLocn getLibLocn(TestDescription td, String lib) throws Fault {
        Path libDir = this.absTestClsDir;
        if (this.testSuite.getShareLibraries(td)) {
            libDir = this.absBaseClsDir;
        }
        if (lib.startsWith("/")) {
            String libTail = lib.substring(1);
            this.checkLibPath(Path.of(libTail, new String[0]));
            if (Files.exists(this.absBaseSrcDir.resolve(libTail), new LinkOption[0])) {
                return this.createLibLocn(lib, this.absBaseSrcDir, libDir);
            }
            try {
                for (File extRootFile : this.testSuite.getExternalLibRoots(td)) {
                    Path extRoot = extRootFile.toPath();
                    if (!Files.exists(extRoot.resolve(libTail), new LinkOption[0])) continue;
                    return this.createLibLocn(lib, extRoot, libDir);
                }
            }
            catch (TestSuite.Fault e) {
                throw new Fault(CANT_FIND_LIB + e);
            }
        } else if (lib.startsWith("${") && lib.endsWith(".jar")) {
            int end = lib.indexOf("}/");
            if (end != -1) {
                String libTail;
                Path absLib;
                String name = lib.substring(2, end);
                Path dir = null;
                if (name.equals("java.home")) {
                    dir = this.testJDK.getAbsoluteHomeDirectory();
                } else if (name.equals("jtreg.home")) {
                    dir = this.jtpath.asList().get(0).getParent().getParent();
                }
                if (dir != null && Files.exists(absLib = dir.resolve(libTail = lib.substring(end + 2)), new LinkOption[0])) {
                    return new LibLocn(lib, null, absLib, LibLocn.Kind.PRECOMPILED_JAR);
                }
            }
        } else {
            this.checkLibPath(this.relLibDir.resolve(lib));
            if (Files.exists(this.absTestSrcDir.resolve(lib), new LinkOption[0])) {
                return this.createLibLocn(lib, this.absTestSrcDir, libDir.resolve(this.relLibDir));
            }
        }
        throw new Fault(CANT_FIND_LIB + lib);
    }

    private void checkLibPath(Path lib) throws Fault {
        Path l = lib.normalize();
        if (l.startsWith(Path.of("..", new String[0]))) {
            throw new Fault("effective library path is outside the test suite: " + l);
        }
    }

    private LibLocn createLibLocn(String lib, Path absBaseSrcDir, Path absBaseClsDir) throws Fault {
        String relLib = lib.startsWith("/") ? lib.substring(1) : lib;
        Path absLib = absBaseSrcDir.resolve(relLib).normalize();
        if (Files.isRegularFile(absLib, new LinkOption[0]) && absLib.getFileName().toString().endsWith(".jar")) {
            return new LibLocn(lib, null, absLib, LibLocn.Kind.PRECOMPILED_JAR);
        }
        if (!Files.isDirectory(absLib, new LinkOption[0])) {
            throw new Fault(BAD_LIB + lib);
        }
        Path absLibSrcDir = absLib;
        Path absLibClsDir = absBaseClsDir.resolve(relLib).normalize();
        LibLocn.Kind kind = this.getDirKind(absLibSrcDir);
        return new LibLocn(lib, absLibSrcDir, absLibClsDir, kind);
    }

    public Set<LibLocn.Kind> getDirKinds(Path absSrcDir) {
        EnumSet<LibLocn.Kind> kinds = EnumSet.noneOf(LibLocn.Kind.class);
        for (Path f : FileUtils.listFiles(absSrcDir)) {
            if (!Files.isDirectory(f, new LinkOption[0])) continue;
            if (this.isSystemModule(f.getFileName().toString())) {
                kinds.add(LibLocn.Kind.SYS_MODULE);
                continue;
            }
            if (Files.exists(f.resolve("module-info.java"), new LinkOption[0])) {
                kinds.add(LibLocn.Kind.USER_MODULE);
                continue;
            }
            kinds.add(LibLocn.Kind.PACKAGE);
        }
        return kinds;
    }

    public LibLocn.Kind getDirKind(Path absSrcDir) throws Fault {
        Set<LibLocn.Kind> kinds = this.getDirKinds(absSrcDir);
        switch (kinds.size()) {
            case 0: {
                return LibLocn.Kind.PACKAGE;
            }
            case 1: {
                return kinds.iterator().next();
            }
        }
        throw new Fault(MIXED_LIB + absSrcDir);
    }

    boolean isSystemModule(String name) {
        return this.systemModules != null && this.systemModules.contains(name);
    }

    public Path absTestFile() {
        return this.absTestFile;
    }

    public Path absTestSrcDir() {
        return this.absTestSrcDir;
    }

    public Path absTestSrcDir(String optModule) {
        return this.getFile(this.absTestSrcDir, optModule);
    }

    public Path absTestSrcFile(String optModule, File srcFile) {
        if (srcFile.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        return this.getFile(this.absTestSrcDir, optModule, srcFile.getPath());
    }

    public List<Path> absTestSrcPath() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this.absTestSrcDir);
        for (LibLocn l : this.libList) {
            if (l.kind != LibLocn.Kind.PACKAGE) continue;
            list.add(l.absSrcDir);
        }
        return list;
    }

    public List<Path> absLibSrcList(LibLocn.Kind kind) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (LibLocn l : this.libList) {
            if (l.kind != kind) continue;
            list.add(l.absSrcDir);
        }
        return list;
    }

    public List<Path> absLibSrcJarList() {
        ArrayList<Path> list = new ArrayList<Path>();
        for (LibLocn l : this.libList) {
            Path f;
            if (l.kind != LibLocn.Kind.PRECOMPILED_JAR || !Files.isRegularFile(f = l.absClsDir, new LinkOption[0]) || !f.getFileName().toString().endsWith(".jar") || !Files.exists(f, new LinkOption[0])) continue;
            list.add(f);
        }
        return list;
    }

    public Path absBaseClsDir() {
        return this.absBaseClsDir;
    }

    public Path absTestClsDir() {
        return this.absTestClsDir;
    }

    public Path absTestClsDir(String optModule) {
        if (optModule == null) {
            return this.absTestClsDir;
        }
        if (this.isSystemModule(optModule)) {
            return this.absTestPatchDir().resolve(optModule);
        }
        return this.absTestModulesDir().resolve(optModule);
    }

    public List<Path> absTestClsPath() {
        ArrayList<Path> list = new ArrayList<Path>();
        list.add(this.absTestClsDir);
        for (LibLocn l : this.libList) {
            switch (l.kind) {
                case PACKAGE: 
                case PRECOMPILED_JAR: {
                    list.add(l.absClsDir);
                }
            }
        }
        return list;
    }

    public List<Path> absLibClsList(LibLocn.Kind kind) {
        ArrayList<Path> list = new ArrayList<Path>();
        for (LibLocn l : this.libList) {
            if (l.kind != kind) continue;
            list.add(l.absClsDir);
        }
        return list;
    }

    public Path absTestWorkFile(String name) {
        return this.absTestWorkDir.resolve(name);
    }

    public Path absTestModulesDir() {
        return this.absTestModulesDir;
    }

    public Path absTestPatchDir() {
        return this.absTestPatchDir;
    }

    public List<ClassLocn> locateClasses(String name) throws Fault {
        List<ClassLocn> results;
        ArrayList<LibLocn> searchLocns;
        String className;
        String optModule;
        int sep = name.indexOf("/");
        if (sep > 0) {
            optModule = name.substring(0, sep);
            className = name.substring(sep + 1);
            List<LibLocn> moduleLocns = this.getModuleLocn(optModule);
            if (moduleLocns.isEmpty()) {
                throw new Fault("can't find module " + optModule + " in test directory or libraries");
            }
            searchLocns = moduleLocns;
        } else {
            optModule = null;
            className = name;
            searchLocns = new ArrayList<LibLocn>();
            searchLocns.add(new LibLocn(null, this.absTestSrcDir, this.absTestClsDir, LibLocn.Kind.PACKAGE));
            for (LibLocn l : this.libList) {
                if (l.kind != LibLocn.Kind.PACKAGE) continue;
                searchLocns.add(l);
            }
        }
        if (className.equals("*")) {
            results = this.locateClassesInPackage(searchLocns, optModule, null);
        } else if (className.endsWith(".*")) {
            String packageName = className.substring(0, className.length() - 2);
            results = this.locateClassesInPackage(searchLocns, optModule, packageName);
        } else {
            results = this.locateClass(searchLocns, optModule, className);
        }
        if (results.isEmpty()) {
            if (optModule == null) {
                throw new Fault("can't find " + className + " in test directory or libraries");
            }
            throw new Fault("can't find " + className + " in module " + optModule + " in " + ((LibLocn)searchLocns.get((int)0)).absSrcDir);
        }
        return results;
    }

    List<LibLocn> getModuleLocn(String moduleName) {
        if (moduleName == null) {
            throw new NullPointerException();
        }
        if (this.isSystemModule(moduleName)) {
            ArrayList<LibLocn> list = new ArrayList<LibLocn>();
            if (Files.exists(this.getFile(this.absTestSrcDir, moduleName), new LinkOption[0])) {
                list.add(new LibLocn(null, this.absTestSrcDir, this.absTestPatchDir(), LibLocn.Kind.SYS_MODULE));
            }
            for (LibLocn l : this.libList) {
                if (l.kind != LibLocn.Kind.SYS_MODULE || !Files.exists(this.getFile(l.absSrcDir, moduleName), new LinkOption[0])) continue;
                list.add(l);
            }
            return list;
        }
        if (Files.exists(this.getFile(this.absTestSrcDir, moduleName), new LinkOption[0])) {
            return Collections.singletonList(new LibLocn(null, this.absTestSrcDir, this.absTestModulesDir(), LibLocn.Kind.USER_MODULE));
        }
        for (LibLocn l : this.libList) {
            if (l.kind != LibLocn.Kind.USER_MODULE || !Files.exists(this.getFile(l.absSrcDir, moduleName), new LinkOption[0])) continue;
            return Collections.singletonList(l);
        }
        return Collections.emptyList();
    }

    private List<ClassLocn> locateClass(List<LibLocn> locns, String optModule, String className) {
        for (LibLocn l : locns) {
            ClassLocn cl = this.locateClass(l, optModule, className);
            if (cl == null) continue;
            return Collections.singletonList(cl);
        }
        return Collections.emptyList();
    }

    private ClassLocn locateClass(LibLocn locn, String optModule, String className) {
        for (String e : extns) {
            String baseName;
            int sep;
            String relSrc = className.replace('.', File.separatorChar) + e;
            String relCls = className.replace('.', File.separatorChar) + ".class";
            Path sf = this.getFile(locn.absSrcDir, optModule, relSrc);
            if (Files.exists(sf, new LinkOption[0])) {
                Path cf = this.getFile(locn.absClsDir, optModule, relCls);
                return new ClassLocn(locn, optModule, className, sf, cf);
            }
            if (locn.name != null || optModule != null || (sep = relSrc.lastIndexOf(File.separatorChar)) < 0 || !Files.exists(sf = this.absTestSrcDir.resolve(baseName = relSrc.substring(sep + 1)), new LinkOption[0])) continue;
            Path cf = this.absTestClsDir.resolve(relCls);
            return new ClassLocn(locn, null, className, sf, cf);
        }
        return null;
    }

    private List<ClassLocn> locateClassesInPackage(List<LibLocn> locns, String optModule, String optPackage) throws Fault {
        ArrayList<ClassLocn> results = new ArrayList<ClassLocn>();
        boolean recursive = optModule != null && optPackage == null;
        for (LibLocn l : locns) {
            this.locateClassesInPackage(l, optModule, optPackage, recursive, results);
        }
        return results;
    }

    private void locateClassesInPackage(LibLocn l, String optModule, String optPackage, boolean recursive, List<ClassLocn> results) throws Fault {
        Path pkgClsDir;
        Path pkgSrcDir;
        if (optPackage == null) {
            pkgSrcDir = this.getFile(l.absSrcDir, optModule);
            pkgClsDir = this.getFile(l.absClsDir, optModule);
        } else {
            String p = optPackage.replace('.', File.separatorChar);
            pkgSrcDir = this.getFile(l.absSrcDir, optModule, p);
            pkgClsDir = this.getFile(l.absClsDir, optModule, p);
        }
        if (!Files.isDirectory(pkgSrcDir, new LinkOption[0])) {
            return;
        }
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(pkgSrcDir);){
            for (Path sf : ds) {
                String fn = sf.getFileName().toString();
                if (Files.isDirectory(sf, new LinkOption[0])) {
                    if (!recursive) continue;
                    String subpkg = optPackage == null ? fn : optPackage + "." + fn;
                    this.locateClassesInPackage(l, optModule, subpkg, true, results);
                    continue;
                }
                if (!Files.isReadable(sf) || !this.hasExtn(fn, extns)) continue;
                String cn = fn.substring(0, fn.lastIndexOf("."));
                String className = optPackage == null ? cn : optPackage + "." + cn;
                Path cf = pkgClsDir.resolve(cn + ".class");
                results.add(new ClassLocn(l, optModule, className, sf, cf));
            }
        }
        catch (IOException e) {
            throw new Fault("error reading directory " + pkgSrcDir, e);
        }
    }

    private Path getFile(Path absBaseDir, String optModule) {
        return optModule == null ? absBaseDir : absBaseDir.resolve(optModule);
    }

    private Path getFile(Path absBaseDir, String optModule, String relFile) {
        return this.getFile(absBaseDir, optModule).resolve(relFile);
    }

    private boolean hasExtn(String name, String ... extns) {
        for (String e : extns) {
            if (!name.endsWith(e)) continue;
            return true;
        }
        return false;
    }

    private Path getThreadSafeDir(Path file, int concurrency) {
        return concurrency == 1 ? file : file.resolve(String.valueOf(Locations.getCurrentThreadId()));
    }

    private static int getCurrentThreadId() {
        return uniqueNum.get();
    }

    public static class LibLocn {
        public final String name;
        public final Path absSrcDir;
        public final Path absClsDir;
        public final Kind kind;

        LibLocn(String name, Path absSrcDir, Path absClsDir, Kind kind) {
            this.name = name;
            this.absSrcDir = absSrcDir;
            this.absClsDir = absClsDir;
            this.kind = kind;
        }

        public boolean isLibrary() {
            return this.name != null;
        }

        public boolean isTest() {
            return this.name == null;
        }

        public boolean equals(Object other) {
            if (other instanceof LibLocn) {
                LibLocn l = (LibLocn)other;
                return this.name == null ? l.name == null : this.name.equals(l.name) && this.absSrcDir.equals(l.absSrcDir) && this.absClsDir.equals(l.absClsDir) && this.kind == l.kind;
            }
            return false;
        }

        public int hashCode() {
            return ((this.name == null ? 0 : this.name.hashCode()) << 7) + (this.absSrcDir.hashCode() << 5) + (this.absClsDir.hashCode() << 3) + this.kind.hashCode();
        }

        public String toString() {
            return "LibLocn(" + this.name + ",src:" + this.absSrcDir + ",cls:" + this.absClsDir + "," + this.kind + ")";
        }

        public static enum Kind {
            PACKAGE,
            PRECOMPILED_JAR,
            SYS_MODULE,
            USER_MODULE;

        }
    }

    public static class Fault
    extends Exception {
        private static final long serialVersionUID = 1L;

        public Fault(String msg) {
            super(msg);
        }

        public Fault(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class ClassLocn {
        public final LibLocn lib;
        public final String optModule;
        public final String className;
        public final Path absSrcFile;
        public final Path absClsFile;

        ClassLocn(LibLocn lib, String optModule, String className, Path absSrcFile, Path absClsFile) {
            this.lib = lib;
            this.optModule = optModule;
            this.className = className;
            this.absSrcFile = absSrcFile;
            this.absClsFile = absClsFile;
        }

        public boolean isUpToDate() {
            return Files.exists(this.absClsFile, new LinkOption[0]) && Files.isReadable(this.absClsFile) && FileUtils.compareLastModifiedTimes(this.absClsFile, this.absSrcFile) > 0;
        }

        public String toString() {
            return "ClassLocn(" + this.lib.name + "," + this.optModule + "," + this.className + "," + this.absSrcFile + "," + this.absClsFile + ")";
        }
    }
}

