/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.config;

import com.sun.javatest.TestDescription;
import com.sun.javatest.TestFilter;
import com.sun.javatest.util.DynamicArray;

public class ObservableTestFilter
extends TestFilter {
    private TestFilter delegate;
    private TestFilter.Observer[] observers = new TestFilter.Observer[0];

    ObservableTestFilter(TestFilter delegate) {
        if (delegate == null) {
            throw new NullPointerException();
        }
        this.delegate = delegate;
    }

    void addObserver(TestFilter.Observer o) {
        if (o == null) {
            throw new NullPointerException();
        }
        this.observers = DynamicArray.append(this.observers, o);
    }

    void removeObserver(TestFilter.Observer o) {
        this.observers = DynamicArray.remove(this.observers, o);
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public String getDescription() {
        return this.delegate.getDescription();
    }

    @Override
    public String getReason() {
        return this.delegate.getReason();
    }

    @Override
    public boolean accepts(TestDescription td) throws TestFilter.Fault {
        if (this.delegate.accepts(td)) {
            return true;
        }
        TestFilter.Observer[] stableObservers = this.observers;
        for (int i = stableObservers.length - 1; i >= 0; --i) {
            stableObservers[i].rejected(td, this);
        }
        return false;
    }
}

