/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.TestDescription;
import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.agent.Flags;
import com.sun.javatest.regtest.config.ExecMode;
import com.sun.javatest.regtest.config.RegressionParameters;
import com.sun.javatest.regtest.exec.Agent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;

abstract class ScratchDirectory {
    private static final boolean verboseScratchDir = Flags.get("verboseScratchDir");
    protected final RegressionParameters params;
    protected final TestDescription td;
    File dir;
    private static final Set<File> badDirs = new HashSet<File>();
    private static final int RETRY_DELETE_MILLIS;
    private static final int MAX_RETRY_DELETE_MILLIS;
    private static final String CANT_CLEAN = "Can't clean ";
    private static final String CANT_CREATE = "Can't create ";
    private static final String CANT_SAVE = "Can't save files in ";
    private static final String SECMGR_EXC = "Problem deleting file: ";
    private static final String CANON_FILE_EXC = "Problem determining canonical file: ";

    static ScratchDirectory get(RegressionParameters params, ExecMode mode, TestDescription td) {
        if (mode == ExecMode.OTHERVM && params.isRetainEnabled()) {
            return new TestResultScratchDir(params, td);
        }
        return new ThreadSafeScratchDir(params, td);
    }

    protected ScratchDirectory(RegressionParameters params, TestDescription td, File dir) {
        this.params = params;
        this.td = td;
        this.dir = dir;
    }

    void init(PrintWriter log) throws Fault, InterruptedException {
        if (this.dir.exists()) {
            try {
                this.deleteFiles(this.dir, null, false, log);
            }
            catch (Fault e) {
                ScratchDirectory.addBadDir(this.dir);
                Agent.Pool.close(this.params, this.dir);
                throw e;
            }
        } else if (!this.dir.mkdirs()) {
            throw new Fault(CANT_CREATE + this.dir);
        }
    }

    private static synchronized boolean isBadDir(File dir) {
        return badDirs.contains(dir);
    }

    private static synchronized void addBadDir(File dir) {
        badDirs.add(dir);
    }

    abstract void retainFiles(Status var1, PrintWriter var2) throws Fault, InterruptedException;

    boolean retainFile(File file, File dest) {
        File f = new File(this.dir, file.getPath());
        File d = this.params.getWorkDirectory().getFile(dest.getPath());
        return f.renameTo(d);
    }

    protected void deleteFiles(File dir, Pattern p, boolean match, PrintWriter log) throws Fault, InterruptedException {
        if (ScratchDirectory.isBadDir(dir)) {
            throw new Fault(CANT_CLEAN + dir);
        }
        try {
            if (!dir.exists()) {
                if (verboseScratchDir) {
                    log.println("WARNING: dir " + dir + " already deleted.");
                }
                return;
            }
            this.deleteFilesWithRetry(dir, p, match, log);
        }
        catch (SecurityException e) {
            throw new Fault(SECMGR_EXC + dir, e);
        }
    }

    private void deleteFilesWithRetry(File dir, Pattern p, boolean match, PrintWriter log) throws Fault, InterruptedException {
        long startTime = System.currentTimeMillis();
        LinkedHashSet<File> cantDelete = new LinkedHashSet<File>();
        do {
            if (this.deleteFiles(dir, p, match, false, cantDelete, log)) {
                return;
            }
            System.gc();
            Thread.sleep(RETRY_DELETE_MILLIS);
        } while (System.currentTimeMillis() - startTime <= (long)MAX_RETRY_DELETE_MILLIS);
        for (File f : cantDelete) {
            log.println("Can't delete " + f);
        }
        throw new Fault(CANT_CLEAN + dir);
    }

    private boolean deleteFiles(File dir, Pattern p, boolean match, boolean deleteDir, Set<File> badFiles, PrintWriter log) throws Fault, InterruptedException {
        if (!dir.exists()) {
            return true;
        }
        boolean ok = true;
        File[] children = dir.listFiles();
        if (children == null) {
            log.println("warning: cannot list contents of directory " + dir);
            ok = false;
        } else {
            for (File file : children) {
                boolean deleteFile;
                if (ScratchDirectory.isDirectory(file)) {
                    ok &= this.deleteFiles(file, p, match, true, badFiles, log);
                    continue;
                }
                boolean bl = deleteFile = p == null || p.matcher(file.getName()).matches() == match;
                if (!deleteFile || this.delete(file, badFiles, log)) continue;
                ok = false;
            }
        }
        if (ok && ScratchDirectory.isEmpty(dir, log) && deleteDir) {
            ok = this.delete(dir, badFiles, log);
        }
        return ok;
    }

    private boolean delete(File f, Set<File> cantDelete, PrintWriter log) {
        if (f.delete() && !f.exists()) {
            cantDelete.remove(f);
            return true;
        }
        File dir = f.getParentFile();
        if (dir != null && !dir.canWrite() && this.setWritable(dir, log)) {
            return this.delete(f, cantDelete, log);
        }
        if (verboseScratchDir) {
            log.println("warning: failed to delete " + (f.isDirectory() ? "directory " : "") + f);
        }
        cantDelete.add(f);
        return false;
    }

    private boolean setWritable(File dir, PrintWriter log) {
        if (dir.setWritable(true)) {
            return true;
        }
        File parent = dir.getParentFile();
        if (parent != null && !parent.canWrite() && this.setWritable(parent, log)) {
            return this.setWritable(dir, log);
        }
        if (verboseScratchDir) {
            log.println("warning: failed to set directory writable: " + dir);
        }
        return false;
    }

    protected boolean saveFiles(File fromDir, File toDir, Pattern p, boolean match, PrintWriter log) throws InterruptedException {
        File[] children;
        boolean result = true;
        boolean toDirExists = toDir.exists();
        if (toDirExists) {
            try {
                this.deleteFiles(toDir, null, false, log);
            }
            catch (Fault e) {
                log.println("warning: could not empty " + toDir + ": " + e.getMessage());
            }
        }
        if ((children = fromDir.listFiles()) == null) {
            log.println("warning: cannot list contents of directory " + fromDir);
            return result;
        }
        for (File file : children) {
            boolean ok;
            File dest;
            boolean save;
            String fileName = file.getName();
            if (file.isDirectory()) {
                File dest2 = new File(toDir, fileName);
                result &= this.saveFiles(file, dest2, p, match, log);
                continue;
            }
            boolean bl = save = p == null || p.matcher(fileName).matches() == match;
            if (!save) continue;
            if (!toDirExists) {
                toDir.mkdirs();
                toDirExists = toDir.exists();
            }
            if ((dest = new File(toDir, fileName)).exists()) {
                dest.delete();
            }
            if (ok = file.renameTo(dest)) continue;
            log.println("error: failed to rename " + file + " to " + dest);
            result = false;
        }
        return result;
    }

    private static boolean isDirectory(File dir) throws Fault {
        try {
            return dir.isDirectory() && dir.equals(dir.getCanonicalFile());
        }
        catch (IOException e) {
            throw new Fault(CANON_FILE_EXC + dir, e);
        }
    }

    private static boolean isEmpty(File dir, PrintWriter log) {
        if (!dir.isDirectory()) {
            return false;
        }
        File[] children = dir.listFiles();
        if (children == null) {
            log.println("warning: cannot list contents of directory " + dir);
            return false;
        }
        return children.length == 0;
    }

    protected static File getResultDir(RegressionParameters params, TestDescription td) {
        String wrp = TestResult.getWorkRelativePath(td);
        if (wrp.endsWith(".jtr")) {
            wrp = wrp.substring(0, wrp.length() - 4);
        }
        return params.getWorkDirectory().getFile(wrp);
    }

    static {
        boolean isWindows = System.getProperty("os.name").startsWith("Windows");
        RETRY_DELETE_MILLIS = isWindows ? 500 : 0;
        MAX_RETRY_DELETE_MILLIS = isWindows ? 15000 : 0;
    }

    static class TestResultScratchDir
    extends ScratchDirectory {
        TestResultScratchDir(RegressionParameters params, TestDescription td) {
            super(params, td, TestResultScratchDir.getResultDir(params, td));
        }

        @Override
        void retainFiles(Status status, PrintWriter log) throws Fault, InterruptedException {
            if (!this.params.getRetainStatus().contains(status.getType())) {
                Pattern rp = this.params.getRetainFilesPattern();
                if (rp != null) {
                    Pattern rp_jtr = Pattern.compile(".*\\.jtr|" + rp.pattern());
                    this.deleteFiles(this.dir, rp_jtr, false, log);
                } else {
                    Pattern jtr = Pattern.compile(".*\\.jtr");
                    this.deleteFiles(this.dir, jtr, false, log);
                }
            }
        }
    }

    static class ThreadSafeScratchDir
    extends SimpleScratchDirectory {
        private static ThreadLocal<ThreadInfo> threadInfo = new ThreadLocal<ThreadInfo>(){

            @Override
            public ThreadInfo initialValue() {
                return new ThreadInfo();
            }
        };

        ThreadSafeScratchDir(RegressionParameters params, TestDescription td) {
            super(params, td, threadInfo.get().getDir(params));
        }

        @Override
        void init(PrintWriter log) throws Fault, InterruptedException {
            try {
                super.init(log);
            }
            catch (Fault e) {
                this.useNextDir();
                super.init(log);
            }
        }

        @Override
        void retainFiles(Status status, PrintWriter log) throws InterruptedException, Fault {
            try {
                super.retainFiles(status, log);
            }
            catch (Fault f) {
                this.useNextDir();
                throw f;
            }
        }

        private void useNextDir() {
            this.dir = threadInfo.get().getNextDir(this.params);
        }

        private static class ThreadInfo {
            private static AtomicInteger counter = new AtomicInteger();
            final int threadNum = counter.getAndIncrement();
            int serial = 0;

            ThreadInfo() {
            }

            File getDir(RegressionParameters params) {
                Object name = "scratch";
                if (params.getConcurrency() > 1) {
                    name = (String)name + File.separator + this.threadNum;
                }
                if (this.serial > 0) {
                    name = (String)name + "_" + this.serial;
                }
                return params.getWorkDirectory().getFile((String)name);
            }

            File getNextDir(RegressionParameters params) {
                ++this.serial;
                return this.getDir(params);
            }
        }
    }

    static class Fault
    extends Exception {
        private static final long serialVersionUID = 0L;

        Fault(String msg) {
            super(msg);
        }

        Fault(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    static class SimpleScratchDirectory
    extends ScratchDirectory {
        SimpleScratchDirectory(RegressionParameters params, TestDescription td) {
            this(params, td, params.getWorkDirectory().getFile("scratch"));
        }

        protected SimpleScratchDirectory(RegressionParameters params, TestDescription td, File dir) {
            super(params, td, dir);
        }

        @Override
        void retainFiles(Status status, PrintWriter log) throws InterruptedException, Fault {
            Pattern rp;
            File resultDir = SimpleScratchDirectory.getResultDir(this.params, this.td);
            boolean ok = this.params.getRetainStatus().contains(status.getType()) ? this.saveFiles(this.dir, resultDir, null, false, log) : ((rp = this.params.getRetainFilesPattern()) != null ? this.saveFiles(this.dir, resultDir, rp, true, log) : true);
            if (!ok) {
                throw new Fault(ScratchDirectory.CANT_SAVE + this.dir);
            }
            this.deleteFiles(this.dir, null, false, log);
        }
    }
}

