/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.Status;
import com.sun.javatest.regtest.RStatus;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.config.Locations;
import com.sun.javatest.regtest.config.Modules;
import com.sun.javatest.regtest.config.OS;
import com.sun.javatest.regtest.config.ParseException;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.ProcessCommand;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.TestRunException;
import com.sun.javatest.regtest.util.StringUtils;
import java.io.File;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class ShellAction
extends Action {
    public static final String NAME = "shell";
    private static final String sep = ShellAction.getSeparator();
    private String shellFN;
    private List<String> shellArgs;
    private boolean reverseStatus = false;
    private int timeout = -1;
    private String manual = "unset";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void init(Map<String, String> opts, List<String> args, String reason, RegressionScript script) throws ParseException {
        super.init(opts, args, reason, script);
        if (args.isEmpty()) {
            throw new ParseException("No script name provided for `shell'");
        }
        block10: for (Map.Entry<String, String> e : opts.entrySet()) {
            String optName = e.getKey();
            String optValue = e.getValue();
            switch (optName) {
                case "fail": {
                    this.reverseStatus = this.parseFail(optValue);
                    continue block10;
                }
                case "timeout": {
                    this.timeout = this.parseTimeout(optValue);
                    continue block10;
                }
                case "manual": {
                    this.manual = this.parseShellManual(optValue);
                    continue block10;
                }
            }
            throw new ParseException("Bad option for shell: " + optName);
        }
        if (this.manual.equals("unset")) {
            if (this.timeout < 0) {
                this.timeout = script.getActionTimeout(-1);
            }
        } else {
            if (this.timeout >= 0) {
                throw new ParseException("`/manual' disables use of `/timeout'");
            }
            this.timeout = 0;
        }
        this.shellFN = args.get(0);
        this.shellArgs = new ArrayList<String>();
        StringBuilder curr = null;
        for (int i = 1; i < args.size(); ++i) {
            if (curr == null) {
                curr = new StringBuilder(args.get(i));
            } else {
                curr.append(" ").append(args.get(i));
            }
            if (!ShellAction.isEvenQuotes(curr)) continue;
            this.shellArgs.add(curr.toString().replace("'", ""));
            curr = null;
        }
        if (curr != null) {
            this.shellArgs.add(curr.toString());
        }
    }

    private static boolean isEvenQuotes(StringBuilder s) {
        int n = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '\'') continue;
            ++n;
        }
        return n % 2 == 0;
    }

    @Override
    public Set<File> getSourceFiles() {
        return Set.of(this.script.absTestSrcDir().resolve(this.shellFN).toFile());
    }

    @Override
    protected boolean supportsExclusiveAccess() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Status run() throws TestRunException {
        Status status;
        this.startAction(false);
        File shellFile = this.script.absTestSrcDir().resolve(this.shellFN).toFile();
        if (!shellFile.exists()) {
            throw new TestRunException("Can't find source file: " + shellFile);
        }
        if (this.script.isCheck()) {
            status = RStatus.passed("Test description appears acceptable");
        } else {
            String testQuery;
            Path nativeDir;
            ShellAction.mkdirs(this.script.absTestClsDir().toFile());
            LinkedHashMap<String, String> env = new LinkedHashMap<String, String>();
            env.putAll(this.getEnvVars(true));
            Locations locations = this.script.locations;
            env.put("TESTFILE", this.fixupSep(locations.absTestFile()));
            env.put("TESTSRC", this.fixupSep(locations.absTestSrcDir()));
            env.put("TESTSRCPATH", this.fixupSep(locations.absTestSrcPath()));
            env.put("TESTCLASSES", this.fixupSep(locations.absTestClsDir()));
            env.put("TESTCLASSPATH", this.fixupSep(locations.absTestClsPath()));
            env.put("COMPILEJAVA", this.fixupSep(this.script.getCompileJDK().getAbsolutePath()));
            env.put("TESTJAVA", this.fixupSep(this.script.getTestJDK().getAbsolutePath()));
            List<String> vmOpts = this.script.getTestVMOptions();
            env.put("TESTVMOPTS", this.fixupSep(StringUtils.join(vmOpts, " ")));
            List<String> toolVMOpts = this.script.getTestToolVMOptions();
            env.put("TESTTOOLVMOPTS", this.fixupSep(StringUtils.join(toolVMOpts, " ")));
            List<String> compilerOpts = this.script.getTestCompilerOptions();
            env.put("TESTJAVACOPTS", this.fixupSep(StringUtils.join(compilerOpts, " ")));
            List<String> javaOpts = this.script.getTestJavaOptions();
            env.put("TESTJAVAOPTS", this.fixupSep(StringUtils.join(javaOpts, " ")));
            env.put("TESTTIMEOUTFACTOR", String.valueOf(this.script.getTimeoutFactor()));
            env.put("TESTROOT", this.script.getTestRootDir().getPath());
            Modules modules = this.script.getModules();
            if (!modules.isEmpty()) {
                env.put("TESTMODULES", modules.toString());
            }
            if ((nativeDir = this.script.getNativeDir()) != null) {
                env.put("TESTNATIVEPATH", nativeDir.toAbsolutePath().toString());
            }
            if (this.script.enablePreview()) {
                env.put("TESTENABLEPREVIEW", "true");
            }
            if (this.script.disablePreview()) {
                env.put("TESTENABLEPREVIEW", "false");
            }
            if ((testQuery = this.script.getTestQuery()) != null) {
                env.put("TESTQUERY", testQuery);
            }
            ArrayList<String> command = new ArrayList<String>();
            if (this.script.useWindowsSubsystemForLinux()) {
                Path java_exe = this.script.getTestJDK().getHomeDirectory().resolve("bin").resolve("java.exe");
                env.put("NULL", "/dev/null");
                if (Files.exists(java_exe, new LinkOption[0])) {
                    env.put("EXE_SUFFIX", ".exe");
                    env.put("FS", "/");
                    env.put("PS", File.pathSeparator);
                    env.put("WSLENV", this.getWSLENV(env, true));
                } else {
                    env.put("FS", "/");
                    env.put("PS", ";");
                    env.put("WSLENV", this.getWSLENV(env, false));
                }
                command.add("wsl.exe");
                command.add("sh");
                command.add(this.getWSLPath(shellFile));
            } else {
                String FS = File.separator;
                String PS = File.pathSeparator;
                String NULL = "/dev/null";
                if (OS.current().family.equals("windows")) {
                    if (System.getenv("PATH").contains("/cygwin")) {
                        FS = "/";
                    } else {
                        NULL = "NUL";
                    }
                }
                env.put("FS", FS);
                env.put("PS", PS);
                env.put("NULL", NULL);
                command.add("sh");
                command.add(shellFile.getPath());
            }
            command.addAll(this.shellArgs);
            PrintWriter sysOut = this.section.createOutput("System.out");
            PrintWriter sysErr = this.section.createOutput("System.err");
            try {
                if (showCmd) {
                    this.showCmd(NAME, command, this.section);
                }
                this.recorder.exec(command, env);
                TimeoutHandler timeoutHandler = this.script.getTimeoutHandlerProvider().createHandler(this.getClass(), this.script, this.section);
                ProcessCommand cmd = new ProcessCommand().setMessageWriter(this.section.getMessageWriter()).setExecDir(this.script.absTestScratchDir().toFile()).setCommand(command).setEnvironment(env).setStreams(sysOut, sysErr).setTimeout(this.timeout, TimeUnit.SECONDS).setTimeoutHandler(timeoutHandler);
                status = RStatus.normalize(cmd.exec());
            }
            finally {
                if (sysOut != null) {
                    sysOut.close();
                }
                if (sysErr != null) {
                    sysErr.close();
                }
            }
            if (!status.isError()) {
                Object sr;
                boolean ok = status.isPassed();
                int st = status.getType();
                if (ok && this.reverseStatus) {
                    sr = "Execution passed unexpectedly";
                    st = 1;
                } else if (ok && !this.reverseStatus) {
                    sr = "Execution successful";
                } else if (!ok && this.reverseStatus) {
                    sr = "Execution failed as expected";
                    st = 0;
                } else {
                    sr = "Execution failed";
                }
                if (st == 1 && !status.getReason().equals("") && !status.getReason().equals("Execution successful")) {
                    sr = (String)sr + ": " + status.getReason();
                }
                status = RStatus.createStatus(st, (String)sr);
            }
        }
        this.endAction(status);
        return status;
    }

    private String fixupSep(List<Path> files) {
        StringBuilder sb = new StringBuilder();
        for (Path f : files) {
            if (sb.length() > 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(this.fixupSep(f));
        }
        return sb.toString();
    }

    private String fixupSep(Path f) {
        return this.fixupSep(f.toString());
    }

    private String fixupSep(File f) {
        return this.fixupSep(f.getPath());
    }

    private String fixupSep(String s) {
        return sep == null ? s : s.replace(File.separator, sep);
    }

    private static String getSeparator() {
        return File.separatorChar == '\\' ? System.getProperty("javatest.shell.separator", "/") : null;
    }

    private String parseShellManual(String value) throws ParseException {
        if (value != null) {
            throw new ParseException("Arguments to `manual' option not supported: " + value);
        }
        value = "novalue";
        return value;
    }

    private String getWSLENV(Map<String, String> env, boolean targetIsWindows) {
        StringBuilder sb = new StringBuilder();
        String sep = "";
        Iterator<String> iterator = env.keySet().iterator();
        block15: while (iterator.hasNext()) {
            String suffix;
            String name;
            switch (name = iterator.next()) {
                case "COMPILEJAVA": 
                case "TESTJAVA": 
                case "TESTROOT": {
                    suffix = "/p";
                    break;
                }
                case "TESTSRC": 
                case "TESTCLASSES": {
                    suffix = targetIsWindows ? "" : "/p";
                    break;
                }
                case "TESTSRCPATH": 
                case "TESTCLASSPATH": 
                case "TESTNATIVEPATH": {
                    suffix = targetIsWindows ? "" : "/l";
                    break;
                }
                default: {
                    if (name.equalsIgnoreCase("PATH")) continue block15;
                    suffix = "";
                }
            }
            sb.append(sep).append(name).append(suffix);
            sep = ":";
        }
        return sb.toString();
    }

    private String getWSLPath(File file) {
        Path path = file.toPath().toAbsolutePath();
        char driveLetter = Character.toLowerCase(path.getRoot().toString().charAt(0));
        StringBuilder result = new StringBuilder();
        result.append("/mnt/").append(driveLetter);
        for (Path pathElement : path) {
            result.append("/").append(pathElement);
        }
        return result.toString();
    }
}

