/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.exec;

import com.sun.javatest.TestResult;
import com.sun.javatest.regtest.TimeoutHandler;
import com.sun.javatest.regtest.exec.Action;
import com.sun.javatest.regtest.exec.DefaultTimeoutHandler;
import com.sun.javatest.regtest.exec.RegressionScript;
import com.sun.javatest.regtest.exec.ShellAction;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.List;

public class TimeoutHandlerProvider {
    private String className;
    private ClassLoader loader;
    private static final long defaultTimeout = 300L;
    private long timeout = 300L;

    public void setClassName(String name) {
        this.className = name;
    }

    public void setClassPath(List<Path> path) throws MalformedURLException {
        URL[] urls = new URL[path.size()];
        int u = 0;
        for (Path f : path) {
            urls[u++] = f.toUri().toURL();
        }
        this.loader = new URLClassLoader(urls);
    }

    private Class<? extends TimeoutHandler> loadClass() throws ClassNotFoundException {
        Class<?> handlerClass = this.loader == null ? Class.forName(this.className) : Class.forName(this.className, true, this.loader);
        return handlerClass.asSubclass(TimeoutHandler.class);
    }

    public TimeoutHandler createHandler(Class<? extends Action> actionClass, RegressionScript script, TestResult.Section section) {
        PrintWriter log = section.getMessageWriter();
        File outDir = script.absTestScratchDir().toFile();
        Path testJDK = script.getTestJDK().getAbsoluteHomeDirectory();
        if (this.className != null) {
            try {
                Class<? extends TimeoutHandler> clz = this.loadClass();
                Constructor<? extends TimeoutHandler> ctor = clz.getDeclaredConstructor(PrintWriter.class, File.class, File.class);
                TimeoutHandler th = ctor.newInstance(log, outDir, testJDK.toFile());
                th.setTimeout(this.timeout);
                return th;
            }
            catch (Exception ex) {
                log.println("Failed to instantiate timeout handler: " + this.className);
                ex.printStackTrace(log);
                log.println("Reverting to the default timeout handler.");
            }
        }
        if (actionClass == ShellAction.class) {
            return null;
        }
        return new DefaultTimeoutHandler(log, outDir, testJDK);
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout == -1L ? 300L : timeout;
    }

    public long getTimeout() {
        return this.timeout;
    }
}

