/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ExcludeFileVerifier {
    private PrintWriter out;
    private boolean hadErrors = false;

    public ExcludeFileVerifier(PrintWriter out) {
        this.out = out;
    }

    public boolean getHadErrors() {
        return this.hadErrors;
    }

    public boolean verify(File file, List<String> validTestNames) {
        ArrayList<String> usedTestNames = new ArrayList<String>();
        ArrayList<Check> checks = new ArrayList<Check>();
        checks.add(new LineFormatCheck());
        checks.add(new TestExistsCheck(validTestNames));
        checks.add(new DuplicateCheck(usedTestNames));
        try {
            BufferedReader br = new BufferedReader(new FileReader(file));
            String line = null;
            int n = 0;
            while ((line = br.readLine()) != null) {
                ++n;
                if (ExcludeFileVerifier.lineIsComment(line.trim())) continue;
                for (Check c : checks) {
                    if (c.check(line.trim())) continue;
                    this.out.println(file.getAbsolutePath() + " line " + n + " is invalid. Reason:");
                    this.out.println(c.description());
                    this.out.println("Line contents:");
                    this.out.println("--------------");
                    this.out.println(line);
                    this.out.println("--------------");
                    this.hadErrors = true;
                    break;
                }
                usedTestNames.add(ExcludeFileVerifier.testName(line));
            }
        }
        catch (FileNotFoundException e) {
            System.out.println("File does not exist: " + file.getAbsolutePath());
        }
        catch (IOException e) {
            System.out.println("File cannot be read: " + file.getAbsolutePath());
        }
        return true;
    }

    static boolean lineIsComment(String line) {
        return line.isBlank() || line.trim().startsWith("#");
    }

    private static String testName(String line) {
        String[] words = (line = line.trim()).split("\\s+");
        return words.length >= 1 ? words[0] : null;
    }

    static class LineFormatCheck
    extends Check {
        private static final String commalist = "([\\w-]+)(,[\\w-]+)*";
        private static Pattern pattern = Pattern.compile("\\S+\\s+([\\w-]+)(,[\\w-]+)*\\s+([\\w-]+)(,[\\w-]+)*.*");

        LineFormatCheck() {
        }

        @Override
        public String description() {
            return "Must follow: <test-name> <bugid>(,<bugid>)* <platform>(,<platform>)* <description>";
        }

        @Override
        public boolean check(String line) {
            return pattern.matcher(line).matches();
        }
    }

    static class TestExistsCheck
    extends Check {
        private List<String> validTestNames;

        public TestExistsCheck(List<String> validTestNames) {
            this.validTestNames = validTestNames;
        }

        @Override
        public String description() {
            return "The fully qualified test must exist.";
        }

        @Override
        public boolean check(String line) {
            return this.validTestNames.contains(ExcludeFileVerifier.testName(line));
        }
    }

    static class DuplicateCheck
    extends Check {
        private List<String> usedTestNames;

        public DuplicateCheck(List<String> usedTestNames) {
            this.usedTestNames = usedTestNames;
        }

        @Override
        public String description() {
            return "Exclude file cannot contain duplicate entries.";
        }

        @Override
        public boolean check(String line) {
            return !this.usedTestNames.contains(ExcludeFileVerifier.testName(line));
        }
    }

    static abstract class Check {
        Check() {
        }

        public abstract String description();

        public abstract boolean check(String var1);
    }
}

