/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.agent.SearchPath;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.Tool;
import com.sun.javatest.regtest.tool.Version;
import com.sun.javatest.util.HelpTree;
import com.sun.javatest.util.I18NResourceBundle;
import com.sun.javatest.util.WrapWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.stream.Collectors;

public class Help {
    private final List<Option> options;
    private final List<VersionHelper> versionHelpers = new ArrayList<VersionHelper>();
    private boolean releaseNotesFlag;
    private boolean tagSpecFlag;
    private boolean versionFlag;
    private List<String> commandLineHelpQuery;
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Help.class);

    public Help(List<Option> options) {
        this.options = options;
    }

    boolean isEnabled() {
        return this.versionFlag || this.releaseNotesFlag || this.tagSpecFlag || this.commandLineHelpQuery != null;
    }

    void addVersionHelper(VersionHelper h) {
        this.versionHelpers.add(h);
    }

    void addPathVersionHelper(String name, SearchPath path) {
        this.addVersionHelper(out -> {
            out.println(name + ": " + path.asList().stream().map(Path::getFileName).map(Object::toString).collect(Collectors.joining(", ")));
            try {
                for (Path jar : path.asList()) {
                    String fn = jar.getFileName().toString();
                    if (fn.matches("(?i)[a-z0-9-_]+-[0-9](\\.[0-9]+)+\\.jar")) continue;
                    try (JarFile j = new JarFile(jar.toFile());){
                        Attributes attrs = j.getManifest().getMainAttributes();
                        String v = attrs.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
                        if (v == null) {
                            v = attrs.getValue("Bundle-Version");
                        }
                        String suffix = path.asList().size() == 1 ? "" : " (" + jar.getFileName() + ")";
                        out.println(name + suffix + ": version " + (v == null ? "unknown" : v));
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        });
    }

    void setVersionFlag(boolean yes) {
        this.versionFlag = yes;
    }

    void setReleaseNotes(boolean yes) {
        this.releaseNotesFlag = yes;
    }

    void setTagSpec(boolean yes) {
        this.tagSpecFlag = yes;
    }

    void setCommandLineHelpQuery(String query) {
        if (this.commandLineHelpQuery == null) {
            this.commandLineHelpQuery = new ArrayList<String>();
        }
        if (query != null && query.trim().length() > 0) {
            this.commandLineHelpQuery.addAll(List.of(query.trim().split("\\s+")));
        }
    }

    void show(PrintStream out) {
        PrintWriter w = new PrintWriter(out);
        this.show(w);
        w.flush();
    }

    boolean show(PrintWriter out) {
        boolean gui = false;
        if (this.releaseNotesFlag) {
            this.showReleaseNotes(out);
        }
        if (this.tagSpecFlag) {
            this.showTagSpec(out);
        }
        if (this.versionFlag) {
            this.showVersion(out);
        }
        if (this.commandLineHelpQuery != null) {
            this.showCommandLineHelp(out);
        }
        return gui;
    }

    void showReleaseNotes(PrintWriter out) {
        File homeDir = this.getHomeDir();
        File notes = new File(homeDir, "README");
        if (notes.exists()) {
            out.println(i18n.getString("help.releaseNotes", (Object)notes.getAbsolutePath()));
        } else {
            out.println(i18n.getString("help.cantFindReleaseNotes"));
        }
    }

    void showTagSpec(PrintWriter out) {
        File docDir = this.getDocDir();
        File tagSpec = new File(docDir, "tag-spec.txt");
        try (BufferedReader in = new BufferedReader(new FileReader(tagSpec));){
            String line;
            while ((line = in.readLine()) != null) {
                out.println(line);
            }
        }
        catch (FileNotFoundException e) {
            out.println(i18n.getString("help.cantFindSpec"));
        }
        catch (IOException e) {
            out.println(i18n.getString("help.cantReadSpec", (Object)e));
        }
    }

    void showVersion(PrintWriter out) {
        Version v = Version.getCurrent();
        String unknown = i18n.getString("help.version.unknown");
        String prefix = "jtreg";
        String product = v.getProperty(prefix + "-Name", unknown);
        String versionString = v.versionString;
        if (versionString == null) {
            String version = v.getProperty(prefix + "-Version", unknown);
            String milestone = v.getProperty(prefix + "-Milestone", unknown);
            String build = v.getProperty(prefix + "-Build", unknown);
            versionString = String.format("version %s %s %s", version, milestone, build);
        }
        String buildJavaVersion = v.getProperty(prefix + "-BuildJavaVersion", unknown);
        String buildDate = v.getProperty(prefix + "-BuildDate", unknown);
        String thisJavaHome = System.getProperty("java.home");
        String thisJavaVersion = System.getProperty("java.version");
        File classPathFile = this.getClassPathFileForClass(Tool.class);
        String classPath = classPathFile == null ? unknown : classPathFile.getPath();
        DateFormat df = DateFormat.getDateInstance(1);
        Object[] versionArgs = new Object[]{product, versionString, classPath, thisJavaVersion, thisJavaHome, buildJavaVersion, buildDate};
        out.println(i18n.getString("help.version.txt", versionArgs));
        for (VersionHelper h : this.versionHelpers) {
            h.showVersion(out);
        }
    }

    private File getHomeDir() {
        File classPathFile = this.getClassPathFileForClass(Tool.class);
        if (classPathFile == null) {
            return null;
        }
        File lib = classPathFile.getParentFile();
        File home = lib.getParentFile();
        return home;
    }

    private File getDocDir() {
        File home = this.getHomeDir();
        File doc = new File(new File(home, "doc"), "jtreg");
        if (doc.exists()) {
            return doc;
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> c) {
        try {
            URL url = c.getResource("/" + c.getName().replace('.', '/') + ".class");
            if (url.getProtocol().equals("jar")) {
                String path = url.getPath();
                int sep = path.lastIndexOf("!");
                return new URL(path.substring(0, sep));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private File getClassPathFileForClass(Class<?> c) {
        URL url = this.getClassPathEntryForClass(c);
        if (url != null && url.getProtocol().equals("file")) {
            return new File(url.getPath());
        }
        return null;
    }

    private Properties getManifestForClass(Class<?> c) {
        URL classPathEntry = this.getClassPathEntryForClass(c);
        if (classPathEntry == null) {
            return null;
        }
        try {
            Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                int sep;
                String path;
                URL u;
                URL url = e.nextElement();
                if (!url.getProtocol().equals("jar") || !(u = new URL((path = url.getPath()).substring(0, sep = path.lastIndexOf("!")))).equals(classPathEntry)) continue;
                Properties p = new Properties();
                try (InputStream in = url.openStream();){
                    p.load(in);
                }
                return p;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void showCommandLineHelp(PrintWriter out) {
        Integer descIndent;
        HelpTree commandHelpTree = new HelpTree();
        try {
            Field f = HelpTree.class.getDeclaredField("nodeComparator");
            f.setAccessible(true);
            f.set(commandHelpTree, new NodeComparator());
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException f) {
            // empty catch block
        }
        Integer nodeIndent = Integer.getInteger("javatest.help.nodeIndent");
        if (nodeIndent != null) {
            commandHelpTree.setNodeIndent(nodeIndent);
        }
        if ((descIndent = Integer.getInteger("javatest.help.descIndent")) != null) {
            commandHelpTree.setDescriptionIndent(descIndent);
        }
        LinkedHashSet<String> groups = new LinkedHashSet<String>();
        for (Option option : this.options) {
            groups.add(option.group);
        }
        LinkedHashMap map = new LinkedHashMap();
        for (String g : groups) {
            map.put(g, new TreeMap(new CaseInsensitiveStringComparator()));
        }
        for (Option o : this.options) {
            if (o.names.length <= 0) continue;
            ((SortedMap)map.get(o.group)).put(o.names[0], o);
        }
        for (String g : groups) {
            SortedMap optionsForGroup = (SortedMap)map.get(g);
            if (optionsForGroup.isEmpty()) continue;
            ArrayList<HelpTree.Node> nodesForGroup = new ArrayList<HelpTree.Node>();
            for (Option o : optionsForGroup.values()) {
                nodesForGroup.add(this.createOptionHelpNode(o));
            }
            HelpTree.Node groupNode = new HelpTree.Node(i18n, "help." + g.toLowerCase(), nodesForGroup.toArray(new HelpTree.Node[0]));
            commandHelpTree.addNode(groupNode);
        }
        HelpTree.Node node = new HelpTree.Node(i18n, "help.tests", new HelpTree.Node(i18n, "help.tests", "at"), new HelpTree.Node(i18n, "help.tests", "groups"), new HelpTree.Node(i18n, "help.tests.summary", "directory", "file", "group", "at-file"));
        commandHelpTree.addNode(node);
        String progName = Help.getProgramName();
        try {
            WrapWriter ww = new WrapWriter(out);
            if (this.commandLineHelpQuery == null || this.commandLineHelpQuery.isEmpty()) {
                ww.write(i18n.getString("help.cmd.proto", (Object)progName));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.introHead"));
                ww.write('\n');
                commandHelpTree.writeSummary(ww);
            } else if (this.commandLineHelpQuery.contains("all")) {
                ww.write(i18n.getString("help.cmd.proto", (Object)progName));
                ww.write("\n\n");
                ww.write(i18n.getString("help.cmd.fullHead"));
                ww.write('\n');
                commandHelpTree.write(ww);
            } else {
                String[] query = this.commandLineHelpQuery.toArray(new String[0]);
                HelpTree.Selection s = commandHelpTree.find(query);
                if (s != null) {
                    commandHelpTree.write((Writer)ww, s);
                } else {
                    ww.write(i18n.getString("help.cmd.noEntriesFound"));
                    ww.write("\n\n");
                    ww.write(i18n.getString("help.cmd.summaryHead"));
                    ww.write('\n');
                    commandHelpTree.writeSummary(ww);
                }
            }
            ww.write("\n\n");
            ww.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HelpTree.Node createOptionHelpNode(Option o) {
        String prefix = "help." + o.group.toLowerCase() + "." + o.names[0].replaceAll("^-+", "").replaceAll("[^A-Za-z0-9.]+", "_");
        String arg = o.argType == Option.ArgType.NONE ? null : i18n.getString(prefix + ".arg");
        StringBuilder sb = new StringBuilder();
        block7: for (String n : o.names) {
            if (sb.length() > 0) {
                sb.append("  |  ");
            }
            sb.append(n);
            switch (o.argType) {
                case NONE: {
                    continue block7;
                }
                case OLD: 
                case STD: 
                case FILE: {
                    sb.append(":").append(arg);
                    continue block7;
                }
                case GNU: 
                case SEP: 
                case REST: {
                    sb.append(" ").append(arg);
                    continue block7;
                }
                case WILDCARD: {
                    sb.append(arg);
                    continue block7;
                }
                case OPT: {
                    sb.append("  |  -").append(n).append(":").append(arg);
                    continue block7;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }
        String name = sb.toString();
        String desc = i18n.getString(prefix + ".desc");
        String[] values = o.getChoices();
        if (values == null || values.length == 0) {
            return new HelpTree.Node(name, desc);
        }
        HelpTree.Node[] children = new HelpTree.Node[values.length];
        for (int i = 0; i < children.length; ++i) {
            children[i] = new HelpTree.Node(values[i], i18n.getString(prefix + "." + values[i] + ".desc"));
        }
        return new HelpTree.Node(name, desc, children);
    }

    private static String getProgramName() {
        String p = System.getProperty("program");
        if (p != null) {
            return p;
        }
        List<Path> cp = new SearchPath(System.getProperty("java.class.path")).asList();
        if (cp.size() == 1 && cp.get(0).getFileName().toString().equals("jtreg.jar")) {
            return "java -jar jtreg.jar ";
        }
        return "java " + Tool.class.getName();
    }

    static interface VersionHelper {
        public void showVersion(PrintWriter var1);
    }

    private static class NodeComparator
    implements Comparator<HelpTree.Node> {
        private NodeComparator() {
        }

        @Override
        public int compare(HelpTree.Node n1, HelpTree.Node n2) {
            int v = n1.getName().replaceAll("^-+", "").compareToIgnoreCase(n2.getName().replaceAll("^-+", ""));
            return v != 0 ? v : n1.getDescription().compareToIgnoreCase(n2.getDescription());
        }
    }

    private static class CaseInsensitiveStringComparator
    implements Comparator<String> {
        private CaseInsensitiveStringComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            if (s1 == null && s2 == null) {
                return 0;
            }
            if (s1 == null || s2 == null) {
                return s1 == null ? -1 : 1;
            }
            return s1.replaceAll("^-*", "").compareToIgnoreCase(s2.replaceAll("^-*", ""));
        }
    }
}

