/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import com.sun.javatest.regtest.BadArgs;
import com.sun.javatest.regtest.tool.Option;
import com.sun.javatest.regtest.tool.Tool;
import com.sun.javatest.util.I18NResourceBundle;
import java.nio.file.InvalidPathException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OptionDecoder {
    Pattern optPattern = Pattern.compile("(-[-A-Za-z0-9/]+)(?:([:=])(.*))?");
    private final Map<String, Option> simpleOptions = new HashMap<String, Option>();
    private final List<Option> matchOptions = new ArrayList<Option>();
    private Option fileOption;
    private final Map<String, String> locks = new HashMap<String, String>();
    private boolean inFiles;
    protected static boolean debugOptions = Boolean.getBoolean("javatest.regtest.debugOptions");
    private static final I18NResourceBundle i18n = I18NResourceBundle.getBundleForClass(Tool.class);

    public OptionDecoder(List<Option> options) {
        block5: for (Option o : options) {
            switch (o.argType) {
                case WILDCARD: {
                    this.matchOptions.add(o);
                    break;
                }
                case FILE: {
                    this.fileOption = o;
                    break;
                }
                case GNU: {
                    for (String n : o.names) {
                        this.simpleOptions.put(n.toLowerCase(Locale.US), o);
                        if (!n.matches("-[^-]")) continue;
                        this.matchOptions.add(o);
                    }
                    continue block5;
                }
                default: {
                    for (String n : o.names) {
                        this.simpleOptions.put(n.toLowerCase(Locale.US), o);
                    }
                    continue block5;
                }
            }
        }
    }

    public void decodeArgs(String[] args) throws BadArgs {
        this.decodeArgs(List.of(args));
    }

    public void decodeArgs(List<String> args) throws BadArgs {
        Iterator<String> iter = args.iterator();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (arg.length() == 0) {
                throw new BadArgs(i18n, "opt.empty", new Object[0]);
            }
            if (!arg.startsWith("-")) {
                this.inFiles = true;
            }
            if (this.inFiles) {
                this.fileOption.process(null, arg);
                continue;
            }
            this.decodeArg(arg, iter);
        }
    }

    private void decodeArg(String arg, Iterator<String> iter) throws BadArgs {
        Object value;
        String sep;
        String name;
        Matcher m = this.optPattern.matcher(arg);
        if (m.matches()) {
            name = m.group(1);
            sep = m.group(2);
            value = m.group(3);
        } else {
            name = arg;
            sep = null;
            value = null;
        }
        Option o = this.getOption(name);
        if (o == null) {
            throw new BadArgs(i18n, "opt.unknown", name);
        }
        switch (o.argType) {
            case NONE: {
                if (value == null) break;
                throw new BadArgs(i18n, "opt.unexpected.value", arg);
            }
            case GNU: {
                if (sep == null) {
                    if (name.startsWith("--") || name.length() == 2) {
                        if (iter.hasNext()) {
                            value = iter.next();
                            break;
                        }
                        throw new BadArgs(i18n, "opt.missing.value", arg);
                    }
                    value = arg.substring(2);
                    break;
                }
                if (name.startsWith("--") && sep.equals("=")) break;
                throw new BadArgs(i18n, "opt.bad.format", arg);
            }
            case STD: {
                if (value == null) {
                    throw new BadArgs(i18n, "opt.missing.value", arg);
                }
                if (sep == null || sep.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", arg);
            }
            case SEP: {
                if (value != null) {
                    throw new BadArgs(i18n, "opt.bad.format", arg);
                }
                if (iter.hasNext()) {
                    value = iter.next();
                    break;
                }
                throw new BadArgs(i18n, "opt.missing.value", arg);
            }
            case OLD: {
                if (value == null && iter.hasNext()) {
                    value = iter.next();
                }
                if (value == null) {
                    throw new BadArgs(i18n, "opt.missing.value", arg);
                }
                if (sep == null || sep.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", arg);
            }
            case OPT: {
                if (sep == null || sep.equals(":")) break;
                throw new BadArgs(i18n, "opt.bad.format", arg);
            }
            case WILDCARD: {
                value = o.getValue(arg);
                break;
            }
            case REST: {
                value = (String)(value == null ? "" : (String)value + " ") + OptionDecoder.join(iter, " ");
            }
        }
        this.checkConflicts(o, name);
        if (debugOptions) {
            System.err.println("OptionDecoder.decodeArg: " + name + " " + (String)value);
        }
        try {
            o.process(arg, (String)value);
        }
        catch (InvalidPathException e) {
            throw new BadArgs(i18n, "opt.bad.path.for.option", arg, e.getInput(), e.getMessage());
        }
    }

    public void addFile(String path) throws BadArgs {
        this.fileOption.process(null, path);
    }

    protected Option getOption(String name) {
        Option s = this.simpleOptions.get(name.toLowerCase());
        if (s != null) {
            return s;
        }
        for (Option m : this.matchOptions) {
            if (!m.matches(name)) continue;
            return m;
        }
        return null;
    }

    protected void checkConflicts(Option o, String name) throws BadArgs {
        if (o.lockName != null) {
            String prev = this.locks.get(o.lockName);
            if (prev != null) {
                if (prev.equals(name)) {
                    throw new BadArgs(i18n, "opt.duplicate", name);
                }
                throw new BadArgs(i18n, "opt.conflict", prev, name);
            }
            this.locks.put(o.lockName, name);
        }
    }

    private static String join(Iterator<?> iter, String sep) {
        StringBuilder sb = new StringBuilder();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(sep);
            }
            sb.append(iter.next());
        }
        return sb.toString();
    }
}

