/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.tool;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Version
implements Comparable<Version> {
    private static Version currentVersion;
    private Properties manifest;
    public final String versionString;
    public final String product;
    public final String version;
    public final String milestone;
    public final String build;
    public final String buildJavaVersion;
    public final String buildDate;

    public static Version getCurrent() {
        if (currentVersion == null) {
            currentVersion = new Version();
        }
        return currentVersion;
    }

    private Version() {
        this.manifest = this.getManifestForClass(this.getClass());
        if (this.manifest == null) {
            this.manifest = new Properties();
        }
        this.product = this.getManifestProperty("jtreg-Name");
        this.versionString = this.getManifestProperty("jtreg-VersionString");
        if (this.versionString == null) {
            this.version = this.getManifestProperty("jtreg-Version");
            this.milestone = this.getManifestProperty("jtreg-Milestone");
            this.build = this.getManifestProperty("jtreg-Build");
        } else {
            Runtime.Version v = Runtime.Version.parse(this.versionString);
            this.version = v.version().stream().map(Object::toString).collect(Collectors.joining("."));
            this.milestone = v.pre().orElse(null);
            this.build = v.build().isPresent() ? v.build().get().toString() : null;
        }
        this.buildJavaVersion = this.getManifestProperty("jtreg-BuildJavaVersion");
        this.buildDate = this.getManifestProperty("jtreg-BuildDate");
    }

    private String getManifestProperty(String key) {
        return System.getProperty("OVERRIDE-" + key, this.manifest.getProperty(key));
    }

    public Version(String versionAndBuild) {
        if (versionAndBuild != null) {
            Pattern versionPattern = Pattern.compile("(?<version>[0-9.]+)(\\s+b|\\+)(?<build>[0-9]+)");
            Matcher matcher = versionPattern.matcher(versionAndBuild);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(versionAndBuild);
            }
            this.versionString = null;
            this.version = matcher.group("version");
            this.build = matcher.group("build");
        } else {
            this.versionString = null;
            this.version = null;
            this.build = null;
        }
        this.product = null;
        this.milestone = null;
        this.buildJavaVersion = null;
        this.buildDate = null;
    }

    String getProperty(String name, String _default) {
        return this.manifest.getProperty(name, _default);
    }

    private Properties getManifestForClass(Class<?> c) {
        URL classPathEntry = this.getClassPathEntryForClass(c);
        if (classPathEntry == null) {
            return null;
        }
        try {
            Enumeration<URL> e = this.getClass().getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (e.hasMoreElements()) {
                int sep;
                String path;
                URL u;
                URL url = e.nextElement();
                if (!url.getProtocol().equals("jar") || !(u = new URL((path = url.getPath()).substring(0, sep = path.lastIndexOf("!")))).equals(classPathEntry)) continue;
                Properties p = new Properties();
                try (InputStream in = url.openStream();){
                    p.load(in);
                }
                return p;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    private URL getClassPathEntryForClass(Class<?> c) {
        try {
            URL url = c.getResource("/" + c.getName().replace('.', '/') + ".class");
            if (url.getProtocol().equals("jar")) {
                String path = url.getPath();
                int sep = path.lastIndexOf("!");
                return new URL(path.substring(0, sep));
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    private static int[] parseDottedInts(String s) {
        String[] elems = s.split("\\.");
        int[] result = new int[elems.length];
        for (int i = 0; i < elems.length; ++i) {
            result[i] = Integer.parseInt(elems[i]);
        }
        return result;
    }

    @Override
    public int compareTo(Version other) {
        if (this.version == null || other.version == null) {
            return 0;
        }
        int[] thisDots = Version.parseDottedInts(this.version);
        int[] otherDots = Version.parseDottedInts(other.version);
        for (int i = 0; i < Math.max(thisDots.length, otherDots.length); ++i) {
            int otherDot;
            int thisDot = i < thisDots.length ? thisDots[i] : 0;
            int n = otherDot = i < otherDots.length ? otherDots[i] : 0;
            if (thisDot > otherDot) {
                return 1;
            }
            if (thisDot >= otherDot) continue;
            return -1;
        }
        int thisBuild = this.getBuild();
        int otherBuild = other.getBuild();
        if (thisBuild == 0 || otherBuild == 0) {
            return 0;
        }
        return Integer.compare(thisBuild, otherBuild);
    }

    private int getBuild() {
        if (this.build == null) {
            return 0;
        }
        if (this.build.matches("b?[0-9]+")) {
            String b = this.build.startsWith("b") ? this.build.substring(1) : this.build;
            return Integer.parseInt(b);
        }
        return 0;
    }

    String getVersionBuildString() {
        return this.versionString != null ? this.versionString : String.format("%s+%s", this.version, this.build.replaceAll("^0+", ""));
    }

    public String toString() {
        ArrayList<CallSite> l = new ArrayList<CallSite>();
        if (this.versionString != null) {
            l.add((CallSite)((Object)("versionString=" + this.versionString)));
        }
        if (this.version != null) {
            l.add((CallSite)((Object)("version=" + this.version)));
        }
        if (this.milestone != null) {
            l.add((CallSite)((Object)("milestone=" + this.milestone)));
        }
        if (this.build != null) {
            l.add((CallSite)((Object)("build=" + this.build)));
        }
        return "Version[" + String.join((CharSequence)",", l) + "]";
    }
}

