/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.util;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FileUtils {
    private FileUtils() {
    }

    public static long size(Path p) throws NIOFileOperationException {
        try {
            return Files.size(p);
        }
        catch (IOException e) {
            throw new NIOFileOperationException(NIOFileOperationException.Op.SIZE, p, e);
        }
    }

    public static FileTime getLastModifiedTime(Path p) throws NIOFileOperationException {
        try {
            return Files.getLastModifiedTime(p, new LinkOption[0]);
        }
        catch (IOException e) {
            throw new NIOFileOperationException(NIOFileOperationException.Op.LAST_MOD, p, e);
        }
    }

    public static int compareLastModifiedTimes(Path p1, Path p2) {
        return FileUtils.getLastModifiedTime(p1).compareTo(FileUtils.getLastModifiedTime(p2));
    }

    public static void createDirectories(Path dir) {
        try {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new NIOFileOperationException(NIOFileOperationException.Op.MKDIRS, dir, e);
        }
    }

    public static List<Path> listFiles(Path dir) {
        ArrayList<Path> files = new ArrayList<Path>();
        try (DirectoryStream<Path> ds = Files.newDirectoryStream(dir);){
            for (Path p : ds) {
                files.add(p);
            }
        }
        catch (IOException e) {
            throw new NIOFileOperationException(NIOFileOperationException.Op.LIST, dir, e);
        }
        return files;
    }

    public static File[] toFiles(Path[] paths) {
        return Stream.of(paths).map(Path::toFile).collect(Collectors.toList()).toArray(new File[0]);
    }

    public static class NIOFileOperationException
    extends UncheckedIOException {
        private static final long serialVersionUID = 0L;

        NIOFileOperationException(Op op, Path p, IOException cause) {
            super(NIOFileOperationException.getMessage(op, p), cause);
        }

        private static String getMessage(Op op, Path p) {
            switch (op) {
                case MKDIRS: {
                    return "Cannot create directories for " + p;
                }
                case LAST_MOD: {
                    return "Cannot access last-modified time for " + p;
                }
                case LIST: {
                    return "Cannot list directory " + p;
                }
                case SIZE: {
                    return "Cannot determine size of file " + p;
                }
            }
            return "Cannot perform unknown operation for " + p;
        }

        static enum Op {
            MKDIRS,
            LAST_MOD,
            LIST,
            SIZE;

        }
    }
}

