/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.regtest.util;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Set;

public class GraphUtils {
    public static <D, N extends TarjanNode<D>> Set<? extends Set<? extends N>> tarjan(Iterable<? extends N> nodes) {
        LinkedHashSet<Set<N>> cycles = new LinkedHashSet<Set<N>>();
        LinkedList stack = new LinkedList();
        int index = 0;
        for (TarjanNode node : nodes) {
            if (node.index != -1) continue;
            index += GraphUtils.tarjan(node, index, stack, cycles);
        }
        return cycles;
    }

    private static <D, N extends TarjanNode<D>> int tarjan(N v, int index, LinkedList<N> stack, Set<Set<N>> cycles) {
        v.index = index;
        v.lowlink = index++;
        stack.addFirst(v);
        v.active = true;
        Iterator<TarjanNode<D>> iterator = v.getDependencies().iterator();
        while (iterator.hasNext()) {
            TarjanNode<D> nd;
            TarjanNode<D> n = nd = iterator.next();
            if (n.index == -1) {
                GraphUtils.tarjan(n, index, stack, cycles);
                v.lowlink = Math.min(v.lowlink, n.lowlink);
                continue;
            }
            if (!stack.contains(n)) continue;
            v.lowlink = Math.min(v.lowlink, n.index);
        }
        if (v.lowlink == v.index) {
            TarjanNode n;
            LinkedHashSet<TarjanNode> cycle = new LinkedHashSet<TarjanNode>();
            do {
                n = (TarjanNode)stack.removeFirst();
                n.active = false;
                cycle.add(n);
            } while (n != v);
            cycles.add(cycle);
        }
        return index;
    }

    public static <D> String toDot(Iterable<? extends TarjanNode<D>> nodes, String name, String header) {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("digraph %s {\n", name));
        buf.append(String.format("label = \"%s\";\n", header));
        for (TarjanNode<D> n : nodes) {
            buf.append(String.format("%s [label = \"%s\"];\n", n.hashCode(), n.toString()));
        }
        for (TarjanNode<D> from : nodes) {
            for (TarjanNode<D> to : from.getDependencies()) {
                buf.append(String.format("%s -> %s [label = \" %s \"];\n", from.hashCode(), to.hashCode(), from.printDependency(to)));
            }
        }
        buf.append("}\n");
        return buf.toString();
    }

    public static abstract class TarjanNode<D>
    extends Node<D>
    implements Comparable<TarjanNode<D>> {
        int index = -1;
        int lowlink;
        boolean active;

        public TarjanNode(D data) {
            super(data);
        }

        @Override
        public abstract Iterable<? extends TarjanNode<D>> getDependencies();

        @Override
        public int compareTo(TarjanNode<D> o) {
            return this.index < o.index ? -1 : (this.index == o.index ? 0 : 1);
        }
    }

    public static abstract class Node<D> {
        public final D data;

        public Node(D data) {
            this.data = data;
        }

        public abstract Iterable<? extends Node<D>> getDependencies();

        public abstract String printDependency(Node<D> var1);

        public String toString() {
            return this.data.toString();
        }
    }
}

