/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import org.openjdk.asmtools.common.EMessageKind;
import org.openjdk.asmtools.common.ILogger;
import org.openjdk.asmtools.common.ToolLogger;
import org.openjdk.asmtools.common.inputs.ToolInput;
import org.openjdk.asmtools.common.outputs.log.DualStreamToolOutput;

public class DecompilerLogger
extends ToolLogger
implements ILogger {
    private final LinkedHashSet<String> messages = new LinkedHashSet();
    private Consumer<String> addToContainer = msg -> {
        if (msg != null) {
            this.messages.add((String)msg);
        }
    };

    public DecompilerLogger(String programName, Class cls, DualStreamToolOutput outerLog) {
        super(programName, cls, outerLog);
    }

    @Override
    public void warning(String id, Object ... args) {
        String msg = this.getResourceString(id, args);
        msg = msg == null ? (EMessageKind.isFromResourceBundle(id) ? ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, "(I18NResourceBundle) The warning message '%s' not found", id, new Object[0]) : ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.WARNING, super.getProgramName(), String.format(id, args), new Object[0])) : ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.WARNING, super.getProgramName(), msg, new Object[0]);
        this.addToContainer.accept(msg);
    }

    @Override
    public void error(String id, Object ... args) {
        String msg = this.getResourceString(id, args);
        msg = msg == null ? (EMessageKind.isFromResourceBundle(id) ? ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), "(I18NResourceBundle) The error message '%s' not found", id) : ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), String.format(id, args), new Object[0])) : ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), msg, new Object[0]);
        this.addToContainer.accept(msg);
    }

    @Override
    public void info(String id, Object ... args) {
        String msg = this.getResourceString(id, args);
        msg = msg == null ? (EMessageKind.isFromResourceBundle(id) ? ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), "(I18NResourceBundle) The error message '%s' not found", id) : ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), String.format(id, args), new Object[0])) : ToolLogger.EMessageFormatter.SHORT.apply(EMessageKind.ERROR, super.getProgramName(), msg, new Object[0]);
        this.addToContainer.accept(msg);
    }

    @Override
    public void printErrorLn(String format, Object ... args) {
        String msg = args == null || args.length == 0 ? format : String.format(format, args);
        this.addToContainer.accept(msg);
    }

    @Override
    public void error(Throwable exception) {
        String msg = ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), exception.getMessage(), new Object[0]);
        this.addToContainer.accept(msg);
    }

    @Override
    public String getInfo(String id, Object ... args) {
        String message = this.getResourceString(id, args);
        if (message == null) {
            String msg = EMessageKind.isFromResourceBundle(id) ? ToolLogger.EMessageFormatter.VERBOSE.apply(EMessageKind.ERROR, super.getProgramName(), "(I18NResourceBundle) The error message '%s' not found", id) : (args == null || args.length == 0 ? id : String.format(id, args));
            this.addToContainer.accept(msg);
        }
        return message;
    }

    @Override
    public long getCount(EMessageKind kind) {
        return this.messages.stream().filter(msg -> msg.contains(kind.shortForm())).count();
    }

    public int registerTotalIssues(int rc, ToolInput toolInput) {
        int ret = 0;
        int nErrors = (int)this.getCount(EMessageKind.ERROR);
        int nWarnings = (int)this.getCount(EMessageKind.WARNING);
        if (nWarnings > 0 || nErrors > 0) {
            ret = Math.max(rc, nErrors);
            String sWarnings = nWarnings > 0 ? "%d warning(s)".formatted(nWarnings).concat(nErrors > 0 ? ", " : "") : "";
            String sErrors = nErrors > 0 ? "%d error(s) ".formatted(nErrors) : " ";
            this.info("err.count.issues", sWarnings, sErrors, toolInput);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() {
        if (!this.messages.isEmpty()) {
            DualStreamToolOutput output = this.getOutputs();
            for (String msg : this.messages) {
                output.printlne(msg);
            }
            DualStreamToolOutput dualStreamToolOutput = output;
            synchronized (dualStreamToolOutput) {
                output.flush();
                this.messages.clear();
            }
        }
    }

    @Override
    public void usage(List<String> usageIDs) {
        this.usage(usageIDs, id -> this.getInfo((String)id, new Object[0]));
    }

    @Override
    public void usage(List<String> usageIDs, Function<String, String> func) {
        for (String id : usageIDs) {
            int i;
            String[] lines;
            String s = func.apply(id);
            if (s == null) continue;
            Matcher m = usagePattern.matcher(s);
            if (m.find()) {
                this.println(String.format("  %-21s %s", m.group(1).trim(), m.group(2).trim()), new Object[0]);
                if (!s.contains("\n")) continue;
                lines = s.split("\\n");
                for (i = 1; i < lines.length; ++i) {
                    this.println(String.format("%s%s", " ".repeat(24), lines[i].trim()), new Object[0]);
                }
                continue;
            }
            lines = s.split("\\n");
            if (lines.length > 1 && lines[0].trim().startsWith("-")) {
                this.println(String.format("  %s", lines[0].trim()), new Object[0]);
                for (i = 1; i < lines.length; ++i) {
                    this.println(String.format("%s%s", " ".repeat(24), lines[i].trim()), new Object[0]);
                }
                continue;
            }
            this.println(s, new Object[0]);
        }
    }
}

