/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.outputs;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.file.FileSystems;
import java.nio.file.Paths;
import java.util.Optional;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.outputs.NamedToolOutput;

public class FSOutput
extends NamedToolOutput {
    private FSDestination destination;
    private File dir;
    private File file;
    private FileOutputStream fos;
    private PrintWriter pw;
    private static final String fileSeparator = FileSystems.getDefault().getSeparator();

    @Override
    public boolean isReady() {
        return this.pw != null;
    }

    public FSOutput setFile(File dir, String file) {
        if (this.dir == null) {
            this.dir = dir;
        }
        this.destination = FSDestination.FILE;
        this.setDestinationFileName(file);
        return this;
    }

    public FSOutput setDir(File dir) {
        this.dir = dir;
        if (this.destination == null) {
            this.destination = FSDestination.DIR;
        }
        return this;
    }

    public File getDir() {
        return this.dir;
    }

    public String toString() {
        String str = super.toString();
        if (this.dir != null && this.file != null) {
            str.concat(this.dir != null ? this.dir.toString() : "").concat(fileSeparator).concat(this.file != null ? this.file.toString() : "");
        }
        return str;
    }

    @Override
    public void printlns(String line) {
        this.pw.println(line);
    }

    @Override
    public void prints(String line) {
        this.pw.print(line);
    }

    @Override
    public void prints(char line) {
        this.pw.print(line);
    }

    @Override
    public void startClass(String fullyQualifiedName, Optional<String> fileExtension, Environment environment) throws IOException {
        Object fileName;
        String packageName;
        super.startClass(fullyQualifiedName, fileExtension, environment);
        int index = fullyQualifiedName.lastIndexOf(fileSeparator);
        if (index != -1) {
            packageName = environment.isIgnorePackage() ? "" : fullyQualifiedName.substring(0, index);
            fileName = fullyQualifiedName.substring(index + 1);
        } else {
            packageName = "";
            fileName = fullyQualifiedName;
        }
        String destinationFileName = this.getDestinationFileName();
        fileName = destinationFileName != null ? destinationFileName + fileExtension.orElse("") : (String)fileName + fileExtension.orElse("");
        if (this.dir == null) {
            environment.traceln("writing to %s %s".formatted(packageName, fileName), new Object[0]);
            this.file = new File(packageName, (String)fileName);
        } else {
            this.file = Paths.get(this.dir.getPath(), new String[]{packageName, fileName}).toFile();
            environment.traceln(() -> "writing -d %s = \"%s\"".formatted(this.dir.getPath(), this.file.getAbsolutePath()));
            File outDir = new File(this.file.getParent());
            if (!outDir.exists() && !outDir.mkdirs()) {
                environment.error("err.cannot.create", outDir.getPath());
                return;
            }
        }
        this.fos = new FileOutputStream(this.file);
        this.pw = new PrintWriter(new OutputStreamWriter(this.fos));
    }

    @Override
    public void finishClass(String fullyQualifiedName) throws IOException {
        super.finishClass(fullyQualifiedName);
        this.flush();
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        finally {
            if (this.fos != null) {
                this.fos.close();
            }
        }
    }

    @Override
    public void flush() {
        if (this.fos != null) {
            try {
                this.fos.flush();
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        return new DataOutputStream(new BufferedOutputStream(this.fos));
    }

    @Override
    public String getName() {
        return this.file != null ? this.file.toString() : "file stream";
    }

    public static enum FSDestination {
        FILE,
        DIR;

    }
}

