/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.asmtools.common.outputs;

import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.openjdk.asmtools.common.Environment;
import org.openjdk.asmtools.common.outputs.NamedToolOutput;

public class TextOutput
extends NamedToolOutput {
    private BiFunction<String, String, String> namedSourceOrnament;
    private final ArrayList<NamedSource> outputs = new ArrayList();
    private StringBuilder curClsStringBuilder;

    public ArrayList<NamedSource> getOutputs() {
        return this.outputs;
    }

    public String toString() {
        return this.outputs.stream().map(a -> a.toString()).collect(Collectors.joining(System.lineSeparator()));
    }

    @Override
    public DataOutputStream getDataOutputStream() throws FileNotFoundException {
        return null;
    }

    @Override
    public void startClass(String fullyQualifiedName, Optional<String> suffix, Environment logger) throws IOException {
        super.startClass(fullyQualifiedName, suffix, logger);
        this.curClsStringBuilder = new StringBuilder();
    }

    @Override
    public void finishClass(String fullyQualifiedName) throws IOException {
        String fqn = this.getCurrentClassName();
        if (fqn != null && !fqn.equals(fullyQualifiedName)) {
            throw new RuntimeException("Ended with a different class: %s; then %s was started.".formatted(fullyQualifiedName, fqn));
        }
        if (this.curClsStringBuilder != null) {
            this.outputs.add(new NamedSource(fullyQualifiedName, this.curClsStringBuilder.toString(), this.namedSourceOrnament));
        }
        super.finishClass(fullyQualifiedName);
        this.curClsStringBuilder = null;
    }

    public TextOutput setNamedSourceOrnament(BiFunction<String, String, String> namedSourceOrnament) {
        this.namedSourceOrnament = namedSourceOrnament;
        return this;
    }

    @Override
    public void printlns(String line) {
        this.curClsStringBuilder.append(line).append("\n");
    }

    @Override
    public void prints(String line) {
        this.curClsStringBuilder.append(line);
    }

    @Override
    public void prints(char line) {
        this.curClsStringBuilder.append(line);
    }

    @Override
    public void flush() {
    }

    @Override
    public String getName() {
        return "string";
    }

    public class NamedSource {
        private BiFunction<String, String, String> ornament = (fname, body) -> String.format("/**\n%s\n**/\n%s\n/**\n%s\n**/\n", fname, body, fname);
        private final String fullyQualifiedName;
        private final String body;

        public NamedSource(String fullyQualifiedName, String body2) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.body = body2;
        }

        public NamedSource(String fullyQualifiedName, String body2, BiFunction<String, String, String> ornament) {
            this.fullyQualifiedName = fullyQualifiedName;
            this.body = body2;
            this.ornament = ornament;
        }

        public NamedSource setOrnament(BiFunction<String, String, String> ornament) {
            this.ornament = ornament;
            return this;
        }

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public String getBody() {
            return this.body;
        }

        public String toString() {
            return this.ornament == null ? this.body : this.ornament.apply(this.fullyQualifiedName, this.body);
        }
    }
}

